/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.ui.switchuser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.acegisecurity.AccountExpiredException;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.AuthenticationCredentialsNotFoundException;
import net.sf.acegisecurity.AuthenticationException;
import net.sf.acegisecurity.CredentialsExpiredException;
import net.sf.acegisecurity.DisabledException;
import net.sf.acegisecurity.GrantedAuthority;
import net.sf.acegisecurity.UserDetails;
import net.sf.acegisecurity.context.SecurityContextHolder;
import net.sf.acegisecurity.event.authentication.AuthenticationSwitchUserEvent;
import net.sf.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import net.sf.acegisecurity.providers.dao.AuthenticationDao;
import net.sf.acegisecurity.providers.dao.UsernameNotFoundException;
import net.sf.acegisecurity.ui.WebAuthenticationDetails;
import net.sf.acegisecurity.ui.switchuser.SwitchUserGrantedAuthority;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.util.Assert;

public class SwitchUserProcessingFilter
implements Filter,
InitializingBean,
ApplicationEventPublisherAware {
    private static final Log logger = LogFactory.getLog((Class)(class$net$sf$acegisecurity$ui$switchuser$SwitchUserProcessingFilter == null ? (class$net$sf$acegisecurity$ui$switchuser$SwitchUserProcessingFilter = SwitchUserProcessingFilter.class$("net.sf.acegisecurity.ui.switchuser.SwitchUserProcessingFilter")) : class$net$sf$acegisecurity$ui$switchuser$SwitchUserProcessingFilter));
    public static final String ACEGI_SECURITY_SWITCH_USERNAME_KEY = "j_username";
    public static final String ROLE_PREVIOUS_ADMINISTRATOR = "ROLE_PREVIOUS_ADMINISTRATOR";
    private ApplicationEventPublisher eventPublisher;
    private AuthenticationDao authenticationDao;
    private String exitUserUrl = "/j_acegi_exit_user";
    private String switchUserUrl = "/j_acegi_switch_user";
    private String targetUrl;
    static /* synthetic */ Class class$net$sf$acegisecurity$ui$switchuser$SwitchUserProcessingFilter;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletRequest;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletResponse;

    public void setApplicationEventPublisher(ApplicationEventPublisher eventPublisher) throws BeansException {
        this.eventPublisher = eventPublisher;
    }

    public void setAuthenticationDao(AuthenticationDao authenticationDao) {
        this.authenticationDao = authenticationDao;
    }

    public void setExitUserUrl(String exitUserUrl) {
        this.exitUserUrl = exitUserUrl;
    }

    public void setSwitchUserUrl(String switchUserUrl) {
        this.switchUserUrl = switchUserUrl;
    }

    public void setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.hasLength((String)this.switchUserUrl, (String)"switchUserUrl must be specified");
        Assert.hasLength((String)this.exitUserUrl, (String)"exitUserUrl must be specified");
        Assert.hasLength((String)this.targetUrl, (String)"targetUrl must be specified");
        Assert.notNull((Object)this.authenticationDao, (String)"authenticationDao must be specified");
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Assert.isInstanceOf((Class)(class$javax$servlet$http$HttpServletRequest == null ? (class$javax$servlet$http$HttpServletRequest = SwitchUserProcessingFilter.class$("javax.servlet.http.HttpServletRequest")) : class$javax$servlet$http$HttpServletRequest), (Object)request);
        Assert.isInstanceOf((Class)(class$javax$servlet$http$HttpServletResponse == null ? (class$javax$servlet$http$HttpServletResponse = SwitchUserProcessingFilter.class$("javax.servlet.http.HttpServletResponse")) : class$javax$servlet$http$HttpServletResponse), (Object)response);
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (this.requiresSwitchUser(httpRequest)) {
            Authentication targetUser = this.attemptSwitchUser(httpRequest);
            SecurityContextHolder.getContext().setAuthentication(targetUser);
            httpResponse.sendRedirect(httpResponse.encodeRedirectURL(httpRequest.getContextPath() + this.targetUrl));
            return;
        }
        if (this.requiresExitUser(httpRequest)) {
            Authentication originalUser = this.attemptExitUser(httpRequest);
            SecurityContextHolder.getContext().setAuthentication(originalUser);
            httpResponse.sendRedirect(httpResponse.encodeRedirectURL(httpRequest.getContextPath() + this.targetUrl));
            return;
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig ignored) throws ServletException {
    }

    protected Authentication attemptExitUser(HttpServletRequest request) throws AuthenticationCredentialsNotFoundException {
        Authentication current = SecurityContextHolder.getContext().getAuthentication();
        if (null == current) {
            throw new AuthenticationCredentialsNotFoundException("No current user associated with this request!");
        }
        Authentication original = this.getSourceAuthentication(current);
        if (original == null) {
            logger.error((Object)"Could not find original user Authentication object!");
            throw new AuthenticationCredentialsNotFoundException("Could not find original Authentication object!");
        }
        UserDetails originalUser = null;
        Object obj = original.getPrincipal();
        if (obj != null && obj instanceof UserDetails) {
            originalUser = (UserDetails)obj;
        }
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent((ApplicationEvent)new AuthenticationSwitchUserEvent(current, originalUser));
        }
        return original;
    }

    protected Authentication attemptSwitchUser(HttpServletRequest request) throws AuthenticationException {
        UserDetails targetUser;
        UsernamePasswordAuthenticationToken targetUserRequest = null;
        String username = request.getParameter(ACEGI_SECURITY_SWITCH_USERNAME_KEY);
        if (username == null) {
            username = "";
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Attempt to switch to user [" + username + "]"));
        }
        if ((targetUser = this.authenticationDao.loadUserByUsername(username)) == null) {
            throw new UsernameNotFoundException("User [" + username + "] cannot be found!");
        }
        if (!targetUser.isEnabled()) {
            throw new DisabledException("User is disabled");
        }
        if (!targetUser.isAccountNonExpired()) {
            throw new AccountExpiredException("User account has expired");
        }
        if (!targetUser.isCredentialsNonExpired()) {
            throw new CredentialsExpiredException("User credentials expired");
        }
        targetUserRequest = this.createSwitchUserToken(request, username, targetUser);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Switch User Token [" + targetUserRequest + "]"));
        }
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent((ApplicationEvent)new AuthenticationSwitchUserEvent(SecurityContextHolder.getContext().getAuthentication(), targetUser));
        }
        return targetUserRequest;
    }

    protected boolean requiresExitUser(HttpServletRequest request) {
        String uri = SwitchUserProcessingFilter.stripUri(request);
        return uri.endsWith(request.getContextPath() + this.exitUserUrl);
    }

    protected boolean requiresSwitchUser(HttpServletRequest request) {
        String uri = SwitchUserProcessingFilter.stripUri(request);
        return uri.endsWith(request.getContextPath() + this.switchUserUrl);
    }

    private static String stripUri(HttpServletRequest request) {
        String uri = request.getRequestURI();
        int idx = uri.indexOf(59);
        if (idx > 0) {
            uri = uri.substring(0, idx);
        }
        return uri;
    }

    private Authentication getSourceAuthentication(Authentication current) {
        Authentication original = null;
        GrantedAuthority[] authorities = current.getAuthorities();
        for (int i = 0; i < authorities.length; ++i) {
            if (!(authorities[i] instanceof SwitchUserGrantedAuthority)) continue;
            original = ((SwitchUserGrantedAuthority)authorities[i]).getSource();
            logger.debug((Object)("Found original switch user granted authority [" + original + "]"));
        }
        return original;
    }

    private UsernamePasswordAuthenticationToken createSwitchUserToken(HttpServletRequest request, String username, UserDetails targetUser) {
        Authentication currentAuth = SecurityContextHolder.getContext().getAuthentication();
        SwitchUserGrantedAuthority switchAuthority = new SwitchUserGrantedAuthority(ROLE_PREVIOUS_ADMINISTRATOR, currentAuth);
        List<GrantedAuthority> orig = Arrays.asList(targetUser.getAuthorities());
        ArrayList<GrantedAuthority> newAuths = new ArrayList<GrantedAuthority>(orig);
        newAuths.add(switchAuthority);
        GrantedAuthority[] authorities = new GrantedAuthority[]{};
        authorities = newAuths.toArray(authorities);
        UsernamePasswordAuthenticationToken targetUserRequest = new UsernamePasswordAuthenticationToken(targetUser, targetUser.getPassword(), authorities);
        targetUserRequest.setDetails(new WebAuthenticationDetails(request));
        return targetUserRequest;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

