/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.ui.x509;

import java.io.IOException;
import java.security.cert.X509Certificate;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.AuthenticationException;
import net.sf.acegisecurity.AuthenticationManager;
import net.sf.acegisecurity.context.SecurityContextHolder;
import net.sf.acegisecurity.event.authentication.InteractiveAuthenticationSuccessEvent;
import net.sf.acegisecurity.providers.x509.X509AuthenticationToken;
import net.sf.acegisecurity.ui.WebAuthenticationDetails;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.util.Assert;

public class X509ProcessingFilter
implements Filter,
InitializingBean,
ApplicationEventPublisherAware {
    private static final Log logger = LogFactory.getLog((Class)(class$net$sf$acegisecurity$ui$x509$X509ProcessingFilter == null ? (class$net$sf$acegisecurity$ui$x509$X509ProcessingFilter = X509ProcessingFilter.class$("net.sf.acegisecurity.ui.x509.X509ProcessingFilter")) : class$net$sf$acegisecurity$ui$x509$X509ProcessingFilter));
    private ApplicationEventPublisher eventPublisher;
    private AuthenticationManager authenticationManager;
    static /* synthetic */ Class class$net$sf$acegisecurity$ui$x509$X509ProcessingFilter;

    public void setApplicationEventPublisher(ApplicationEventPublisher context) {
        this.eventPublisher = context;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.authenticationManager, (String)"An AuthenticationManager must be set");
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException("Can only process HttpServletRequest");
        }
        if (!(response instanceof HttpServletResponse)) {
            throw new ServletException("Can only process HttpServletResponse");
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Checking secure context token: " + SecurityContextHolder.getContext().getAuthentication()));
        }
        if (SecurityContextHolder.getContext().getAuthentication() == null) {
            Authentication authResult = null;
            X509Certificate clientCertificate = this.extractClientCertificate(httpRequest);
            try {
                X509AuthenticationToken authRequest = new X509AuthenticationToken(clientCertificate);
                authRequest.setDetails(new WebAuthenticationDetails(httpRequest));
                authResult = this.authenticationManager.authenticate(authRequest);
                this.successfulAuthentication(httpRequest, httpResponse, authResult);
            }
            catch (AuthenticationException failed) {
                this.unsuccessfulAuthentication(httpRequest, httpResponse, failed);
            }
        }
        filterChain.doFilter(request, response);
    }

    public void init(FilterConfig ignored) throws ServletException {
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authResult) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Authentication success: " + authResult));
        }
        SecurityContextHolder.getContext().setAuthentication(authResult);
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent((ApplicationEvent)new InteractiveAuthenticationSuccessEvent(authResult, this.getClass()));
        }
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) {
        SecurityContextHolder.getContext().setAuthentication(null);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Updated SecurityContextHolder to contain null Authentication");
        }
        request.getSession().setAttribute("ACEGI_SECURITY_LAST_EXCEPTION", (Object)failed);
    }

    private X509Certificate extractClientCertificate(HttpServletRequest request) {
        X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        if (certs != null && certs.length > 0) {
            return certs[0];
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"No client certificate found in request.");
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

