/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.vote;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.AuthorizationServiceException;
import net.sf.acegisecurity.ConfigAttribute;
import net.sf.acegisecurity.ConfigAttributeDefinition;
import net.sf.acegisecurity.acl.AclEntry;
import net.sf.acegisecurity.acl.AclManager;
import net.sf.acegisecurity.acl.basic.BasicAclEntry;
import net.sf.acegisecurity.vote.AbstractAclVoter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class BasicAclEntryVoter
extends AbstractAclVoter
implements InitializingBean {
    private static final Log logger = LogFactory.getLog((Class)(class$net$sf$acegisecurity$vote$BasicAclEntryVoter == null ? (class$net$sf$acegisecurity$vote$BasicAclEntryVoter = BasicAclEntryVoter.class$("net.sf.acegisecurity.vote.BasicAclEntryVoter")) : class$net$sf$acegisecurity$vote$BasicAclEntryVoter));
    private AclManager aclManager;
    private String internalMethod;
    private String processConfigAttribute;
    private int[] requirePermission;
    static /* synthetic */ Class class$net$sf$acegisecurity$vote$BasicAclEntryVoter;

    public void setAclManager(AclManager aclManager) {
        this.aclManager = aclManager;
    }

    public AclManager getAclManager() {
        return this.aclManager;
    }

    public void setInternalMethod(String internalMethod) {
        this.internalMethod = internalMethod;
    }

    public String getInternalMethod() {
        return this.internalMethod;
    }

    public void setProcessConfigAttribute(String processConfigAttribute) {
        this.processConfigAttribute = processConfigAttribute;
    }

    public String getProcessConfigAttribute() {
        return this.processConfigAttribute;
    }

    public void setRequirePermission(int[] requirePermission) {
        this.requirePermission = requirePermission;
    }

    public int[] getRequirePermission() {
        return this.requirePermission;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.processConfigAttribute, (String)"A processConfigAttribute is mandatory");
        Assert.notNull((Object)this.aclManager, (String)"An aclManager is mandatory");
        if (this.requirePermission == null || this.requirePermission.length == 0) {
            throw new IllegalArgumentException("One or more requirePermission entries is mandatory");
        }
    }

    public boolean supports(ConfigAttribute attribute) {
        return attribute.getAttribute() != null && attribute.getAttribute().startsWith(this.getProcessConfigAttribute());
    }

    public int vote(Authentication authentication, Object object, ConfigAttributeDefinition config) {
        Iterator iter = config.getConfigAttributes();
        while (iter.hasNext()) {
            AclEntry[] acls;
            ConfigAttribute attr = (ConfigAttribute)iter.next();
            if (!this.supports(attr)) continue;
            Object domainObject = this.getDomainObjectInstance(object);
            if (domainObject == null) {
                return 0;
            }
            if (this.internalMethod != null && !"".equals(this.internalMethod)) {
                try {
                    Class<?> clazz = domainObject.getClass();
                    Method method = clazz.getMethod(this.internalMethod, new Class[0]);
                    domainObject = method.invoke(domainObject, new Object[0]);
                }
                catch (NoSuchMethodException nsme) {
                    throw new AuthorizationServiceException("Object of class '" + domainObject.getClass() + "' does not provide the requested internalMethod: " + this.internalMethod);
                }
                catch (IllegalAccessException iae) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"IllegalAccessException", (Throwable)iae);
                        if (iae.getCause() != null) {
                            logger.debug((Object)("Cause: " + iae.getCause().getMessage()), iae.getCause());
                        }
                    }
                    throw new AuthorizationServiceException("Problem invoking internalMethod: " + this.internalMethod + " for object: " + domainObject);
                }
                catch (InvocationTargetException ite) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"InvocationTargetException", (Throwable)ite);
                        if (ite.getCause() != null) {
                            logger.debug((Object)("Cause: " + ite.getCause().getMessage()), ite.getCause());
                        }
                    }
                    throw new AuthorizationServiceException("Problem invoking internalMethod: " + this.internalMethod + " for object: " + domainObject);
                }
            }
            if ((acls = this.aclManager.getAcls(domainObject, authentication)) == null || acls.length == 0) {
                return -1;
            }
            for (int i = 0; i < acls.length; ++i) {
                if (!(acls[i] instanceof BasicAclEntry)) continue;
                BasicAclEntry processableAcl = (BasicAclEntry)acls[i];
                for (int y = 0; y < this.requirePermission.length; ++y) {
                    if (!processableAcl.isPermitted(this.requirePermission[y])) continue;
                    return 1;
                }
            }
            return -1;
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

