/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.jca;

import java.util.Timer;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.WorkManager;
import org.activemq.jca.JCAConnector;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;

public class JCAContainer
implements BootstrapContext,
InitializingBean,
DisposableBean,
BeanFactoryAware {
    private WorkManager workManager;
    private XATerminator xaTerminator;
    private ResourceAdapter resourceAdapter;
    private BeanFactory beanFactory;
    private boolean lazyLoad = false;

    public Timer createTimer() throws UnavailableException {
        return new Timer();
    }

    public JCAConnector addConnector() {
        return new JCAConnector(this, this.resourceAdapter);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.workManager == null) {
            throw new IllegalArgumentException("workManager property must be set");
        }
        if (this.resourceAdapter == null) {
            throw new IllegalArgumentException("bootstrapContext must be set");
        }
        this.resourceAdapter.start((BootstrapContext)this);
        if (this.beanFactory == null) {
            throw new IllegalArgumentException("beanFactory should have been set by Spring");
        }
        if (!this.lazyLoad && this.beanFactory instanceof ListableBeanFactory) {
            ListableBeanFactory listableBeanFactory = (ListableBeanFactory)this.beanFactory;
            String[] names = listableBeanFactory.getBeanDefinitionNames();
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                this.beanFactory.getBean(name);
            }
        }
    }

    public void destroy() throws Exception {
        if (this.resourceAdapter != null) {
            this.resourceAdapter.stop();
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public WorkManager getWorkManager() {
        return this.workManager;
    }

    public XATerminator getXATerminator() {
        return this.xaTerminator;
    }

    public void setXaTerminator(XATerminator xaTerminator) {
        this.xaTerminator = xaTerminator;
    }

    public void setWorkManager(WorkManager workManager) {
        this.workManager = workManager;
    }

    public ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    public void setResourceAdapter(ResourceAdapter resourceAdapter) {
        this.resourceAdapter = resourceAdapter;
    }
}

