/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.jca;

import java.lang.reflect.Method;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.resource.ResourceException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XAEndpoint
implements MessageEndpoint,
MessageListener {
    private static final Log log = LogFactory.getLog((Class)XAEndpoint.class);
    private MessageListener messageListener;
    private XAResource xaResource;
    private TransactionManager transactionManager;
    private Transaction transaction;
    private boolean beforeDeliveryCompleted;
    private boolean messageDelivered;

    public XAEndpoint(MessageListener messageListener, XAResource xaResource, TransactionManager transactionManager) {
        this.messageListener = messageListener;
        this.xaResource = xaResource;
        this.transactionManager = transactionManager;
    }

    public void beforeDelivery(Method method) throws NoSuchMethodException, ResourceException {
        if (this.transaction != null) {
            throw new IllegalStateException("Transaction still in progress");
        }
        this.beforeDeliveryCompleted = false;
        try {
            this.transactionManager.begin();
            this.transaction = this.transactionManager.getTransaction();
            this.transaction.enlistResource(this.xaResource);
            this.beforeDeliveryCompleted = true;
            log.trace((Object)"Transaction started and resource enlisted");
        }
        catch (NotSupportedException e) {
            System.out.println("Caught: " + (Object)((Object)e));
            throw new ResourceException((Throwable)e);
        }
        catch (SystemException e) {
            System.out.println("Caught: " + (Object)((Object)e));
            throw new ResourceException((Throwable)e);
        }
        catch (RollbackException e) {
            System.out.println("Caught: " + (Object)((Object)e));
            throw new ResourceException((Throwable)e);
        }
        catch (Throwable e) {
            System.out.println("Caught: " + e);
            e.printStackTrace();
            throw new ResourceException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterDelivery() throws ResourceException {
        if (this.transaction == null) {
            throw new IllegalStateException("Transaction not in progress");
        }
        if (this.beforeDeliveryCompleted && this.messageDelivered) {
            try {
                this.transaction.delistResource(this.xaResource, 0x2000000);
            }
            catch (SystemException e) {
                throw new ResourceException((Throwable)e);
            }
            try {
                this.transaction.commit();
                log.trace((Object)"Transaction committed");
            }
            catch (RollbackException e) {
                throw new ResourceException((Throwable)e);
            }
            catch (HeuristicMixedException e) {
                this.doRollback((Exception)((Object)e));
            }
            catch (HeuristicRollbackException e) {
                this.doRollback((Exception)((Object)e));
            }
            catch (SystemException e) {
                this.doRollback((Exception)((Object)e));
            }
            finally {
                this.transaction = null;
            }
        }
    }

    public void onMessage(Message message) {
        this.messageDelivered = false;
        this.messageListener.onMessage(message);
        this.messageDelivered = true;
    }

    public void release() {
        if (this.transaction != null) {
            try {
                this.transaction.rollback();
            }
            catch (SystemException e) {
                log.warn((Object)("Failed to rollback transaction: " + (Object)((Object)e)), (Throwable)e);
            }
        }
    }

    protected void doRollback(Exception e) throws ResourceException {
        try {
            this.transaction.rollback();
            log.trace((Object)"Transaction rolled back");
        }
        catch (SystemException e1) {
            log.warn((Object)("Caught exception while rolling back: " + (Object)((Object)e1)), (Throwable)e1);
        }
        this.transaction = null;
        throw new ResourceException((Throwable)e);
    }
}

