/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.gbean;

import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import javax.jms.JMSException;
import org.activemq.ActiveMQConnectionFactory;
import org.activemq.broker.BrokerConnector;
import org.activemq.broker.impl.BrokerConnectorImpl;
import org.activemq.gbean.ActiveMQConnector;
import org.activemq.gbean.ActiveMQContainer;
import org.activemq.gbean.ActiveMQContainerGBean;
import org.activemq.io.WireFormat;
import org.activemq.io.impl.DefaultWireFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.GConstructorInfo;

public class ActiveMQConnectorGBean
implements GBeanLifecycle,
ActiveMQConnector {
    private Log log = LogFactory.getLog((String)this.getClass().getName());
    private BrokerConnector brokerConnector;
    private ActiveMQContainer container;
    private WireFormat wireFormat = new DefaultWireFormat();
    private String protocol;
    private String host;
    private int port;
    private String path;
    private String query;
    private String urlAsStarted;
    public static final GBeanInfo GBEAN_INFO;

    public ActiveMQConnectorGBean(ActiveMQContainer container, String protocol, String host, int port) {
        this.container = container;
        this.protocol = protocol;
        this.host = host;
        this.port = port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getUrl() {
        try {
            return new URI(this.protocol, null, this.host, this.port, this.path, this.query, null).toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Attributes don't form a valid URI: " + this.protocol + "://" + this.host + ":" + this.port + "/" + this.path + "?" + this.query);
        }
    }

    public WireFormat getWireFormat() {
        return this.wireFormat;
    }

    public void setWireFormat(WireFormat wireFormat) {
        this.wireFormat = wireFormat;
    }

    public InetSocketAddress getListenAddress() {
        return this.brokerConnector == null ? null : this.brokerConnector.getServerChannel().getSocketAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doStart() throws Exception {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ActiveMQContainerGBean.class.getClassLoader());
        try {
            if (this.brokerConnector == null) {
                this.urlAsStarted = this.getUrl();
                this.brokerConnector = this.createBrokerConnector(this.urlAsStarted);
                this.brokerConnector.start();
                ActiveMQConnectionFactory.registerBroker((String)this.urlAsStarted, (BrokerConnector)this.brokerConnector);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public synchronized void doStop() throws Exception {
        if (this.brokerConnector != null) {
            ActiveMQConnectionFactory.unregisterBroker((String)this.urlAsStarted);
            BrokerConnector temp = this.brokerConnector;
            this.brokerConnector = null;
            temp.stop();
        }
    }

    public synchronized void doFail() {
        if (this.brokerConnector != null) {
            BrokerConnector temp = this.brokerConnector;
            this.brokerConnector = null;
            try {
                temp.stop();
            }
            catch (JMSException e) {
                this.log.info((Object)("Caught while closing due to failure: " + (Object)((Object)e)), (Throwable)e);
            }
        }
    }

    protected BrokerConnector createBrokerConnector(String url) throws Exception {
        return new BrokerConnectorImpl(this.container.getBrokerContainer(), url, this.wireFormat);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder("ActiveMQ Message Broker Connector", ActiveMQConnectorGBean.class, "JMSConnector");
        infoFactory.addAttribute("url", String.class.getName(), false);
        infoFactory.addAttribute("wireFormat", WireFormat.class.getName(), false);
        infoFactory.addReference("activeMQContainer", ActiveMQContainer.class);
        infoFactory.addInterface(ActiveMQConnector.class, new String[]{"host", "port", "protocol", "path", "query"});
        infoFactory.setConstructor(new GConstructorInfo(new String[]{"activeMQContainer", "protocol", "host", "port"}));
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

