/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.store.cache;

import java.util.Map;
import javax.jms.JMSException;
import org.activemq.store.MessageStore;
import org.activemq.store.PersistenceAdapter;
import org.activemq.store.TopicMessageStore;
import org.activemq.store.TransactionStore;
import org.activemq.store.cache.SimpleCachePersistenceAdapter;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;

public class SimpleCachePersistenceAdapterGBean
implements GBeanLifecycle,
PersistenceAdapter {
    private final PersistenceAdapter longTermPersistence;
    private SimpleCachePersistenceAdapter persistenceAdapter;
    private final int cacheSize;
    public static final GBeanInfo GBEAN_INFO;

    public SimpleCachePersistenceAdapterGBean() {
        this(null, 0);
    }

    public SimpleCachePersistenceAdapterGBean(PersistenceAdapter longTermPersistence, int cacheSize) {
        this.longTermPersistence = longTermPersistence;
        this.cacheSize = cacheSize;
    }

    public void doStart() throws Exception {
        this.persistenceAdapter = new SimpleCachePersistenceAdapter();
        this.persistenceAdapter.setLongTermPersistence(this.longTermPersistence);
        this.persistenceAdapter.setCacheSize(this.cacheSize);
        this.persistenceAdapter.start();
    }

    public void doStop() throws Exception {
        this.persistenceAdapter.stop();
        this.persistenceAdapter = null;
    }

    public void doFail() {
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    public void beginTransaction() throws JMSException {
        this.persistenceAdapter.beginTransaction();
    }

    public void commitTransaction() throws JMSException {
        this.persistenceAdapter.commitTransaction();
    }

    public MessageStore createQueueMessageStore(String destinationName) throws JMSException {
        return this.persistenceAdapter.createQueueMessageStore(destinationName);
    }

    public TopicMessageStore createTopicMessageStore(String destinationName) throws JMSException {
        return this.persistenceAdapter.createTopicMessageStore(destinationName);
    }

    public TransactionStore createTransactionStore() throws JMSException {
        return this.persistenceAdapter.createTransactionStore();
    }

    public Map getInitialDestinations() {
        return this.persistenceAdapter.getInitialDestinations();
    }

    public void rollbackTransaction() {
        this.persistenceAdapter.rollbackTransaction();
    }

    public void start() throws JMSException {
    }

    public void stop() throws JMSException {
    }

    public boolean deadLetterAlreadySent(long seq, boolean useDatabaseLocking) {
        return this.persistenceAdapter.deadLetterAlreadySent(seq, useDatabaseLocking);
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder("ActiveMQ Persistence Cache", SimpleCachePersistenceAdapterGBean.class, "JMSPersistence");
        infoFactory.addReference("longTermPersistence", PersistenceAdapter.class);
        infoFactory.addAttribute("cacheSize", Integer.TYPE, true);
        infoFactory.addInterface(PersistenceAdapter.class);
        infoFactory.setConstructor(new String[]{"longTermPersistence", "cacheSize"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

