/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.itest.ejb;

import java.rmi.RemoteException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMSToolBean
implements SessionBean {
    private static final long serialVersionUID = 3834596495499474741L;
    private static final Log log = LogFactory.getLog((Class)JMSToolBean.class);
    private SessionContext sessionContext;
    private Context envContext;

    public void ejbCreate() {
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void setSessionContext(SessionContext sessionContext) {
        try {
            this.sessionContext = sessionContext;
            this.envContext = (Context)new InitialContext().lookup("java:comp/env");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
    }

    public void sendTextMessage(String dest, String text) throws RemoteException, JMSException, NamingException {
        this.sendTextMessage(this.createDestination(dest), text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendTextMessage(Destination dest, String text) throws RemoteException, JMSException, NamingException {
        log.info((Object)"sendTextMessage start");
        Connection connection = this.createConnection();
        try {
            Session session = connection.createSession(true, 0);
            MessageProducer producer = session.createProducer(dest);
            producer.send((Message)session.createTextMessage(text));
        }
        finally {
            log.info((Object)"sendTextMessage end");
            connection.close();
        }
    }

    public String receiveTextMessage(String dest, long timeout) throws RemoteException, JMSException, NamingException {
        return this.receiveTextMessage(this.createDestination(dest), timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String receiveTextMessage(Destination dest, long timeout) throws RemoteException, JMSException, NamingException {
        log.info((Object)"receiveTextMessage start");
        Connection connection = this.createConnection();
        try {
            connection.start();
            Session session = connection.createSession(true, 0);
            MessageConsumer consumer = session.createConsumer(dest);
            TextMessage message = null;
            message = (TextMessage)consumer.receive(timeout);
            String string = message == null ? null : message.getText();
            return string;
        }
        finally {
            log.info((Object)"receiveTextMessage end");
            connection.close();
        }
    }

    public int drain(String dest) throws RemoteException, JMSException, NamingException {
        return this.drain(this.createDestination(dest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drain(Destination dest) throws RemoteException, JMSException, NamingException {
        log.info((Object)"drain start");
        Connection connection = this.createConnection();
        try {
            connection.start();
            Session session = connection.createSession(true, 0);
            MessageConsumer consumer = session.createConsumer(dest);
            int counter = 0;
            while (consumer.receive(1000L) != null) {
                ++counter;
            }
            int n = counter;
            return n;
        }
        finally {
            log.info((Object)"drain end");
            connection.close();
        }
    }

    private Destination createDestination(String dest) throws NamingException {
        return (Destination)this.envContext.lookup(dest);
    }

    private Connection createConnection() throws NamingException, JMSException {
        ConnectionFactory cf = (ConnectionFactory)this.envContext.lookup("jms/Default");
        Connection con = cf.createConnection();
        return con;
    }
}

