/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.http;

import EDU.oswego.cs.dl.util.concurrent.BoundedLinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.Channel;
import java.io.BufferedReader;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activemq.io.TextWireFormat;
import org.activemq.message.Packet;
import org.activemq.message.WireFormatInfo;
import org.activemq.transport.TransportChannel;
import org.activemq.transport.TransportChannelListener;
import org.activemq.transport.http.HttpServerTransportChannel;
import org.activemq.transport.xstream.XStreamWireFormat;
import org.activemq.util.JMSExceptionHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpTunnelServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog((Class)HttpTunnelServlet.class);
    private TransportChannelListener listener;
    private TextWireFormat wireFormat;
    private Map clients = new HashMap();
    private long requestTimeout = 30000L;

    public void init() throws ServletException {
        super.init();
        this.listener = (TransportChannelListener)this.getServletContext().getAttribute("transportChannelListener");
        if (this.listener == null) {
            throw new ServletException("No such attribute 'transportChannelListener' available in the ServletContext");
        }
        this.wireFormat = (TextWireFormat)this.getServletContext().getAttribute("wireFormat");
        if (this.wireFormat == null) {
            this.wireFormat = this.createWireFormat();
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Packet packet = null;
        try {
            HttpServerTransportChannel transportChannel = this.getTransportChannel(request);
            if (transportChannel == null) {
                return;
            }
            packet = (Packet)transportChannel.getChannel().poll(this.requestTimeout);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (packet == null) {
            response.setStatus(408);
        } else {
            try {
                this.wireFormat.writePacket(packet, (DataOutput)new DataOutputStream((OutputStream)response.getOutputStream()));
            }
            catch (JMSException e) {
                throw JMSExceptionHelper.newIOException((JMSException)e);
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            Packet packet = this.wireFormat.fromString(this.readRequestBody(request));
            if (packet.getPacketType() == 29) {
                WireFormatInfo info = (WireFormatInfo)packet;
                if (!this.canProcessWireFormatVersion(info.getVersion())) {
                    response.sendError(404, "Cannot process wire format of version: " + info.getVersion());
                }
            } else {
                HttpServerTransportChannel transportChannel = this.getTransportChannel(request);
                if (transportChannel == null) {
                    response.setStatus(404);
                }
                transportChannel.getPacketListener().consume(packet);
            }
        }
        catch (IOException e) {
            log.error((Object)("Caught: " + e), (Throwable)e);
        }
        catch (JMSException e) {
            throw JMSExceptionHelper.newIOException((JMSException)e);
        }
    }

    private boolean canProcessWireFormatVersion(int version) {
        return true;
    }

    protected String readRequestBody(HttpServletRequest request) throws IOException {
        String line;
        StringBuffer buffer = new StringBuffer();
        BufferedReader reader = request.getReader();
        while ((line = reader.readLine()) != null) {
            buffer.append(line);
            buffer.append("\n");
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpServerTransportChannel getTransportChannel(HttpServletRequest request) {
        String clientID = request.getHeader("clientID");
        if (clientID == null) {
            clientID = request.getParameter("clientID");
        }
        if (clientID == null) {
            log.warn((Object)"No clientID header so ignoring request");
            return null;
        }
        HttpTunnelServlet httpTunnelServlet = this;
        synchronized (httpTunnelServlet) {
            HttpServerTransportChannel answer = (HttpServerTransportChannel)((Object)this.clients.get(clientID));
            if (answer == null) {
                answer = this.createTransportChannel();
                this.clients.put(clientID, answer);
                this.listener.addClient((TransportChannel)answer);
            } else {
                this.keepAlivePing(answer);
            }
            return answer;
        }
    }

    protected void keepAlivePing(HttpServerTransportChannel channel) {
    }

    protected HttpServerTransportChannel createTransportChannel() {
        return new HttpServerTransportChannel((Channel)new BoundedLinkedQueue(10));
    }

    protected TextWireFormat createWireFormat() {
        return new XStreamWireFormat();
    }
}

