/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.benchmark;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.activemq.ActiveMQConnectionFactory;
import org.activemq.util.IdGenerator;

public class BenchmarkSupport {
    protected int connectionCount = 1;
    protected int batch = 1000;
    protected Destination destination;
    protected boolean embeddedBroker = false;
    private boolean topic = true;
    private boolean durable = false;
    private ActiveMQConnectionFactory factory;
    private String url;
    protected String[] subjects;
    private long time = System.currentTimeMillis();
    private int counter;
    private List resources = new ArrayList();
    private NumberFormat formatter = NumberFormat.getInstance();
    private SynchronizedInt connectionCounter = new SynchronizedInt(0);
    private IdGenerator idGenerator = new IdGenerator();

    public void start() {
        System.out.println("Using: " + this.connectionCount + " connection(s)");
        this.subjects = new String[this.connectionCount];
        for (int i = 0; i < this.connectionCount; ++i) {
            this.subjects[i] = "BENCHMARK.FEED" + i;
        }
        if (this.useTimerLoop()) {
            Thread timer = new Thread(){

                public void run() {
                    BenchmarkSupport.this.timerLoop();
                }
            };
            timer.start();
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isTopic() {
        return this.topic;
    }

    public void setTopic(boolean topic) {
        this.topic = topic;
    }

    public ActiveMQConnectionFactory getFactory() {
        return this.factory;
    }

    public void setFactory(ActiveMQConnectionFactory factory) {
        this.factory = factory;
    }

    public void setSubject(String subject) {
        this.connectionCount = 1;
        this.subjects = new String[]{subject};
    }

    public boolean isDurable() {
        return this.durable;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public boolean isEmbeddedBroker() {
        return this.embeddedBroker;
    }

    public void setEmbeddedBroker(boolean embeddedBroker) {
        this.embeddedBroker = embeddedBroker;
    }

    public int getConnectionCount() {
        return this.connectionCount;
    }

    public void setConnectionCount(int connectionCount) {
        this.connectionCount = connectionCount;
    }

    protected Session createSession() throws JMSException {
        if (this.factory == null) {
            this.factory = this.createFactory();
        }
        Connection connection = this.factory.createConnection();
        int value = this.connectionCounter.increment();
        System.out.println("Created connection: " + value + " = " + connection);
        if (this.durable) {
            connection.setClientID(this.idGenerator.generateId());
        }
        this.addResource(connection);
        connection.start();
        Session session = connection.createSession(false, 1);
        this.addResource(session);
        return session;
    }

    protected ActiveMQConnectionFactory createFactory() {
        ActiveMQConnectionFactory answer = new ActiveMQConnectionFactory(this.getUrl());
        if (this.embeddedBroker) {
            answer.setUseEmbeddedBroker(true);
        }
        return answer;
    }

    protected synchronized void count(int count) {
        this.counter += count;
    }

    protected synchronized int resetCount() {
        int answer = this.counter;
        this.counter = 0;
        return answer;
    }

    protected void timerLoop() {
        int times = 0;
        int total = 0;
        int dumpVmStatsFrequency = 10;
        Runtime runtime = Runtime.getRuntime();
        while (true) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            int processed = this.resetCount();
            double average = 0.0;
            if (processed > 0) {
                total += processed;
                ++times;
            }
            if (times > 0) {
                average = total / times;
            }
            long oldtime = this.time;
            this.time = System.currentTimeMillis();
            double diff = this.time - oldtime;
            System.out.println(this.getClass().getName() + " Processed: " + processed + " messages this second. Average: " + average);
            if (times % dumpVmStatsFrequency != 0 || times == 0) continue;
            System.out.println("Used memory: " + this.asMemoryString(runtime.totalMemory() - runtime.freeMemory()) + " Free memory: " + this.asMemoryString(runtime.freeMemory()) + " Total memory: " + this.asMemoryString(runtime.totalMemory()) + " Max memory: " + this.asMemoryString(runtime.maxMemory()));
        }
    }

    protected String asMemoryString(long value) {
        return this.formatter.format(value / 1024L) + " K";
    }

    protected boolean useTimerLoop() {
        return true;
    }

    protected Destination createDestination(Session session, String subject) throws JMSException {
        if (this.topic) {
            return session.createTopic(subject);
        }
        return session.createQueue(subject);
    }

    protected void addResource(Object resource) {
        this.resources.add(resource);
    }

    protected static boolean parseBoolean(String text) {
        return text.equalsIgnoreCase("true");
    }
}

