/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.zeroconf;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.jms.JMSException;
import org.activemq.ConfigurationException;
import org.activemq.NotStartedException;
import org.activemq.transport.DiscoveryAgent;
import org.activemq.transport.DiscoveryAgentSupport;
import org.activemq.transport.DiscoveryEvent;
import org.activemq.util.JMSExceptionHelper;
import org.activemq.util.MapHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ZeroconfDiscoveryAgent
extends DiscoveryAgentSupport
implements ServiceListener {
    private static final Log log = LogFactory.getLog((Class)ZeroconfDiscoveryAgent.class);
    private JmDNS jmdns;
    private InetAddress localAddress;
    private String localhost;
    private String type;
    private int weight = 0;
    private int priority = 0;

    public void start() throws JMSException {
        if (this.type == null) {
            throw new ConfigurationException("You must specify a type of service to discover");
        }
        if (!this.type.endsWith(".")) {
            log.warn((Object)("The type '" + this.type + "' should end with '.' to be a valid Zeroconf type"));
            this.type = this.type + ".";
        }
        try {
            if (this.jmdns == null) {
                this.jmdns = this.createJmDNS();
            }
            if (!this.listeners.isEmpty()) {
                log.info((Object)("Discovering service of type: " + this.type));
                this.jmdns.addServiceListener(this.type, (ServiceListener)this);
            }
        }
        catch (IOException e) {
            JMSExceptionHelper.newJMSException((String)("Failed to start JmDNS service: " + e), (Exception)e);
        }
    }

    public void stop() throws JMSException {
        this.jmdns.unregisterAllServices();
        this.jmdns.close();
    }

    public void registerService(String name, Map details) throws JMSException {
        if (this.jmdns == null) {
            throw new NotStartedException();
        }
        try {
            this.jmdns.registerService(this.createServiceInfo(name, details));
        }
        catch (IOException e) {
            JMSExceptionHelper.newJMSException((String)("Could not register service: " + name + ". Reason: " + e), (Exception)e);
        }
    }

    public void addService(JmDNS jmDNS, String type, String name) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("addService with type: " + type + " name: " + name));
        }
        jmDNS.requestServiceInfo(type, name);
    }

    public void removeService(JmDNS jmDNS, String type, String name) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeService with type: " + type + " name: " + name));
        }
        DiscoveryEvent event = new DiscoveryEvent((DiscoveryAgent)this, name);
        this.fireRemoveService(event);
    }

    public void resolveService(JmDNS jmDNS, String type, String name, ServiceInfo serviceInfo) {
        String urlStr;
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeService with type: " + type + " name: " + name + " info: " + serviceInfo));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (serviceInfo != null) {
            Enumeration iter = serviceInfo.getPropertyNames();
            while (iter.hasMoreElements()) {
                String key = (String)iter.nextElement();
                String value = serviceInfo.getPropertyString(key);
                map.put(key, value);
            }
        }
        if ((urlStr = (String)map.get("connectURL")) != null) {
            try {
                boolean reliable = false;
                if (urlStr.startsWith("reliable:")) {
                    reliable = true;
                    urlStr = urlStr.substring("reliable:".length());
                }
                URI temp = new URI(urlStr);
                temp = new URI(temp.getScheme(), temp.getUserInfo(), serviceInfo.getAddress(), temp.getPort(), temp.getPath(), temp.getQuery(), temp.getFragment());
                String newUrl = temp.toString();
                if (reliable) {
                    newUrl = "reliable:" + newUrl;
                }
                map.put("connectURL", newUrl);
            }
            catch (Exception e) {
                log.error((Object)("Failed to resolve URL " + urlStr + " to an IP address: "), (Throwable)e);
            }
        }
        DiscoveryEvent event = new DiscoveryEvent((DiscoveryAgent)this, name, map);
        this.fireAddService(event);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public JmDNS getJmdns() {
        return this.jmdns;
    }

    public void setJmdns(JmDNS jmdns) {
        this.jmdns = jmdns;
    }

    public InetAddress getLocalAddress() throws UnknownHostException {
        if (this.localAddress == null) {
            this.localAddress = this.createLocalAddress();
        }
        return this.localAddress;
    }

    public void setLocalAddress(InetAddress localAddress) {
        this.localAddress = localAddress;
    }

    public String getLocalhost() {
        return this.localhost;
    }

    public void setLocalhost(String localhost) {
        this.localhost = localhost;
    }

    protected ServiceInfo createServiceInfo(String name, Map map) {
        name = name + "." + this.type;
        int port = MapHelper.getInt((Map)map, (String)"port", (int)0);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registering service type: " + this.type + " name: " + name + " details: " + map));
        }
        return new ServiceInfo(this.type, name, port, this.weight, this.priority, new Hashtable(map));
    }

    protected JmDNS createJmDNS() throws IOException {
        return new JmDNS(this.getLocalAddress());
    }

    protected InetAddress createLocalAddress() throws UnknownHostException {
        if (this.localhost != null) {
            return InetAddress.getByName(this.localhost);
        }
        return InetAddress.getLocalHost();
    }
}

