/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.ra;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ResourceAdapter;
import org.codehaus.activemq.ra.ActiveMQResourceAdapter;

public class ActiveMQActivationSpec
implements ActivationSpec {
    public static final String AUTO_ACKNOWLEDGE_MODE = "Auto-acknowledge";
    public static final String AUTO_ACKNOWLEDGE_MODE_JBOSS = "AUTO_ACKNOWELDGE";
    public static final String DUPS_OK_ACKNOWLEDGE_MODE = "Dups-ok-acknowledge";
    public static final String DURABLE_SUBSCRIPTION = "Durable";
    public static final String NON_DURABLE_SUBSCRIPTION = "NonDurable";
    private ActiveMQResourceAdapter resourceAdapter;
    private String destinationType;
    private String messageSelector;
    boolean noLocal = false;
    private String destination;
    private String acknowledgeMode = "Auto-acknowledge";
    private String userName;
    private String password;
    private String clientId;
    private String subscriptionName;
    private String subscriptionDurability = "NonDurable";
    public static final int INVALID_ACKNOWLEDGE_MODE = -1;

    public void validate() throws InvalidPropertyException {
        ArrayList<PropertyDescriptor> propsNotSet = new ArrayList<PropertyDescriptor>();
        try {
            if (this.destination == null || this.destination.equals("")) {
                propsNotSet.add(new PropertyDescriptor("destination", ActiveMQActivationSpec.class));
            }
            if (!this.isValidDestinationType()) {
                propsNotSet.add(new PropertyDescriptor("destinationType", ActiveMQActivationSpec.class));
            }
            if (!this.isValidAcknowledgeMode()) {
                propsNotSet.add(new PropertyDescriptor("acknowledgeMode", ActiveMQActivationSpec.class));
            }
            if (!this.isValidSubscriptionDurability()) {
                propsNotSet.add(new PropertyDescriptor("subscriptionDurability", ActiveMQActivationSpec.class));
            }
            if (!this.isValidClientId()) {
                propsNotSet.add(new PropertyDescriptor("clientId", ActiveMQActivationSpec.class));
            }
            if (!this.isValidSubscriptionName()) {
                propsNotSet.add(new PropertyDescriptor("subscriptionName", ActiveMQActivationSpec.class));
            }
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        if (propsNotSet.size() > 0) {
            InvalidPropertyException e = new InvalidPropertyException("Invalid settings.");
            PropertyDescriptor[] descriptors = propsNotSet.toArray(new PropertyDescriptor[propsNotSet.size()]);
            e.setInvalidPropertyDescriptors(descriptors);
            throw e;
        }
    }

    public ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    public void setResourceAdapter(ResourceAdapter resourceAdapter) throws ResourceException {
        if (this.resourceAdapter != null) {
            throw new ResourceException("ResourceAdapter already set");
        }
        if (!(resourceAdapter instanceof ActiveMQResourceAdapter)) {
            throw new ResourceException("ResourceAdapter is not of type: " + ActiveMQResourceAdapter.class.getName());
        }
        this.resourceAdapter = (ActiveMQResourceAdapter)resourceAdapter;
    }

    public String getDestinationType() {
        return this.destinationType;
    }

    public void setDestinationType(String destinationType) {
        this.destinationType = destinationType;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    public boolean getNoLocal() {
        return this.noLocal;
    }

    public void setNoLocal(boolean noLocal) {
        this.noLocal = noLocal;
    }

    public String getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public void setAcknowledgeMode(String acknowledgeMode) {
        this.acknowledgeMode = acknowledgeMode;
        if (AUTO_ACKNOWLEDGE_MODE_JBOSS.equals(acknowledgeMode)) {
            this.acknowledgeMode = AUTO_ACKNOWLEDGE_MODE;
        }
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        if (!this.isEmpty(clientId)) {
            this.clientId = clientId;
        }
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getSubscriptionDurability() {
        return this.subscriptionDurability;
    }

    public void setSubscriptionDurability(String subscriptionDurability) {
        this.subscriptionDurability = subscriptionDurability;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public void setSubscriptionName(String subscriptionName) {
        if (!this.isEmpty(subscriptionName)) {
            this.subscriptionName = subscriptionName;
        }
    }

    private boolean isValidSubscriptionName() {
        return !this.isDurableSubscription() ? true : this.subscriptionName != null && this.subscriptionName.trim().length() > 0;
    }

    private boolean isValidClientId() {
        return !this.isDurableSubscription() ? true : this.clientId != null && this.clientId.trim().length() > 0;
    }

    public boolean isDurableSubscription() {
        return DURABLE_SUBSCRIPTION.equals(this.subscriptionDurability);
    }

    private boolean isValidSubscriptionDurability() {
        return NON_DURABLE_SUBSCRIPTION.equals(this.subscriptionDurability) || DURABLE_SUBSCRIPTION.equals(this.subscriptionDurability);
    }

    private boolean isValidAcknowledgeMode() {
        return AUTO_ACKNOWLEDGE_MODE.equals(this.acknowledgeMode) || DUPS_OK_ACKNOWLEDGE_MODE.equals(this.acknowledgeMode);
    }

    private boolean isValidDestinationType() {
        return Queue.class.getName().equals(this.destinationType) || Topic.class.getName().equals(this.destinationType);
    }

    private boolean isEmpty(String value) {
        return value == null || "".equals(value.trim());
    }

    public String toString() {
        return "ActiveMQActivationSpec{acknowledgeMode='" + this.acknowledgeMode + "'" + ", destinationType='" + this.destinationType + "'" + ", messageSelector='" + this.messageSelector + "'" + ", destination='" + this.destination + "'" + ", clientId='" + this.clientId + "'" + ", subscriptionName='" + this.subscriptionName + "'" + ", subscriptionDurability='" + this.subscriptionDurability + "'" + "}";
    }

    public String getSubscriptionId() {
        String subscriptionId = null;
        if (!this.isEmpty(this.subscriptionName) && !this.isEmpty(this.clientId)) {
            subscriptionId = this.clientId + "-" + this.subscriptionName;
        }
        return subscriptionId;
    }

    public int getAcknowledgeModeForSession() {
        int retVal = -1;
        if (this.isValidAcknowledgeMode()) {
            retVal = AUTO_ACKNOWLEDGE_MODE.equals(this.acknowledgeMode) ? 1 : 3;
        }
        return retVal;
    }
}

