/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.ra;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.XASession;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.ActiveMQSession;
import org.codehaus.activemq.LocalTransactionEventListener;
import org.codehaus.activemq.ra.ActiveMQConnectionRequestInfo;
import org.codehaus.activemq.ra.ActiveMQResourceAdapter;
import org.codehaus.activemq.ra.JMSConnectionProxy;
import org.codehaus.activemq.ra.TxResourceProxy;

public class ActiveMQManagedConnection
implements ManagedConnection {
    private static final Log log = LogFactory.getLog((Class)ActiveMQManagedConnection.class);
    private PrintWriter logWriter;
    private Subject subject;
    private ActiveMQConnectionRequestInfo info;
    private ArrayList listeners = new ArrayList();
    private Connection physicalConnection;
    Session physicalSession;
    private ArrayList proxyConnections = new ArrayList();
    XAResource xaresource = null;

    public Connection getPhysicalConnection() {
        return this.physicalConnection;
    }

    public Session getPhysicalSession() {
        return this.physicalSession;
    }

    public ActiveMQManagedConnection(Subject subject, ActiveMQResourceAdapter adapter, ActiveMQConnectionRequestInfo info) throws ResourceException {
        this.subject = subject;
        this.info = info;
        try {
            this.physicalConnection = adapter.makeConnection();
        }
        catch (JMSException e) {
            throw new ResourceException("Could not create a new connection: " + e.getMessage(), (Throwable)e);
        }
        this.createSession();
    }

    private void createSession() throws ResourceException {
        try {
            this.physicalSession = this.physicalConnection.createSession(true, 0);
            if (this.physicalSession instanceof ActiveMQSession) {
                ActiveMQSession session = (ActiveMQSession)this.physicalSession;
                LocalTransactionEventListener l = this.createLocalTransactionEventListener();
                session.setLocalTransactionEventListener(l);
            } else {
                log.trace((Object)"Cannot register LocalTransactionEventLister on non-ActiveMQ session");
            }
            this.xaresource = this.physicalSession instanceof XASession ? ((XASession)this.physicalSession).getXAResource() : null;
        }
        catch (JMSException e) {
            throw new ResourceException("Could not create a new session: " + e.getMessage(), (Throwable)e);
        }
    }

    private LocalTransactionEventListener createLocalTransactionEventListener() {
        return new LocalTransactionEventListener(){

            public void beginEvent() {
                ConnectionEvent event = new ConnectionEvent((ManagedConnection)ActiveMQManagedConnection.this, 2);
                Iterator iterator = ActiveMQManagedConnection.this.listeners.iterator();
                while (iterator.hasNext()) {
                    ConnectionEventListener l = (ConnectionEventListener)iterator.next();
                    l.localTransactionStarted(event);
                }
            }

            public void commitEvent() {
                ConnectionEvent event = new ConnectionEvent((ManagedConnection)ActiveMQManagedConnection.this, 3);
                Iterator iterator = ActiveMQManagedConnection.this.listeners.iterator();
                while (iterator.hasNext()) {
                    ConnectionEventListener l = (ConnectionEventListener)iterator.next();
                    l.localTransactionCommitted(event);
                }
            }

            public void rollbackEvent() {
                ConnectionEvent event = new ConnectionEvent((ManagedConnection)ActiveMQManagedConnection.this, 4);
                Iterator iterator = ActiveMQManagedConnection.this.listeners.iterator();
                while (iterator.hasNext()) {
                    ConnectionEventListener l = (ConnectionEventListener)iterator.next();
                    l.localTransactionRolledback(event);
                }
            }
        };
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        JMSConnectionProxy proxy = new JMSConnectionProxy(this);
        this.proxyConnections.add(proxy);
        return proxy;
    }

    private boolean isDestroyed() {
        return this.physicalConnection == null;
    }

    public void destroy() throws ResourceException {
        if (this.isDestroyed()) {
            return;
        }
        this.cleanup();
        try {
            this.physicalSession.close();
        }
        catch (JMSException e) {
            log.info((Object)"Error occured during close of a JMS connection.", (Throwable)e);
        }
        try {
            this.physicalConnection.close();
            this.physicalConnection = null;
        }
        catch (JMSException e) {
            log.info((Object)"Error occured during close of a JMS connection.", (Throwable)e);
        }
    }

    public void cleanup() throws ResourceException {
        if (this.isDestroyed()) {
            return;
        }
        Iterator iterator = this.proxyConnections.iterator();
        while (iterator.hasNext()) {
            JMSConnectionProxy proxy = (JMSConnectionProxy)iterator.next();
            proxy.cleanup();
            iterator.remove();
        }
        try {
            this.physicalSession.close();
            this.physicalSession = null;
        }
        catch (JMSException e) {
            throw new ResourceException("Could close the JMS session.", (Throwable)e);
        }
        try {
            this.physicalConnection.stop();
        }
        catch (JMSException e) {
            throw new ResourceException("Could stop the JMS connection.", (Throwable)e);
        }
        this.createSession();
    }

    public void associateConnection(Object connection) throws ResourceException {
        throw new ResourceException("Not supported.");
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.remove(listener);
    }

    public XAResource getXAResource() throws ResourceException {
        if (this.xaresource == null) {
            throw new ResourceException("This is not an XA connection.");
        }
        return new TxResourceProxy(){

            Session getSession() {
                return ActiveMQManagedConnection.this.physicalSession;
            }

            XAResource getXAResource() {
                return ActiveMQManagedConnection.this.xaresource;
            }
        };
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        return new TxResourceProxy(){

            Session getSession() {
                return ActiveMQManagedConnection.this.physicalSession;
            }

            XAResource getXAResource() {
                return ActiveMQManagedConnection.this.xaresource;
            }
        };
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return new ManagedConnectionMetaData(){

            public String getEISProductName() throws ResourceException {
                if (ActiveMQManagedConnection.this.physicalConnection == null) {
                    throw new ResourceException("Not connected.");
                }
                try {
                    return ActiveMQManagedConnection.this.physicalConnection.getMetaData().getJMSProviderName();
                }
                catch (JMSException e) {
                    throw new ResourceException("Error accessing provider.", (Throwable)e);
                }
            }

            public String getEISProductVersion() throws ResourceException {
                if (ActiveMQManagedConnection.this.physicalConnection == null) {
                    throw new ResourceException("Not connected.");
                }
                try {
                    return ActiveMQManagedConnection.this.physicalConnection.getMetaData().getProviderVersion();
                }
                catch (JMSException e) {
                    throw new ResourceException("Error accessing provider.", (Throwable)e);
                }
            }

            public int getMaxConnections() throws ResourceException {
                if (ActiveMQManagedConnection.this.physicalConnection == null) {
                    throw new ResourceException("Not connected.");
                }
                return Integer.MAX_VALUE;
            }

            public String getUserName() throws ResourceException {
                if (ActiveMQManagedConnection.this.physicalConnection == null) {
                    throw new ResourceException("Not connected.");
                }
                try {
                    return ActiveMQManagedConnection.this.physicalConnection.getClientID();
                }
                catch (JMSException e) {
                    throw new ResourceException("Error accessing provider.", (Throwable)e);
                }
            }
        };
    }

    public void setLogWriter(PrintWriter logWriter) throws ResourceException {
        this.logWriter = logWriter;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    public boolean matches(Subject subject, ConnectionRequestInfo info) {
        if (info == null) {
            return false;
        }
        if (info.getClass() != ActiveMQConnectionRequestInfo.class) {
            return false;
        }
        if (subject == null ^ this.subject == null) {
            return false;
        }
        if (subject != null && !subject.equals(this.subject)) {
            return false;
        }
        return info.equals(this.info);
    }

    public void proxyClosedEvent(JMSConnectionProxy proxy) {
        this.proxyConnections.remove(proxy);
        proxy.cleanup();
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 1);
        event.setConnectionHandle((Object)proxy);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ConnectionEventListener l = (ConnectionEventListener)iterator.next();
            l.connectionClosed(event);
        }
    }
}

