/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.ra;

import java.util.HashMap;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XASession;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.ra.ActiveMQActivationSpec;
import org.codehaus.activemq.ra.ActiveMQAsfEndpointWorker;
import org.codehaus.activemq.ra.ActiveMQBaseEndpointWorker;
import org.codehaus.activemq.ra.ActiveMQConnectionRequestInfo;
import org.codehaus.activemq.ra.ActiveMQEndpointActivationKey;
import org.codehaus.activemq.ra.ActiveMQPollingEndpointWorker;
import org.codehaus.activemq.ra.ActiveMQRAConnectionFactory;

public class ActiveMQResourceAdapter
implements ResourceAdapter {
    private static final Log log = LogFactory.getLog((Class)ActiveMQResourceAdapter.class);
    private static final String ASF_ENDPOINT_WORKER_TYPE = "asf";
    private static final String POLLING_ENDPOINT_WORKER_TYPE = "polling";
    private BootstrapContext bootstrapContext;
    private HashMap endpointWorkers = new HashMap();
    private final ActiveMQConnectionRequestInfo info = new ActiveMQConnectionRequestInfo();
    private String endpointWorkerType = "asf";
    private ConnectionFactory connectionFactory;

    public ActiveMQResourceAdapter() {
        this(null);
    }

    public ActiveMQResourceAdapter(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void start(BootstrapContext bootstrapContext) throws ResourceAdapterInternalException {
        this.bootstrapContext = bootstrapContext;
    }

    public Connection makeConnection() throws JMSException {
        ConnectionFactory connectionFactory = this.getConnectionFactory();
        String userName = this.emptyToNull(this.info.getUserName());
        String password = this.emptyToNull(this.info.getPassword());
        Connection physicalConnection = connectionFactory.createConnection(userName, password);
        String clientId = this.emptyToNull(this.info.getClientid());
        if (clientId != null) {
            physicalConnection.setClientID(clientId);
        }
        return physicalConnection;
    }

    public Connection makeConnection(ActiveMQActivationSpec activationSpec) throws JMSException {
        ConnectionFactory connectionFactory = this.getConnectionFactory();
        String userName = this.defaultValue(this.emptyToNull(activationSpec.getUserName()), this.emptyToNull(this.info.getUserName()));
        String password = this.defaultValue(this.emptyToNull(activationSpec.getPassword()), this.emptyToNull(this.info.getPassword()));
        Connection physicalConnection = connectionFactory.createConnection(userName, password);
        String clientId = this.defaultValue(this.emptyToNull(activationSpec.getClientId()), this.emptyToNull(this.info.getClientid()));
        if (clientId != null) {
            physicalConnection.setClientID(clientId);
        }
        return physicalConnection;
    }

    private ConnectionFactory getConnectionFactory() {
        if (this.connectionFactory == null) {
            this.connectionFactory = new ActiveMQRAConnectionFactory(this.info.getServerUrl());
        }
        return this.connectionFactory;
    }

    private String defaultValue(String value, String defaultValue) {
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public void stop() {
        this.bootstrapContext = null;
    }

    public BootstrapContext getBootstrapContext() {
        return this.bootstrapContext;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void endpointActivation(MessageEndpointFactory endpointFactory, ActivationSpec activationSpec) throws ResourceException {
        void var4_6;
        if (activationSpec.getResourceAdapter() != this) {
            throw new ResourceException("Activation spec not initialized with this ResourceAdapter instance");
        }
        if (!activationSpec.getClass().equals(ActiveMQActivationSpec.class)) throw new NotSupportedException("That type of ActicationSpec not supported: " + activationSpec.getClass());
        ActiveMQEndpointActivationKey key = new ActiveMQEndpointActivationKey(endpointFactory, (ActiveMQActivationSpec)activationSpec);
        if (this.endpointWorkers.containsKey(key)) {
            throw new IllegalStateException("Endpoint previously activated");
        }
        if (POLLING_ENDPOINT_WORKER_TYPE.equals(this.getEndpointWorkerType())) {
            ActiveMQPollingEndpointWorker activeMQPollingEndpointWorker = new ActiveMQPollingEndpointWorker(this, key);
        } else {
            if (!ASF_ENDPOINT_WORKER_TYPE.equals(this.getEndpointWorkerType())) throw new NotSupportedException("That type of EndpointWorkerType is not supported: " + this.getEndpointWorkerType());
            ActiveMQAsfEndpointWorker activeMQAsfEndpointWorker = new ActiveMQAsfEndpointWorker(this, key);
        }
        this.endpointWorkers.put(key, var4_6);
        var4_6.start();
    }

    public void endpointDeactivation(MessageEndpointFactory endpointFactory, ActivationSpec activationSpec) {
        if (activationSpec.getClass().equals(ActiveMQActivationSpec.class)) {
            ActiveMQEndpointActivationKey key = new ActiveMQEndpointActivationKey(endpointFactory, (ActiveMQActivationSpec)activationSpec);
            ActiveMQBaseEndpointWorker worker = (ActiveMQBaseEndpointWorker)this.endpointWorkers.get(key);
            if (worker == null) {
                return;
            }
            try {
                worker.stop();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public XAResource[] getXAResources(ActivationSpec[] activationSpecs) throws ResourceException {
        XAResource[] session2;
        Connection connection = null;
        try {
            connection = this.makeConnection();
            if (connection instanceof XAConnection) {
                XASession session2 = ((XAConnection)connection).createXASession();
                XAResource xaResource = session2.getXAResource();
                XAResource[] xAResourceArray = new XAResource[]{xaResource};
                return xAResourceArray;
            }
            session2 = new XAResource[]{};
        }
        catch (JMSException e) {
            throw new ResourceException((Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (Throwable ignore) {}
        }
        return session2;
    }

    public String getClientid() {
        return this.info.getClientid();
    }

    public String getPassword() {
        return this.info.getPassword();
    }

    public String getServerUrl() {
        return this.info.getServerUrl();
    }

    public String getUserName() {
        return this.info.getUserName();
    }

    public void setClientid(String clientid) {
        this.info.setClientid(clientid);
    }

    public void setPassword(String password) {
        this.info.setPassword(password);
    }

    public void setServerUrl(String url) {
        this.info.setServerUrl(url);
    }

    public void setUserName(String userid) {
        this.info.setUserName(userid);
    }

    public String getEndpointWorkerType() {
        return this.endpointWorkerType;
    }

    public void setEndpointWorkerType(String endpointWorkerType) {
        this.endpointWorkerType = endpointWorkerType.toLowerCase();
    }

    public ActiveMQConnectionRequestInfo getInfo() {
        return this.info;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActiveMQResourceAdapter)) {
            return false;
        }
        ActiveMQResourceAdapter activeMQResourceAdapter = (ActiveMQResourceAdapter)o;
        if (!this.endpointWorkerType.equals(activeMQResourceAdapter.endpointWorkerType)) {
            return false;
        }
        return this.info.equals(activeMQResourceAdapter.info);
    }

    public int hashCode() {
        int result = this.info.hashCode();
        result = 29 * result + this.endpointWorkerType.hashCode();
        return result;
    }

    private String emptyToNull(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        return value;
    }
}

