/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.ra;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.Closeable;
import org.codehaus.activemq.ra.ActiveMQManagedConnection;

public class JMSSessionProxy
implements Session,
QueueSession,
TopicSession {
    private static final Log log = LogFactory.getLog((Class)JMSSessionProxy.class);
    private final ActiveMQManagedConnection managedConnection;
    boolean closed = false;
    private ArrayList closeables = new ArrayList();

    public JMSSessionProxy(ActiveMQManagedConnection managedConnection) {
        this.managedConnection = managedConnection;
    }

    public void close() throws JMSException {
        this.cleanup();
    }

    public void cleanup() {
        Iterator iter = this.closeables.iterator();
        while (iter.hasNext()) {
            Closeable c = (Closeable)iter.next();
            try {
                c.close();
            }
            catch (JMSException e) {
                log.debug((Object)("Error in occured closing a JMS object: " + (Object)((Object)e)), (Throwable)e);
            }
        }
        this.closed = true;
    }

    private Session getSession() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The Session is closed");
        }
        return this.managedConnection.getPhysicalSession();
    }

    public void commit() throws JMSException {
        this.getSession().commit();
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        QueueBrowser browser = this.getSession().createBrowser(queue);
        this.closeables.add(browser);
        return browser;
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        QueueBrowser browser = this.getSession().createBrowser(queue, messageSelector);
        this.closeables.add(browser);
        return browser;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return this.getSession().createBytesMessage();
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        MessageConsumer consumer = this.getSession().createConsumer(destination);
        this.closeables.add(consumer);
        return consumer;
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        MessageConsumer consumer = this.getSession().createConsumer(destination, messageSelector);
        this.closeables.add(consumer);
        return consumer;
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean NoLocal) throws JMSException {
        MessageConsumer consumer = this.getSession().createConsumer(destination, messageSelector, NoLocal);
        this.closeables.add(consumer);
        return consumer;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        TopicSubscriber consumer = this.getSession().createDurableSubscriber(topic, name);
        this.closeables.add(consumer);
        return consumer;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        TopicSubscriber consumer = this.getSession().createDurableSubscriber(topic, name, messageSelector, noLocal);
        this.closeables.add(consumer);
        return consumer;
    }

    public MapMessage createMapMessage() throws JMSException {
        return this.getSession().createMapMessage();
    }

    public Message createMessage() throws JMSException {
        return this.getSession().createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return this.getSession().createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        return this.getSession().createObjectMessage(object);
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        MessageProducer producer = this.getSession().createProducer(destination);
        this.closeables.add(producer);
        return producer;
    }

    public Queue createQueue(String queueName) throws JMSException {
        return this.getSession().createQueue(queueName);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        return this.getSession().createStreamMessage();
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        return this.getSession().createTemporaryQueue();
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        return this.getSession().createTemporaryTopic();
    }

    public TextMessage createTextMessage() throws JMSException {
        return this.getSession().createTextMessage();
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        return this.getSession().createTextMessage(text);
    }

    public Topic createTopic(String topicName) throws JMSException {
        return this.getSession().createTopic(topicName);
    }

    public int getAcknowledgeMode() throws JMSException {
        return this.getSession().getAcknowledgeMode();
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.getSession().getMessageListener();
    }

    public boolean getTransacted() throws JMSException {
        return this.getSession().getTransacted();
    }

    public void recover() throws JMSException {
        this.getSession().recover();
    }

    public void rollback() throws JMSException {
        this.getSession().rollback();
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.getSession();
    }

    public void unsubscribe(String name) throws JMSException {
        this.getSession().unsubscribe(name);
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        QueueReceiver consumer = ((QueueSession)this.getSession()).createReceiver(queue);
        this.closeables.add(consumer);
        return consumer;
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        QueueReceiver consumer = ((QueueSession)this.getSession()).createReceiver(queue, messageSelector);
        this.closeables.add(consumer);
        return consumer;
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        QueueSender producer = ((QueueSession)this.getSession()).createSender(queue);
        this.closeables.add(producer);
        return producer;
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        TopicPublisher producer = ((TopicSession)this.getSession()).createPublisher(topic);
        this.closeables.add(producer);
        return producer;
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        TopicSubscriber consumer = ((TopicSession)this.getSession()).createSubscriber(topic);
        this.closeables.add(consumer);
        return consumer;
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        TopicSubscriber consumer = ((TopicSession)this.getSession()).createSubscriber(topic, messageSelector, noLocal);
        this.closeables.add(consumer);
        return consumer;
    }

    public void run() {
        throw new RuntimeException("Operation not supported.");
    }
}

