/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.ra;

import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ServerSession;
import javax.jms.Session;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.ra.ActiveMQRASession;
import org.codehaus.activemq.ra.ServerSessionPoolImpl;
import org.codehaus.activemq.ra.SessionAndProducer;
import org.codehaus.activemq.ra.SessionAndProducerHelper;

public class ServerSessionImpl
implements ServerSession,
SessionAndProducer,
Work {
    private static final Log log = LogFactory.getLog((Class)ServerSessionImpl.class);
    private Session session;
    private WorkManager workManager;
    private MessageEndpoint endpoint;
    private MessageProducer messageProducer;
    private final ServerSessionPoolImpl pool;
    private Object runControlMutex = new Object();
    private boolean workPendingFlag = false;
    private boolean runningFlag = false;
    private int runCounter = 0;

    public ServerSessionImpl(ServerSessionPoolImpl pool, Session session, WorkManager workManager, MessageEndpoint endpoint) throws JMSException {
        this.pool = pool;
        this.session = session;
        this.workManager = workManager;
        this.endpoint = endpoint;
        this.session.setMessageListener((MessageListener)endpoint);
    }

    public Session getSession() throws JMSException {
        return this.session;
    }

    public MessageProducer getMessageProducer() throws JMSException {
        if (this.messageProducer == null) {
            this.messageProducer = this.getSession().createProducer(null);
        }
        return this.messageProducer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws JMSException {
        log.debug((Object)"ServerSession started.");
        Object object = this.runControlMutex;
        synchronized (object) {
            ++this.runCounter;
            if (this.runningFlag || this.workPendingFlag) {
                this.workPendingFlag = true;
                log.debug((Object)"ServerSession allready running.");
                return;
            }
            this.workPendingFlag = true;
        }
        log.debug((Object)"ServerSession queuing request for a run.");
        try {
            this.workManager.scheduleWork((Work)this, Long.MAX_VALUE, null, new WorkListener(){

                public void workAccepted(WorkEvent event) {
                    log.debug((Object)("Work accepted: " + event));
                }

                public void workRejected(WorkEvent event) {
                    log.debug((Object)("Work rejected: " + event));
                }

                public void workStarted(WorkEvent event) {
                    log.debug((Object)("Work started: " + event));
                }

                public void workCompleted(WorkEvent event) {
                    log.debug((Object)("Work completed: " + event));
                }
            });
        }
        catch (WorkException e) {
            throw (JMSException)new JMSException("Work could not be started: " + (Object)((Object)e)).initCause((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        log.debug((Object)(this.toString() + " begin run()"));
        while (true) {
            Object object;
            block20: {
                JMSException e2222;
                Object var4_3;
                log.debug((Object)(this.toString() + " top of run loop"));
                object = this.runControlMutex;
                synchronized (object) {
                    this.workPendingFlag = false;
                    this.runningFlag = true;
                }
                log.debug((Object)("Running: " + this));
                try {
                    SessionAndProducerHelper.register(this);
                    this.session.run();
                    var4_3 = null;
                }
                catch (Throwable throwable) {
                    var4_3 = null;
                    SessionAndProducerHelper.unregister(this);
                    if (((ActiveMQRASession)this.session).isInLocalTransaction()) {
                        log.warn((Object)"Local transaction had not been commited.  Commiting now.");
                        try {
                            ((ActiveMQRASession)this.session).commit();
                        }
                        catch (JMSException e2222) {
                            log.info((Object)"Commit failed:", (Throwable)e2222);
                        }
                    }
                    throw throwable;
                }
                SessionAndProducerHelper.unregister(this);
                if (((ActiveMQRASession)this.session).isInLocalTransaction()) {
                    log.warn((Object)"Local transaction had not been commited.  Commiting now.");
                    try {
                        ((ActiveMQRASession)this.session).commit();
                    }
                    catch (JMSException e2222) {
                        log.info((Object)"Commit failed:", (Throwable)e2222);
                    }
                }
                break block20;
                {
                    catch (Throwable e3) {
                        log.info((Object)e3);
                        var4_3 = null;
                        SessionAndProducerHelper.unregister(this);
                        if (((ActiveMQRASession)this.session).isInLocalTransaction()) {
                            log.warn((Object)"Local transaction had not been commited.  Commiting now.");
                            try {
                                ((ActiveMQRASession)this.session).commit();
                            }
                            catch (JMSException e2222) {
                                log.info((Object)"Commit failed:", (Throwable)e2222);
                            }
                        }
                    }
                }
            }
            object = this.runControlMutex;
            synchronized (object) {
                --this.runCounter;
                this.runningFlag = false;
                if (!this.workPendingFlag) {
                    if (this.runCounter == 0) {
                        this.pool.returnToPool(this);
                    }
                    break;
                }
            }
            log.debug((Object)(this.toString() + " bottom of run loop"));
        }
        log.debug((Object)(this.toString() + " end run()"));
    }

    public void release() {
        log.debug((Object)"release called");
    }

    public String toString() {
        return "ServerSessionImpl[session=" + this.session + "]";
    }
}

