/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.ra;

import java.util.ArrayList;
import java.util.LinkedList;
import javax.jms.JMSException;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.XASession;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.transaction.xa.XAResource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.ActiveMQSession;
import org.codehaus.activemq.ra.ActiveMQAsfEndpointWorker;
import org.codehaus.activemq.ra.MessageEndpointProxy;
import org.codehaus.activemq.ra.ServerSessionImpl;
import org.codehaus.activemq.ra.TxResourceProxy;

public class ServerSessionPoolImpl
implements ServerSessionPool {
    private static final Log log = LogFactory.getLog((Class)ServerSessionPoolImpl.class);
    private static final int MAX_SESSION = 10;
    private ServerSessionImpl ss;
    private ArrayList idleSessions = new ArrayList();
    private LinkedList activeSessions = new LinkedList();
    private boolean closing = false;
    private ActiveMQAsfEndpointWorker activeMQAsfEndpointWorker;

    public ServerSessionPoolImpl(ActiveMQAsfEndpointWorker activeMQAsfEndpointWorker) {
        this.activeMQAsfEndpointWorker = activeMQAsfEndpointWorker;
    }

    private ServerSessionImpl createServerSessionImpl() throws JMSException {
        MessageEndpoint endpoint;
        int acknowledge = this.activeMQAsfEndpointWorker.transacted ? 0 : this.activeMQAsfEndpointWorker.endpointActivationKey.getActivationSpec().getAcknowledgeModeForSession();
        final Session session = this.activeMQAsfEndpointWorker.connection.createSession(this.activeMQAsfEndpointWorker.transacted, acknowledge);
        final XAResource xaResource = session instanceof XASession ? ((XASession)session).getXAResource() : null;
        try {
            TxResourceProxy txResourceProxy = new TxResourceProxy(){

                Session getSession() {
                    return session;
                }

                XAResource getXAResource() {
                    return xaResource;
                }
            };
            endpoint = this.createEndpoint(txResourceProxy);
        }
        catch (UnavailableException e) {
            session.close();
            return null;
        }
        return new ServerSessionImpl(this, (Session)((ActiveMQSession)session), this.activeMQAsfEndpointWorker.workManager, endpoint);
    }

    private MessageEndpoint createEndpoint(TxResourceProxy txResourceProxy) throws UnavailableException {
        MessageEndpoint endpoint = this.activeMQAsfEndpointWorker.endpointFactory.createEndpoint((XAResource)txResourceProxy);
        MessageEndpointProxy endpointProxy = new MessageEndpointProxy(endpoint);
        return endpointProxy;
    }

    public synchronized ServerSession getServerSession() throws JMSException {
        log.debug((Object)"ServerSession requested.");
        if (this.closing) {
            throw new JMSException("Session Pool Shutting Down.");
        }
        if (this.idleSessions.size() > 0) {
            ServerSessionImpl ss = (ServerSessionImpl)this.idleSessions.remove(this.idleSessions.size() - 1);
            this.activeSessions.addLast(ss);
            log.debug((Object)("Using idle session: " + ss));
            return ss;
        }
        if (this.activeSessions.size() >= 10) {
            return this.getExistingServerSession();
        }
        ServerSessionImpl ss = this.createServerSessionImpl();
        if (ss == null) {
            return this.getExistingServerSession();
        }
        this.activeSessions.addLast(ss);
        log.debug((Object)("Created a new session: " + ss));
        return ss;
    }

    private ServerSession getExistingServerSession() {
        ServerSessionImpl ss = (ServerSessionImpl)this.activeSessions.removeFirst();
        this.activeSessions.addLast(ss);
        log.debug((Object)("Reusing an active session: " + ss));
        return ss;
    }

    public synchronized void returnToPool(ServerSessionImpl ss) {
        log.debug((Object)("Session returned to pool: " + ss));
        this.idleSessions.add(ss);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ServerSessionPoolImpl serverSessionPoolImpl = this;
        synchronized (serverSessionPoolImpl) {
            this.closing = true;
        }
    }
}

