/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.ra.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;

public class MessageProducerProxy
implements MessageProducer {
    private MessageProducer messageProducer;
    private Destination destination;
    private int deliveryMode;
    private boolean disableMessageID;
    private boolean disableMessageTimestamp;
    private int priority;
    private long timeToLive;

    public MessageProducerProxy(MessageProducer messageProducer, Destination destination) throws JMSException {
        this.messageProducer = messageProducer;
        this.destination = destination;
        this.deliveryMode = messageProducer.getDeliveryMode();
        this.disableMessageID = messageProducer.getDisableMessageID();
        this.disableMessageTimestamp = messageProducer.getDisableMessageTimestamp();
        this.priority = messageProducer.getPriority();
        this.timeToLive = messageProducer.getTimeToLive();
    }

    public void close() throws JMSException {
        this.messageProducer.setDeliveryMode(this.deliveryMode);
        this.messageProducer.setDisableMessageID(this.disableMessageID);
        this.messageProducer.setDisableMessageTimestamp(this.disableMessageTimestamp);
        this.messageProducer.setPriority(this.priority);
        this.messageProducer.setTimeToLive(this.timeToLive);
    }

    public Destination getDestination() throws JMSException {
        return this.destination;
    }

    public int getDeliveryMode() throws JMSException {
        return this.messageProducer.getDeliveryMode();
    }

    public boolean getDisableMessageID() throws JMSException {
        return this.messageProducer.getDisableMessageID();
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return this.messageProducer.getDisableMessageTimestamp();
    }

    public int getPriority() throws JMSException {
        return this.messageProducer.getPriority();
    }

    public long getTimeToLive() throws JMSException {
        return this.messageProducer.getTimeToLive();
    }

    public void send(Destination destination, Message message) throws JMSException {
        if (destination == null) {
            destination = this.destination;
        }
        this.messageProducer.send(destination, message);
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (destination == null) {
            destination = this.destination;
        }
        this.messageProducer.send(destination, message, deliveryMode, priority, timeToLive);
    }

    public void send(Message message) throws JMSException {
        this.messageProducer.send(this.destination, message);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.messageProducer.send(this.destination, message, deliveryMode, priority, timeToLive);
    }

    public void setDeliveryMode(int i) throws JMSException {
        this.messageProducer.setDeliveryMode(i);
    }

    public void setDisableMessageID(boolean b) throws JMSException {
        this.messageProducer.setDisableMessageID(b);
    }

    public void setDisableMessageTimestamp(boolean b) throws JMSException {
        this.messageProducer.setDisableMessageTimestamp(b);
    }

    public void setPriority(int i) throws JMSException {
        this.messageProducer.setPriority(i);
    }

    public void setTimeToLive(long l) throws JMSException {
        this.messageProducer.setTimeToLive(l);
    }
}

