/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.ra.jms;

import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.codehaus.activemq.ra.SessionAndProducer;
import org.codehaus.activemq.ra.SessionAndProducerHelper;
import org.codehaus.activemq.ra.jms.MessageProducerProxy;

public class SessionProxy
implements Session,
QueueSession,
TopicSession {
    public Session getSession() throws JMSException {
        return this.getSessionAndProducer().getSession();
    }

    public QueueSession getQueueSession() throws JMSException {
        Session session = this.getSession();
        if (session instanceof QueueSession) {
            return (QueueSession)session;
        }
        throw new JMSException("The underlying JMS Session does not support QueueSession semantics: " + session);
    }

    public TopicSession getTopicSession() throws JMSException {
        Session session = this.getSession();
        if (session instanceof TopicSession) {
            return (TopicSession)session;
        }
        throw new JMSException("The underlying JMS Session does not support TopicSession semantics: " + session);
    }

    public SessionAndProducer getSessionAndProducer() throws JMSException {
        SessionAndProducer answer = SessionAndProducerHelper.getActiveSessionAndProducer();
        if (answer == null) {
            throw new JMSException("No currently active Session. This JMS provider cannot be used outside a MessageListener.onMessage() invocation");
        }
        return answer;
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        return new MessageProducerProxy(this.getSessionAndProducer().getMessageProducer(), destination);
    }

    public void close() throws JMSException {
    }

    public void commit() throws JMSException {
    }

    public void rollback() throws JMSException {
    }

    public void recover() throws JMSException {
    }

    public void run() {
        try {
            this.getSession().run();
        }
        catch (JMSException e) {
            throw new RuntimeException("Failed to run() on session due to: " + (Object)((Object)e), e);
        }
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.getSession().createBrowser(queue);
    }

    public QueueBrowser createBrowser(Queue queue, String s) throws JMSException {
        return this.getSession().createBrowser(queue, s);
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return this.getSession().createBytesMessage();
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.getSession().createConsumer(destination);
    }

    public MessageConsumer createConsumer(Destination destination, String s) throws JMSException {
        return this.getSession().createConsumer(destination, s);
    }

    public MessageConsumer createConsumer(Destination destination, String s, boolean b) throws JMSException {
        return this.getSession().createConsumer(destination, s, b);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String s) throws JMSException {
        return this.getSession().createDurableSubscriber(topic, s);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String s, String s1, boolean b) throws JMSException {
        return this.getSession().createDurableSubscriber(topic, s, s1, b);
    }

    public MapMessage createMapMessage() throws JMSException {
        return this.getSession().createMapMessage();
    }

    public Message createMessage() throws JMSException {
        return this.getSession().createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return this.getSession().createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        return this.getSession().createObjectMessage(serializable);
    }

    public Queue createQueue(String s) throws JMSException {
        return this.getSession().createQueue(s);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        return this.getSession().createStreamMessage();
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        return this.getSession().createTemporaryQueue();
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        return this.getSession().createTemporaryTopic();
    }

    public TextMessage createTextMessage() throws JMSException {
        return this.getSession().createTextMessage();
    }

    public TextMessage createTextMessage(String s) throws JMSException {
        return this.getSession().createTextMessage(s);
    }

    public Topic createTopic(String s) throws JMSException {
        return this.getSession().createTopic(s);
    }

    public int getAcknowledgeMode() throws JMSException {
        return this.getSession().getAcknowledgeMode();
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.getSession().getMessageListener();
    }

    public boolean getTransacted() throws JMSException {
        return this.getSession().getTransacted();
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.getSession().setMessageListener(messageListener);
    }

    public void unsubscribe(String s) throws JMSException {
        this.getSession().unsubscribe(s);
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        return this.getQueueSession().createReceiver(queue);
    }

    public QueueReceiver createReceiver(Queue queue, String s) throws JMSException {
        return this.getQueueSession().createReceiver(queue, s);
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        return this.getQueueSession().createSender(queue);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        return this.getTopicSession().createSubscriber(topic);
    }

    public TopicSubscriber createSubscriber(Topic topic, String s, boolean b) throws JMSException {
        return this.getTopicSession().createSubscriber(topic, s, b);
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        return this.getTopicSession().createPublisher(topic);
    }
}

