/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.ra;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ResourceAdapter;
import org.activemq.message.ActiveMQDestination;
import org.activemq.message.ActiveMQQueue;
import org.activemq.message.ActiveMQTopic;
import org.activemq.ra.ActiveMQResourceAdapter;

public class ActiveMQActivationSpec
implements ActivationSpec {
    public static final String AUTO_ACKNOWLEDGE_MODE = "Auto-acknowledge";
    public static final String DUPS_OK_ACKNOWLEDGE_MODE = "Dups-ok-acknowledge";
    public static final String DURABLE_SUBSCRIPTION = "Durable";
    public static final String NON_DURABLE_SUBSCRIPTION = "NonDurable";
    private ActiveMQResourceAdapter resourceAdapter;
    private String destinationType;
    private String messageSelector;
    boolean noLocal = false;
    private String destination;
    private String acknowledgeMode = "Auto-acknowledge";
    private String userName;
    private String password;
    private String clientId;
    private String subscriptionName;
    private String subscriptionDurability = "NonDurable";
    public static final int INVALID_ACKNOWLEDGE_MODE = -1;
    private int maxSessions = 10;
    private int maxMessagesPerSessions = 10;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void validate() throws InvalidPropertyException {
        ArrayList<PropertyDescriptor> propsNotSet = new ArrayList<PropertyDescriptor>();
        try {
            if (!this.isValidDestination()) {
                propsNotSet.add(new PropertyDescriptor("destination", ActiveMQActivationSpec.class));
            }
            if (!this.isValidDestinationType()) {
                propsNotSet.add(new PropertyDescriptor("destinationType", ActiveMQActivationSpec.class));
            }
            if (!this.isValidAcknowledgeMode()) {
                propsNotSet.add(new PropertyDescriptor("acknowledgeMode", ActiveMQActivationSpec.class));
            }
            if (!this.isValidSubscriptionDurability()) {
                propsNotSet.add(new PropertyDescriptor("subscriptionDurability", ActiveMQActivationSpec.class));
            }
            if (!this.isValidClientId()) {
                propsNotSet.add(new PropertyDescriptor("clientId", ActiveMQActivationSpec.class));
            }
            if (!this.isValidSubscriptionName()) {
                propsNotSet.add(new PropertyDescriptor("subscriptionName", ActiveMQActivationSpec.class));
            }
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        if (propsNotSet.size() > 0) {
            InvalidPropertyException e = new InvalidPropertyException("Invalid settings.");
            PropertyDescriptor[] descriptors = propsNotSet.toArray(new PropertyDescriptor[propsNotSet.size()]);
            e.setInvalidPropertyDescriptors(descriptors);
            throw e;
        }
    }

    public ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    public void setResourceAdapter(ResourceAdapter resourceAdapter) throws ResourceException {
        if (this.resourceAdapter != null) {
            throw new ResourceException("ResourceAdapter already set");
        }
        if (!(resourceAdapter instanceof ActiveMQResourceAdapter)) {
            throw new ResourceException("ResourceAdapter is not of type: " + ActiveMQResourceAdapter.class.getName());
        }
        this.resourceAdapter = (ActiveMQResourceAdapter)resourceAdapter;
    }

    public String getDestinationType() {
        if (!this.isEmpty(this.destinationType)) {
            return this.destinationType;
        }
        return null;
    }

    public void setDestinationType(String destinationType) {
        this.destinationType = destinationType;
    }

    public String getPassword() {
        if (!this.isEmpty(this.password)) {
            return this.password;
        }
        return null;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserName() {
        if (!this.isEmpty(this.userName)) {
            return this.userName;
        }
        return null;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getMessageSelector() {
        if (!this.isEmpty(this.messageSelector)) {
            return this.messageSelector;
        }
        return null;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    public boolean getNoLocal() {
        return this.noLocal;
    }

    public void setNoLocal(boolean noLocal) {
        this.noLocal = noLocal;
    }

    public String getAcknowledgeMode() {
        if (!this.isEmpty(this.acknowledgeMode)) {
            return this.acknowledgeMode;
        }
        return null;
    }

    public void setAcknowledgeMode(String acknowledgeMode) {
        this.acknowledgeMode = acknowledgeMode;
    }

    public String getClientId() {
        if (!this.isEmpty(this.clientId)) {
            return this.clientId;
        }
        return null;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getDestination() {
        if (!this.isEmpty(this.destination)) {
            return this.destination;
        }
        return null;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getSubscriptionDurability() {
        if (!this.isEmpty(this.subscriptionDurability)) {
            return this.subscriptionDurability;
        }
        return null;
    }

    public void setSubscriptionDurability(String subscriptionDurability) {
        this.subscriptionDurability = subscriptionDurability;
    }

    public String getSubscriptionName() {
        if (!this.isEmpty(this.subscriptionName)) {
            return this.subscriptionName;
        }
        return null;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    private boolean isValidSubscriptionName() {
        return !this.isDurableSubscription() ? true : this.subscriptionName != null && this.subscriptionName.trim().length() > 0;
    }

    private boolean isValidClientId() {
        return !this.isDurableSubscription() ? true : this.clientId != null && this.clientId.trim().length() > 0;
    }

    public boolean isDurableSubscription() {
        return DURABLE_SUBSCRIPTION.equals(this.subscriptionDurability);
    }

    private boolean isValidSubscriptionDurability() {
        return NON_DURABLE_SUBSCRIPTION.equals(this.subscriptionDurability) || DURABLE_SUBSCRIPTION.equals(this.subscriptionDurability);
    }

    private boolean isValidAcknowledgeMode() {
        return AUTO_ACKNOWLEDGE_MODE.equals(this.acknowledgeMode) || DUPS_OK_ACKNOWLEDGE_MODE.equals(this.acknowledgeMode);
    }

    private boolean isValidDestinationType() {
        return Queue.class.getName().equals(this.destinationType) || Topic.class.getName().equals(this.destinationType);
    }

    private boolean isValidDestination() {
        return this.destination != null && !this.destination.equals("");
    }

    private boolean isEmpty(String value) {
        return value == null || "".equals(value.trim());
    }

    public String toString() {
        return "ActiveMQActivationSpec{acknowledgeMode='" + this.acknowledgeMode + "'" + ", destinationType='" + this.destinationType + "'" + ", messageSelector='" + this.messageSelector + "'" + ", destination='" + this.destination + "'" + ", clientId='" + this.clientId + "'" + ", subscriptionName='" + this.subscriptionName + "'" + ", subscriptionDurability='" + this.subscriptionDurability + "'" + "}";
    }

    public int getAcknowledgeModeForSession() {
        int retVal = -1;
        if (this.isValidAcknowledgeMode()) {
            retVal = AUTO_ACKNOWLEDGE_MODE.equals(this.acknowledgeMode) ? 1 : 3;
        }
        return retVal;
    }

    public ActiveMQDestination createDestination() {
        ActiveMQQueue dest = null;
        if (this.isValidDestinationType() && this.isValidDestination()) {
            if (Queue.class.getName().equals(this.destinationType)) {
                dest = new ActiveMQQueue(this.destination);
            } else if (Topic.class.getName().equals(this.destinationType)) {
                dest = new ActiveMQTopic(this.destination);
            } else if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Execution should never reach here");
            }
        }
        return dest;
    }

    public int getMaxMessagesPerSessions() {
        return this.maxMessagesPerSessions;
    }

    public void setMaxMessagesPerSessions(int maxMessagesPerSessions) {
        this.maxMessagesPerSessions = maxMessagesPerSessions;
    }

    public int getMaxSessions() {
        return this.maxSessions;
    }

    public void setMaxSessions(int maxSessions) {
        this.maxSessions = maxSessions;
    }

    static {
        $assertionsDisabled = !ActiveMQActivationSpec.class.desiredAssertionStatus();
    }
}

