/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.ra;

import java.io.Serializable;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import org.activemq.ra.ActiveMQConnectionRequestInfo;
import org.activemq.ra.ActiveMQManagedConnectionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActiveMQConnectionFactory
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory,
Referenceable,
Serializable {
    private static final long serialVersionUID = -5754338187296859149L;
    private static final Log log = LogFactory.getLog((Class)ActiveMQConnectionFactory.class);
    private transient ConnectionManager manager;
    private transient ActiveMQManagedConnectionFactory factory;
    private Reference reference;
    private final ActiveMQConnectionRequestInfo info;

    public ActiveMQConnectionFactory(ActiveMQManagedConnectionFactory factory, ConnectionManager manager, ActiveMQConnectionRequestInfo info) {
        this.factory = factory;
        this.manager = manager;
        this.info = info;
    }

    public Connection createConnection() throws JMSException {
        return this.createConnection(this.info.copy());
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        ActiveMQConnectionRequestInfo i = this.info.copy();
        i.setUserName(userName);
        i.setPassword(password);
        return this.createConnection(i);
    }

    private Connection createConnection(ActiveMQConnectionRequestInfo info) throws JMSException {
        try {
            return (Connection)this.manager.allocateConnection((ManagedConnectionFactory)this.factory, (ConnectionRequestInfo)info);
        }
        catch (ResourceException e) {
            if (e.getCause() instanceof JMSException) {
                throw (JMSException)e.getCause();
            }
            log.debug((Object)"Connection could not be created:", (Throwable)e);
            throw new JMSException(e.getMessage());
        }
    }

    public Reference getReference() {
        return this.reference;
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return (QueueConnection)this.createConnection();
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        return (QueueConnection)this.createConnection(userName, password);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return (TopicConnection)this.createConnection();
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        return (TopicConnection)this.createConnection(userName, password);
    }
}

