/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.ra;

import java.io.Serializable;
import javax.resource.spi.ConnectionRequestInfo;

public class ActiveMQConnectionRequestInfo
implements ConnectionRequestInfo,
Serializable,
Cloneable {
    private static final long serialVersionUID = -5754338187296859149L;
    private String userName;
    private String password;
    private String serverUrl;
    private String clientid;
    private boolean useEmbeddedBroker = false;
    private String brokerXmlConfig;

    public ActiveMQConnectionRequestInfo copy() {
        try {
            return (ActiveMQConnectionRequestInfo)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Could not clone: ", e);
        }
    }

    public int hashCode() {
        int rc = Boolean.valueOf(this.useEmbeddedBroker).hashCode();
        if (this.serverUrl != null) {
            rc ^= this.serverUrl.hashCode();
        }
        if (this.brokerXmlConfig != null) {
            rc ^= this.brokerXmlConfig.hashCode();
        }
        return rc;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        ActiveMQConnectionRequestInfo i = (ActiveMQConnectionRequestInfo)o;
        if (this.serverUrl == null ^ i.serverUrl == null) {
            return false;
        }
        if (this.serverUrl != null && !this.serverUrl.equals(i.serverUrl)) {
            return false;
        }
        if (this.brokerXmlConfig == null ^ i.brokerXmlConfig == null) {
            return false;
        }
        if (this.brokerXmlConfig != null && !this.brokerXmlConfig.equals(i.brokerXmlConfig)) {
            return false;
        }
        return this.useEmbeddedBroker == i.useEmbeddedBroker;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String url) {
        this.serverUrl = url;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userid) {
        this.userName = userid;
    }

    public String getClientid() {
        return this.clientid;
    }

    public void setClientid(String clientid) {
        this.clientid = clientid;
    }

    public String getBrokerXmlConfig() {
        return this.brokerXmlConfig;
    }

    public void setBrokerXmlConfig(String brokerXmlConfig) {
        this.brokerXmlConfig = brokerXmlConfig;
    }

    public boolean isUseEmbeddedBroker() {
        return this.useEmbeddedBroker;
    }

    public void setUseEmbeddedBroker(boolean useEmbeddedBroker) {
        this.useEmbeddedBroker = useEmbeddedBroker;
    }

    public String toString() {
        return "ActiveMQConnectionRequestInfo{ brokerXmlConfig = '" + this.brokerXmlConfig + "' " + ", userName = '" + this.userName + "' " + ", serverUrl = '" + this.serverUrl + "' " + ", clientid = '" + this.clientid + "' " + ", useEmbeddedBroker = " + this.useEmbeddedBroker + " }";
    }
}

