/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.ra;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import javax.jms.JMSException;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import javax.jms.XASession;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.transaction.xa.XAResource;
import org.activemq.ActiveMQSession;
import org.activemq.ra.ActiveMQAsfEndpointWorker;
import org.activemq.ra.LocalAndXATransaction;
import org.activemq.ra.MessageEndpointProxy;
import org.activemq.ra.ServerSessionImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServerSessionPoolImpl
implements ServerSessionPool {
    private static final Log log = LogFactory.getLog((Class)ServerSessionPoolImpl.class);
    private final ActiveMQAsfEndpointWorker activeMQAsfEndpointWorker;
    private final int maxSessions;
    private ArrayList idleSessions = new ArrayList();
    private LinkedList activeSessions = new LinkedList();
    private boolean closing = false;

    public ServerSessionPoolImpl(ActiveMQAsfEndpointWorker activeMQAsfEndpointWorker, int maxSessions) {
        this.activeMQAsfEndpointWorker = activeMQAsfEndpointWorker;
        this.maxSessions = maxSessions;
    }

    private ServerSessionImpl createServerSessionImpl() throws JMSException {
        MessageEndpoint endpoint;
        int acknowledge = this.activeMQAsfEndpointWorker.transacted ? 0 : this.activeMQAsfEndpointWorker.endpointActivationKey.getActivationSpec().getAcknowledgeModeForSession();
        ActiveMQSession session = (ActiveMQSession)this.activeMQAsfEndpointWorker.connection.createSession(this.activeMQAsfEndpointWorker.transacted, acknowledge);
        XAResource xaResource = session instanceof XASession ? ((XASession)session).getXAResource() : null;
        try {
            endpoint = this.createEndpoint(new LocalAndXATransaction(session.getTransactionContext()));
        }
        catch (UnavailableException e) {
            session.close();
            return null;
        }
        return new ServerSessionImpl(this, session, this.activeMQAsfEndpointWorker.workManager, endpoint);
    }

    private MessageEndpoint createEndpoint(LocalAndXATransaction txResourceProxy) throws UnavailableException {
        MessageEndpoint endpoint = this.activeMQAsfEndpointWorker.endpointFactory.createEndpoint((XAResource)txResourceProxy);
        MessageEndpointProxy endpointProxy = new MessageEndpointProxy(endpoint);
        return endpointProxy;
    }

    public synchronized ServerSession getServerSession() throws JMSException {
        log.debug((Object)"ServerSession requested.");
        if (this.closing) {
            throw new JMSException("Session Pool Shutting Down.");
        }
        if (this.idleSessions.size() > 0) {
            ServerSessionImpl ss = (ServerSessionImpl)this.idleSessions.remove(this.idleSessions.size() - 1);
            this.activeSessions.addLast(ss);
            log.debug((Object)("Using idle session: " + ss));
            return ss;
        }
        if (this.activeSessions.size() >= this.maxSessions) {
            return this.getExistingServerSession();
        }
        ServerSessionImpl ss = this.createServerSessionImpl();
        if (ss == null) {
            return this.getExistingServerSession();
        }
        this.activeSessions.addLast(ss);
        log.debug((Object)("Created a new session: " + ss));
        return ss;
    }

    private ServerSession getExistingServerSession() {
        ServerSessionImpl ss = (ServerSessionImpl)this.activeSessions.removeFirst();
        this.activeSessions.addLast(ss);
        log.debug((Object)("Reusing an active session: " + ss));
        return ss;
    }

    public synchronized void returnToPool(ServerSessionImpl ss) {
        log.debug((Object)("Session returned to pool: " + ss));
        this.activeSessions.remove(ss);
        this.idleSessions.add(ss);
        this.notify();
    }

    public synchronized void removeFromPool(ServerSessionImpl ss) {
        this.activeSessions.remove(ss);
        ss.close();
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ServerSessionPoolImpl serverSessionPoolImpl = this;
        synchronized (serverSessionPoolImpl) {
            this.closing = true;
            this.closeIdleSessions();
            while (this.activeSessions.size() > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                this.closeIdleSessions();
            }
        }
    }

    private void closeIdleSessions() {
        Iterator iter = this.idleSessions.iterator();
        while (iter.hasNext()) {
            ServerSessionImpl ss = (ServerSessionImpl)iter.next();
            ss.close();
        }
    }
}

