/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.store.bdb;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.SecondaryConfig;
import com.sleepycat.je.SecondaryCursor;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.Transaction;
import java.io.IOException;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.io.WireFormat;
import org.codehaus.activemq.message.ActiveMQMessage;
import org.codehaus.activemq.message.ConsumerInfo;
import org.codehaus.activemq.service.MessageIdentity;
import org.codehaus.activemq.service.SubscriberEntry;
import org.codehaus.activemq.service.Subscription;
import org.codehaus.activemq.store.TopicMessageStore;
import org.codehaus.activemq.store.bdb.BDbHelper;
import org.codehaus.activemq.store.bdb.BDbMessageStore;
import org.codehaus.activemq.store.bdb.BDbPersistenceAdapter;
import org.codehaus.activemq.store.bdb.SequenceNumberCreator;
import org.codehaus.activemq.util.JMSExceptionHelper;

public class BDbTopicMessageStore
extends BDbMessageStore
implements TopicMessageStore {
    private static final Log log = LogFactory.getLog((Class)BDbTopicMessageStore.class);
    private Database subscriptionDatabase;

    public BDbTopicMessageStore(Database database, SecondaryDatabase secondaryDatabase, SecondaryConfig secondaryConfig, SequenceNumberCreator sequenceNumberCreator, WireFormat wireFormat, Database subscriptionDatabase) {
        super(database, secondaryDatabase, secondaryConfig, sequenceNumberCreator, wireFormat);
        this.subscriptionDatabase = subscriptionDatabase;
    }

    public void incrementMessageCount(MessageIdentity messageId) {
    }

    public void decrementMessageCountAndMaybeDelete(MessageIdentity messageIdentity) {
    }

    public void setLastAcknowledgedMessageIdentity(String subscription, MessageIdentity messageIdentity) throws JMSException {
        this.checkClosed();
        try {
            this.doSetLastAcknowledgedMessageIdentity(subscription, messageIdentity);
        }
        catch (DatabaseException e) {
            throw JMSExceptionHelper.newJMSException((String)("Failed to update last acknowledge messageID for : " + messageIdentity + ". Reason: " + (Object)((Object)e)), (Exception)((Object)e));
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void recoverSubscription(Subscription subscription, MessageIdentity lastDispatchedMessage) throws JMSException {
        this.checkClosed();
        SecondaryCursor cursor = null;
        DatabaseEntry lastAckKey = this.getLastAcknowledgedMessageID(subscription, lastDispatchedMessage);
        if (lastAckKey != null) {
            DatabaseEntry valueEntry;
            cursor = this.getSecondaryDatabase().openSecondaryCursor(BDbHelper.getTransaction(), this.getCursorConfig());
            OperationStatus status = cursor.getSearchKey(lastAckKey, valueEntry = new DatabaseEntry(), LockMode.DEFAULT);
            if (status != OperationStatus.SUCCESS) {
                log.error((Object)("Could not find the last acknowledged record for: " + subscription + ". Status: " + status));
            } else {
                while (true) {
                    if ((status = cursor.getNext(lastAckKey, valueEntry, LockMode.DEFAULT)) != OperationStatus.SUCCESS) {
                        if (status == OperationStatus.NOTFOUND) break;
                        log.warn((Object)("Strange result when iterating to end of collection: " + status));
                        break;
                    }
                    ActiveMQMessage message = this.extractMessage(valueEntry);
                    subscription.addMessage(this.getContainer(), message);
                }
            }
        }
        Object var9_10 = null;
        if (cursor == null) return;
        try {
            cursor.close();
            return;
        }
        catch (DatabaseException e) {
            log.warn((Object)("Caught exception closing cursor: " + (Object)((Object)e)), (Throwable)e);
        }
        return;
        {
            catch (DatabaseException e) {
                throw JMSExceptionHelper.newJMSException((String)("Unable to recover topic subscription for: " + subscription + ". Reason: " + (Object)((Object)e)), (Exception)((Object)e));
            }
            catch (IOException e) {
                throw JMSExceptionHelper.newJMSException((String)("Unable to recover topic subscription for: " + subscription + ". Reason: " + e), (Exception)e);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (cursor == null) throw throwable;
            try {
                cursor.close();
                throw throwable;
            }
            catch (DatabaseException e) {
                log.warn((Object)("Caught exception closing cursor: " + (Object)((Object)e)), (Throwable)e);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    public MessageIdentity getLastestMessageIdentity() throws JMSException {
        MessageIdentity messageIdentity;
        SecondaryCursor cursor;
        block13: {
            OperationStatus status;
            block11: {
                MessageIdentity messageIdentity2;
                block12: {
                    this.checkClosed();
                    cursor = null;
                    cursor = this.getSecondaryDatabase().openSecondaryCursor(BDbHelper.getTransaction(), this.getCursorConfig());
                    DatabaseEntry keyEntry = new DatabaseEntry();
                    DatabaseEntry valueEntry = new DatabaseEntry();
                    status = cursor.getLast(keyEntry, valueEntry, LockMode.DEFAULT);
                    if (status != OperationStatus.SUCCESS) break block11;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Loaded last sequence number of: " + BDbHelper.longFromBytes(keyEntry.getData())));
                    }
                    messageIdentity2 = new MessageIdentity(null, (Object)keyEntry);
                    Object var7_8 = null;
                    if (cursor == null) break block12;
                    try {
                        cursor.close();
                    }
                    catch (DatabaseException e2) {
                        log.warn((Object)("Caught exception closing cursor: " + (Object)((Object)e2)), (Throwable)e2);
                    }
                }
                return messageIdentity2;
            }
            if (status != OperationStatus.NOTFOUND) {
                log.error((Object)("Could not find the last sequence number. Status: " + status));
            }
            messageIdentity = null;
            Object var7_9 = null;
            if (cursor == null) break block13;
            try {
                cursor.close();
            }
            catch (DatabaseException e2) {
                log.warn((Object)("Caught exception closing cursor: " + (Object)((Object)e2)), (Throwable)e2);
            }
        }
        return messageIdentity;
        catch (DatabaseException e) {
            try {
                throw JMSExceptionHelper.newJMSException((String)("Unable to load the last sequence number. Reason: " + (Object)((Object)e)), (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                block14: {
                    Object var7_10 = null;
                    if (cursor == null) break block14;
                    try {
                        cursor.close();
                    }
                    catch (DatabaseException e2) {
                        log.warn((Object)("Caught exception closing cursor: " + (Object)((Object)e2)), (Throwable)e2);
                    }
                }
                throw throwable;
            }
        }
    }

    public SubscriberEntry getSubscriberEntry(ConsumerInfo info) throws JMSException {
        return null;
    }

    public void setSubscriberEntry(ConsumerInfo info, SubscriberEntry subscriberEntry) throws JMSException {
    }

    public synchronized void stop() throws JMSException {
        JMSException firstException = BDbPersistenceAdapter.closeDatabase(this.subscriptionDatabase, null);
        this.subscriptionDatabase = null;
        super.stop();
        if (firstException != null) {
            throw JMSExceptionHelper.newJMSException((String)("Unable to close the subscription database: " + firstException), (Exception)firstException);
        }
    }

    protected DatabaseEntry getLastAcknowledgedMessageID(Subscription subscription, MessageIdentity lastDispatchedMessage) throws DatabaseException {
        DatabaseEntry value;
        DatabaseEntry key = this.createKey(subscription.getPersistentKey());
        OperationStatus status = this.subscriptionDatabase.get(null, key, value = new DatabaseEntry(), null);
        if (status == OperationStatus.SUCCESS) {
            return value;
        }
        if (status == OperationStatus.NOTFOUND) {
            if (lastDispatchedMessage != null) {
                return this.doSetLastAcknowledgedMessageIdentity(subscription.getPersistentKey(), lastDispatchedMessage);
            }
        } else {
            log.warn((Object)("Unexpected status return from querying lastAcknowledgeSequenceNumber for: " + subscription + " status: " + status));
        }
        return null;
    }

    protected DatabaseEntry doSetLastAcknowledgedMessageIdentity(String subscription, MessageIdentity messageIdentity) throws DatabaseException {
        Transaction transaction = BDbHelper.getTransaction();
        DatabaseEntry key = this.createKey(subscription);
        DatabaseEntry value = this.getSequenceNumberKey(messageIdentity);
        this.subscriptionDatabase.put(transaction, key, value);
        return value;
    }

    public void deleteSubscription(String subscription) throws JMSException {
        this.checkClosed();
        try {
            this.doDeleteSubscription(subscription);
        }
        catch (DatabaseException e) {
            throw JMSExceptionHelper.newJMSException((String)("Failed to remove subscription for : " + subscription + ". Reason: " + (Object)((Object)e)), (Exception)((Object)e));
        }
    }

    protected void doDeleteSubscription(String subscription) throws DatabaseException {
        Transaction transaction = BDbHelper.getTransaction();
        DatabaseEntry key = this.createKey(subscription);
        this.subscriptionDatabase.delete(transaction, key);
    }
}

