/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.journal.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.codehaus.activemq.journal.impl.RecordLocationImpl;

class Mark {
    public static final int MARK_RECORD_SIZE = 12;
    public long sequenceId;
    public int offsetId;

    public Mark() {
    }

    public Mark(RecordLocationImpl location) {
        this.sequenceId = location.getSequenceId();
        this.offsetId = location.getSegmentOffset();
    }

    public byte[] writeExternal() throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream(16);
        DataOutputStream os = new DataOutputStream(stream);
        os.writeLong(this.sequenceId);
        os.writeInt(this.offsetId);
        os.close();
        return stream.toByteArray();
    }

    public void readExternal(byte[] data) throws IOException {
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(data));
        this.sequenceId = is.readLong();
        this.offsetId = is.readInt();
        is.close();
    }

    public void copy(Mark mark) {
        this.offsetId = mark.offsetId;
        this.sequenceId = mark.sequenceId;
    }
}

