/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.journal.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;

public class RecordHeader {
    public static final int RECORD_HEADER_SIZE = 16;
    public static final byte[] START_OF_RECORD = new byte[]{83, 111, 82};
    public int length;
    public long sequenceId;
    public byte recordType;

    public ByteBuffer toByteBuffer() {
        ByteBuffer buff = ByteBuffer.allocate(16);
        buff.put(START_OF_RECORD).putInt(this.length).putLong(this.sequenceId).put(this.recordType).flip();
        return buff;
    }

    void writeRecordHeader(DataOutput out) throws IOException {
        out.write(START_OF_RECORD);
        out.writeInt(this.length);
        out.writeLong(this.sequenceId);
        out.writeByte(this.recordType);
    }

    void readRecordHeader(DataInput in) throws IOException {
        for (int i = 0; i < START_OF_RECORD.length; ++i) {
            byte checkByte = START_OF_RECORD[i];
            if (in.readByte() == checkByte) continue;
            throw new IOException("Not a valid record header.");
        }
        this.length = in.readInt();
        this.sequenceId = in.readLong();
        this.recordType = in.readByte();
    }

    public void invalidate() {
        this.length = -1;
        this.sequenceId = -1L;
    }

    public boolean isValid() {
        return this.length >= 0;
    }

    public void bulkSet(byte recordType, long sequenceId, byte[] data) {
        this.length = data.length;
        this.sequenceId = sequenceId;
        this.recordType = recordType;
    }
}

