/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.store.journal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.journal.RecordLocation;
import org.codehaus.activemq.message.ActiveMQMessage;
import org.codehaus.activemq.message.MessageAck;
import org.codehaus.activemq.message.Packet;
import org.codehaus.activemq.service.MessageIdentity;
import org.codehaus.activemq.service.QueueMessageContainer;
import org.codehaus.activemq.store.MessageStore;
import org.codehaus.activemq.store.PersistenceAdapter;
import org.codehaus.activemq.store.cache.CacheMessageStore;
import org.codehaus.activemq.store.cache.CacheMessageStoreAware;
import org.codehaus.activemq.store.journal.JournalPersistenceAdapter;
import org.codehaus.activemq.util.Callback;
import org.codehaus.activemq.util.TransactionTemplate;

public class JournalMessageStore
implements MessageStore,
CacheMessageStoreAware {
    private static final Log log = LogFactory.getLog((Class)JournalMessageStore.class);
    private final JournalPersistenceAdapter peristenceAdapter;
    private final MessageStore longTermStore;
    private final String destinationName;
    private final TransactionTemplate transactionTemplate;
    private HashMap addedMessageLocations = new HashMap();
    private ArrayList removedMessageLocations = new ArrayList();
    private MessageStore cacheMessageStore = this;
    private boolean sync = true;

    public JournalMessageStore(JournalPersistenceAdapter adapter, MessageStore checkpointStore, String destinationName, boolean sync) {
        this.peristenceAdapter = adapter;
        this.longTermStore = checkpointStore;
        this.destinationName = destinationName;
        this.sync = sync;
        this.transactionTemplate = new TransactionTemplate((PersistenceAdapter)adapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageIdentity addMessage(ActiveMQMessage message) throws JMSException {
        boolean sync = message.isReceiptRequired();
        RecordLocation location = this.peristenceAdapter.writePacket(this.destinationName, (Packet)message, sync);
        JournalMessageStore journalMessageStore = this;
        synchronized (journalMessageStore) {
            this.addedMessageLocations.put(message.getJMSMessageIdentity(), location);
        }
        MessageIdentity messageIdentity = message.getJMSMessageIdentity();
        messageIdentity.setSequenceNumber((Object)location);
        return messageIdentity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessage(MessageIdentity identity, MessageAck ack) throws JMSException {
        RecordLocation ackLocation = this.peristenceAdapter.writePacket(this.destinationName, (Packet)ack, this.sync);
        JournalMessageStore journalMessageStore = this;
        synchronized (journalMessageStore) {
            RecordLocation addLocation = (RecordLocation)this.addedMessageLocations.remove(identity);
            if (addLocation == null) {
                this.removedMessageLocations.add(new AckData(ack, ackLocation));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordLocation checkpoint() throws JMSException {
        ArrayList removedMessageLocations;
        ArrayList addedMessageIdentitys;
        final RecordLocation[] rc = new RecordLocation[]{null};
        JournalMessageStore journalMessageStore = this;
        synchronized (journalMessageStore) {
            addedMessageIdentitys = new ArrayList(this.addedMessageLocations.keySet());
            removedMessageLocations = this.removedMessageLocations;
            this.removedMessageLocations = new ArrayList();
        }
        this.transactionTemplate.run(new Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute() throws Throwable {
                Iterator iterator = addedMessageIdentitys.iterator();
                while (iterator.hasNext()) {
                    MessageIdentity identity = (MessageIdentity)iterator.next();
                    ActiveMQMessage msg = JournalMessageStore.this.getCacheMessage(identity);
                    JournalMessageStore.this.longTermStore.addMessage(msg);
                    1 var4_4 = this;
                    synchronized (var4_4) {
                        RecordLocation location = (RecordLocation)JournalMessageStore.this.addedMessageLocations.remove(identity);
                        if (rc[0] == null || rc[0].compareTo(location) < 0) {
                            rc[0] = location;
                        }
                    }
                }
                iterator = removedMessageLocations.iterator();
                while (iterator.hasNext()) {
                    AckData data = (AckData)iterator.next();
                    JournalMessageStore.this.longTermStore.removeMessage(data.ack.getMessageIdentity(), data.ack);
                    if (rc[0] != null && rc[0].compareTo(data.location) >= 0) continue;
                    rc[0] = data.location;
                }
            }
        });
        return rc[0];
    }

    private ActiveMQMessage getCacheMessage(MessageIdentity identity) throws JMSException {
        return this.cacheMessageStore.getMessage(identity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActiveMQMessage getMessage(MessageIdentity identity) throws JMSException {
        ActiveMQMessage answer = null;
        Object location = identity.getSequenceNumber();
        if (location == null) {
            JournalMessageStore journalMessageStore = this;
            synchronized (journalMessageStore) {
                location = this.addedMessageLocations.get(identity);
            }
        }
        if (location != null && location instanceof RecordLocation && (answer = (ActiveMQMessage)this.peristenceAdapter.readPacket((RecordLocation)location)) != null) {
            return answer;
        }
        return this.longTermStore.getMessage(identity);
    }

    public synchronized void recover(QueueMessageContainer container) throws JMSException {
        this.longTermStore.recover(container);
    }

    public void start() throws JMSException {
        this.longTermStore.start();
    }

    public void stop() throws JMSException {
        this.longTermStore.stop();
    }

    public MessageStore getLongTermStore() {
        return this.longTermStore;
    }

    public void setCacheMessageStore(CacheMessageStore store) {
        this.cacheMessageStore = store;
        if (this.longTermStore instanceof CacheMessageStoreAware) {
            ((CacheMessageStoreAware)this.longTermStore).setCacheMessageStore(store);
        }
    }

    public void removeAllMessages() throws JMSException {
        this.peristenceAdapter.checkpoint();
        this.longTermStore.removeAllMessages();
    }

    private static final class AckData {
        private final RecordLocation location;
        private final MessageAck ack;

        AckData(MessageAck ack, RecordLocation location) {
            this.ack = ack;
            this.location = location;
        }
    }
}

