/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.web;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.ActiveMQConnection;
import org.codehaus.activemq.ActiveMQConnectionFactory;
import org.codehaus.activemq.ActiveMQSession;
import org.codehaus.activemq.web.MessageServletSupport;

public class WebClient
implements HttpSessionActivationListener,
Externalizable {
    public static final String webClientAttribute = "org.codehaus.activemq.webclient";
    public static final String connectionFactoryAttribute = "org.codehaus.activemq.connectionFactory";
    public static final String queueConsumersAttribute = "org.codehaus.activemq.queueConsumers";
    public static final String brokerUrlInitParam = "org.codehaus.activemq.brokerURL";
    public static final String embeddedBrokerInitParam = "org.codehaus.activemq.embeddedBroker";
    private static final Log log = LogFactory.getLog((Class)WebClient.class);
    private static transient ConnectionFactory factory;
    private static transient Map queueConsumers;
    private transient ServletContext context;
    private transient ActiveMQConnection connection;
    private transient ActiveMQSession session;
    private transient MessageProducer producer;
    private transient Map topicConsumers = new ConcurrentHashMap();

    public static WebClient getWebClient(HttpSession session) {
        return (WebClient)session.getAttribute(webClientAttribute);
    }

    public static void initContext(ServletContext context) {
        factory = WebClient.initConnectionFactory(context);
        if (factory == null) {
            log.warn((Object)"No ConnectionFactory available in the ServletContext for: org.codehaus.activemq.connectionFactory");
            factory = new ActiveMQConnectionFactory("vm://localhost");
            context.setAttribute(connectionFactoryAttribute, (Object)factory);
        }
        queueConsumers = WebClient.initQueueConsumers(context);
    }

    public WebClient() {
    }

    public WebClient(ServletContext context) {
        this.context = context;
        WebClient.initContext(context);
    }

    public void start() throws JMSException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws JMSException {
        try {
            this.connection.close();
            Object var2_1 = null;
            this.producer = null;
            this.session = null;
            this.connection = null;
            this.topicConsumers.clear();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.producer = null;
            this.session = null;
            this.connection = null;
            this.topicConsumers.clear();
            throw throwable;
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.topicConsumers = new HashMap();
    }

    public void send(Destination destination, Message message) throws JMSException {
        if (this.producer == null) {
            this.producer = this.getSession().createProducer(null);
        }
        log.info((Object)("Sending to destination: " + destination));
        this.producer.send(destination, message);
        log.info((Object)("Sent! message: " + message));
    }

    public Session getSession() throws JMSException {
        if (this.session == null) {
            this.session = this.createSession();
        }
        return this.session;
    }

    public ActiveMQConnection getConnection() throws JMSException {
        if (this.connection == null) {
            this.connection = (ActiveMQConnection)factory.createConnection();
            this.connection.start();
        }
        return this.connection;
    }

    public void sessionWillPassivate(HttpSessionEvent event) {
        try {
            this.stop();
        }
        catch (JMSException e) {
            log.warn((Object)("Could not close connection: " + (Object)((Object)e)), (Throwable)e);
        }
    }

    public void sessionDidActivate(HttpSessionEvent event) {
        this.context = event.getSession().getServletContext();
        WebClient.initContext(this.context);
    }

    public static Map initQueueConsumers(ServletContext context) {
        HashMap answer = (HashMap)context.getAttribute(queueConsumersAttribute);
        if (answer == null) {
            answer = new HashMap();
            context.setAttribute(queueConsumersAttribute, answer);
        }
        return answer;
    }

    public static ConnectionFactory initConnectionFactory(ServletContext servletContext) {
        ConnectionFactory connectionFactory = (ConnectionFactory)servletContext.getAttribute(connectionFactoryAttribute);
        if (connectionFactory == null) {
            String brokerURL = servletContext.getInitParameter(brokerUrlInitParam);
            servletContext.log("Value of: org.codehaus.activemq.brokerURL is: " + brokerURL);
            if (brokerURL == null) {
                brokerURL = "vm://localhost";
            }
            boolean embeddedBroker = MessageServletSupport.asBoolean(servletContext.getInitParameter(embeddedBrokerInitParam));
            servletContext.log("Use embedded broker: " + embeddedBroker);
            ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(brokerURL);
            factory.setUseEmbeddedBroker(embeddedBroker);
            connectionFactory = factory;
            servletContext.setAttribute(connectionFactoryAttribute, (Object)connectionFactory);
        }
        return connectionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MessageConsumer getConsumer(Destination destination) throws JMSException {
        if (destination instanceof Topic) {
            MessageConsumer consumer = (MessageConsumer)this.topicConsumers.get(destination);
            if (consumer == null) {
                consumer = this.session.createConsumer(destination);
                this.topicConsumers.put(destination, consumer);
            }
            return consumer;
        }
        Map map = queueConsumers;
        synchronized (map) {
            SessionConsumerPair pair = (SessionConsumerPair)queueConsumers.get(destination);
            if (pair == null) {
                pair = this.createSessionConsumerPair(destination);
                queueConsumers.put(destination, pair);
            }
            return pair.consumer;
        }
    }

    protected ActiveMQSession createSession() throws JMSException {
        return (ActiveMQSession)this.getConnection().createSession(false, 1);
    }

    protected SessionConsumerPair createSessionConsumerPair(Destination destination) throws JMSException {
        SessionConsumerPair answer = new SessionConsumerPair();
        answer.session = this.createSession();
        answer.consumer = answer.session.createConsumer(destination);
        return answer;
    }

    protected static class SessionConsumerPair {
        public Session session;
        public MessageConsumer consumer;

        protected SessionConsumerPair() {
        }
    }
}

