/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activemq.message.ActiveMQDestination;
import org.activemq.web.MessageServletSupport;
import org.activemq.web.WebClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageServlet
extends MessageServletSupport {
    private static final Log log = LogFactory.getLog((Class)MessageServlet.class);
    private String readTimeoutParameter = "readTimeout";
    private long defaultReadTimeout = -1L;
    private long maximumReadTimeout = 1200L;

    public void init() throws ServletException {
        ServletConfig servletConfig = this.getServletConfig();
        String name = servletConfig.getInitParameter("defaultReadTimeout");
        if (name != null) {
            this.defaultReadTimeout = this.asLong(name);
        }
        if ((name = servletConfig.getInitParameter("maximumReadTimeout")) != null) {
            this.maximumReadTimeout = this.asLong(name);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            WebClient client = this.getWebClient(request);
            String text = this.getPostedMessageBody(request);
            Destination destination = this.getDestination(client, request);
            if (log.isInfoEnabled()) {
                log.info((Object)("Sending message to: " + ActiveMQDestination.inspect((Destination)destination) + " with text: " + text));
            }
            TextMessage message = client.getSession().createTextMessage(text);
            this.appendParametersToMessage(request, message);
            client.send(destination, (Message)message);
            response.setHeader("messageID", message.getJMSMessageID());
            response.setStatus(200);
        }
        catch (JMSException e) {
            throw new ServletException("Could not post JMS message: " + (Object)((Object)e), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            WebClient client = this.getWebClient(request);
            Destination destination = this.getDestination(client, request);
            long timeout = this.getReadTimeout(request);
            if (log.isInfoEnabled()) {
                log.info((Object)("Receiving message from: " + ActiveMQDestination.inspect((Destination)destination) + " with timeout: " + timeout));
            }
            MessageConsumer consumer = client.getConsumer(destination);
            Message message = null;
            MessageConsumer messageConsumer = consumer;
            synchronized (messageConsumer) {
                message = timeout == 0L ? consumer.receiveNoWait() : consumer.receive(timeout);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("HTTP GET servlet done! message: " + message));
            }
            this.sendMessageResponse(request, response, message);
        }
        catch (JMSException e) {
            throw new ServletException("Could not post JMS message: " + (Object)((Object)e), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            WebClient client = this.getWebClient(request);
            Destination destination = this.getDestination(client, request);
            MessageConsumer consumer = client.getConsumer(destination);
            Message message = null;
            MessageConsumer messageConsumer = consumer;
            synchronized (messageConsumer) {
                message = consumer.receiveNoWait();
            }
            this.sendMessageResponse(request, response, message);
        }
        catch (JMSException e) {
            throw new ServletException("Could not post JMS message: " + (Object)((Object)e), (Throwable)e);
        }
    }

    protected void sendMessageResponse(HttpServletRequest request, HttpServletResponse response, Message message) throws JMSException, IOException {
        response.setContentType("text/xml");
        boolean ajax = this.isRicoAjax(request);
        PrintWriter writer = response.getWriter();
        if (ajax) {
            writer.print("<ajax-response><response type='object' id='");
            writer.print(request.getParameter("id"));
            writer.println("'>");
        }
        if (message == null) {
            if (ajax) {
                writer.println("</response></ajax-response>");
                response.setStatus(200);
            } else {
                response.setStatus(204);
            }
        } else {
            String type = this.getContentType(request);
            if (type != null) {
                response.setContentType(type);
            }
            this.setResponseHeaders(response, message);
            if (message instanceof TextMessage) {
                TextMessage textMsg = (TextMessage)message;
                writer.print(textMsg.getText());
            } else if (message instanceof ObjectMessage) {
                ObjectMessage objectMsg = (ObjectMessage)message;
                Serializable object = objectMsg.getObject();
                writer.print(object.toString());
            }
            if (ajax) {
                writer.println("</response></ajax-response>");
            }
            response.setStatus(200);
        }
    }

    protected boolean isRicoAjax(HttpServletRequest request) {
        String rico = request.getParameter("rico");
        return rico != null && rico.equals("true");
    }

    protected String getContentType(HttpServletRequest request) {
        String value = request.getParameter("xml");
        if (value != null && "true".equalsIgnoreCase(value)) {
            return "text/xml";
        }
        return null;
    }

    protected void setResponseHeaders(HttpServletResponse response, Message message) throws JMSException {
        response.setHeader("destination", message.getJMSDestination().toString());
        response.setHeader("id", message.getJMSMessageID());
    }

    protected long getReadTimeout(HttpServletRequest request) {
        long answer = this.defaultReadTimeout;
        String name = request.getParameter(this.readTimeoutParameter);
        if (name != null) {
            answer = this.asLong(name);
        }
        if (answer < 0L || answer > this.maximumReadTimeout) {
            answer = this.maximumReadTimeout;
        }
        return answer;
    }
}

