/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activemq.MessageAvailableConsumer;
import org.activemq.MessageAvailableListener;
import org.activemq.web.MessageServletSupport;
import org.activemq.web.WebClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.util.ajax.Continuation;
import org.mortbay.util.ajax.ContinuationSupport;

public class MessageServlet
extends MessageServletSupport {
    private static final Log log = LogFactory.getLog((Class)MessageServlet.class);
    private String readTimeoutParameter = "readTimeout";
    private long defaultReadTimeout = -1L;
    private long maximumReadTimeout = 20000L;

    public void init() throws ServletException {
        ServletConfig servletConfig = this.getServletConfig();
        String name = servletConfig.getInitParameter("defaultReadTimeout");
        if (name != null) {
            this.defaultReadTimeout = this.asLong(name);
        }
        if ((name = servletConfig.getInitParameter("maximumReadTimeout")) != null) {
            this.maximumReadTimeout = this.asLong(name);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            WebClient client = this.getWebClient(request);
            String text = this.getPostedMessageBody(request);
            Destination destination = this.getDestination(client, request);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sending message to: " + destination + " with text: " + text));
            }
            TextMessage message = client.getSession().createTextMessage(text);
            this.appendParametersToMessage(request, message);
            client.send(destination, (Message)message);
            response.setHeader("messageID", message.getJMSMessageID());
            response.setStatus(200);
        }
        catch (JMSException e) {
            throw new ServletException("Could not post JMS message: " + (Object)((Object)e), (Throwable)e);
        }
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doMessages(request, response, 1);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doMessages(request, response, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doMessages(HttpServletRequest request, HttpServletResponse response, int maxMessages) throws ServletException, IOException {
        int messages = 0;
        try {
            WebClient client = this.getWebClient(request);
            Destination destination = this.getDestination(client, request);
            long timeout = this.getReadTimeout(request);
            boolean ajax = this.isRicoAjax(request);
            if (!ajax) {
                maxMessages = 1;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Receiving message(s) from: " + destination + " with timeout: " + timeout));
            }
            MessageAvailableConsumer consumer = (MessageAvailableConsumer)client.getConsumer(destination);
            Continuation continuation = null;
            Listener listener = null;
            Message message = null;
            MessageAvailableConsumer messageAvailableConsumer = consumer;
            synchronized (messageAvailableConsumer) {
                listener = (Listener)consumer.getAvailableListener();
                if (listener == null) {
                    listener = new Listener((MessageConsumer)consumer);
                    consumer.setAvailableListener((MessageAvailableListener)listener);
                }
                if ((message = consumer.receiveNoWait()) == null) {
                    continuation = ContinuationSupport.getContinuation((HttpServletRequest)request, (Object)consumer);
                    listener.setContinuation(continuation);
                    continuation.suspend(timeout);
                }
                if (message == null) {
                    message = consumer.receiveNoWait();
                }
                response.setContentType("text/xml");
                PrintWriter writer = response.getWriter();
                if (ajax) {
                    writer.println("<ajax-response>");
                }
                if (message == null) {
                    response.setStatus(ajax ? 200 : 204);
                } else {
                    response.setStatus(200);
                    String type = this.getContentType(request);
                    if (type != null) {
                        response.setContentType(type);
                    }
                    while ((maxMessages < 0 || messages < maxMessages) && message != null) {
                        if (ajax) {
                            writer.print("<response type='object' id='");
                            writer.print(request.getParameter("id"));
                            writer.println("'>");
                        } else {
                            this.setResponseHeaders(response, message);
                        }
                        this.writeMessageResponse(writer, message);
                        if (ajax) {
                            writer.println("</response>");
                        }
                        message = consumer.receiveNoWait();
                        ++messages;
                    }
                }
                if (ajax) {
                    writer.println("<response type='object' id='poll'><ok/></response>");
                    writer.println("</ajax-response>");
                }
            }
        }
        catch (JMSException e) {
            throw new ServletException("Could not post JMS message: " + (Object)((Object)e), (Throwable)e);
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Received " + messages + " message(s)"));
            }
        }
    }

    protected void writeMessageResponse(PrintWriter writer, Message message) throws JMSException, IOException {
        if (message instanceof TextMessage) {
            TextMessage textMsg = (TextMessage)message;
            writer.print(textMsg.getText());
        } else if (message instanceof ObjectMessage) {
            ObjectMessage objectMsg = (ObjectMessage)message;
            Serializable object = objectMsg.getObject();
            writer.print(object.toString());
        }
    }

    protected boolean isRicoAjax(HttpServletRequest request) {
        String rico = request.getParameter("rico");
        return rico != null && rico.equals("true");
    }

    protected String getContentType(HttpServletRequest request) {
        String value = request.getParameter("xml");
        if (value != null && "true".equalsIgnoreCase(value)) {
            return "text/xml";
        }
        return null;
    }

    protected void setResponseHeaders(HttpServletResponse response, Message message) throws JMSException {
        response.setHeader("destination", message.getJMSDestination().toString());
        response.setHeader("id", message.getJMSMessageID());
    }

    protected long getReadTimeout(HttpServletRequest request) {
        long answer = this.defaultReadTimeout;
        String name = request.getParameter(this.readTimeoutParameter);
        if (name != null) {
            answer = this.asLong(name);
        }
        if (answer < 0L || answer > this.maximumReadTimeout) {
            answer = this.maximumReadTimeout;
        }
        return answer;
    }

    private class Listener
    implements MessageAvailableListener {
        MessageConsumer consumer;
        Continuation continuation;
        List queue = new LinkedList();
        static final /* synthetic */ boolean $assertionsDisabled;

        Listener(MessageConsumer consumer) {
            this.consumer = consumer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setContinuation(Continuation continuation) {
            MessageConsumer messageConsumer = this.consumer;
            synchronized (messageConsumer) {
                this.continuation = continuation;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessageAvailable(MessageConsumer consumer) {
            if (!$assertionsDisabled && this.consumer != consumer) {
                throw new AssertionError();
            }
            MessageConsumer messageConsumer = this.consumer;
            synchronized (messageConsumer) {
                if (this.continuation != null) {
                    this.continuation.resume();
                }
                this.continuation = null;
            }
        }

        static {
            $assertionsDisabled = !(class$org$activemq$web$MessageServlet == null ? (class$org$activemq$web$MessageServlet = MessageServlet.class$("org.activemq.web.MessageServlet")) : class$org$activemq$web$MessageServlet).desiredAssertionStatus();
        }
    }
}

