/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime;

import com.sun.xml.bind.WhiteSpaceProcessor;
import com.sun.xml.bind.api.AccessorException;
import com.sun.xml.bind.serializer.AbortSerializationException;
import com.sun.xml.bind.unmarshaller.Patcher;
import com.sun.xml.bind.v2.TODO;
import com.sun.xml.bind.v2.runtime.Messages;
import com.sun.xml.bind.v2.runtime.Transducer;
import com.sun.xml.bind.v2.runtime.UnmarshallingContext;
import com.sun.xml.bind.v2.runtime.XMLSerializer;
import com.sun.xml.bind.v2.runtime.reflect.Accessor;
import com.sun.xml.bind.v2.runtime.reflect.ListIterator;
import com.sun.xml.bind.v2.runtime.reflect.Lister;
import com.sun.xml.bind.v2.runtime.reflect.TransducedAccessor;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.bind.helpers.ValidationEventImpl;
import javax.xml.bind.helpers.ValidationEventLocatorImpl;
import org.xml.sax.SAXException;

public abstract class IDHandler {
    private IDHandler() {
    }

    private static void errorUnresolvedIDREF(Object bean, String idref, UnmarshallingContext context) throws SAXException {
        context.handleEvent((ValidationEvent)new ValidationEventImpl(1, Messages.UNRESOLVED_IDREF.format(idref), (ValidationEventLocator)new ValidationEventLocatorImpl(bean)), true);
    }

    private static void errorMissingId(XMLSerializer context, Object obj) throws AbortSerializationException {
        context.reportError((ValidationEvent)new ValidationEventImpl(1, Messages.MISSING_ID.format(obj), (ValidationEventLocator)new ValidationEventLocatorImpl(obj)));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ID<ValueT>
    implements Transducer<ValueT> {
        private final Transducer<ValueT> core;

        public ID(Transducer<ValueT> core) {
            this.core = core;
        }

        @Override
        public boolean isDefault() {
            return false;
        }

        @Override
        public boolean useNamespace() {
            return this.core.useNamespace();
        }

        @Override
        public void declareNamespace(ValueT o, XMLSerializer w) throws AccessorException {
            this.core.declareNamespace(o, w);
        }

        @Override
        public String print(ValueT o, XMLSerializer w) throws AccessorException {
            return this.core.print(o, w);
        }

        @Override
        public ValueT parse(CharSequence lexical, UnmarshallingContext ctxt) throws AccessorException, SAXException {
            String value = ((Object)WhiteSpaceProcessor.trim(lexical)).toString();
            ctxt.addToIdTable(value);
            return this.core.parse(value, ctxt);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IDREF<BeanT, TargetT>
    extends TransducedAccessor<BeanT> {
        private final Accessor<BeanT, TargetT> acc;
        private final Class<TargetT> targetType;

        public IDREF(Accessor<BeanT, TargetT> acc) {
            this.acc = acc;
            this.targetType = acc.getValueType();
        }

        @Override
        public String print(BeanT bean, XMLSerializer w) throws AccessorException, SAXException {
            Object target = this.acc.get(bean);
            try {
                String id = w.grammar.getBeanInfo(target, true).getId(target, w);
                if (id == null) {
                    IDHandler.errorMissingId(w, target);
                }
                return id;
            }
            catch (JAXBException e) {
                w.reportError(null, e);
                return null;
            }
        }

        private boolean resolveId(BeanT bean, String id, UnmarshallingContext context) throws AccessorException {
            Object t = context.getObjectFromId(id);
            if (t == null) {
                return false;
            }
            if (!this.targetType.isInstance(t)) {
                TODO.prototype();
            }
            this.acc.set(bean, t);
            return true;
        }

        @Override
        public void parse(final BeanT bean, CharSequence lexical, final UnmarshallingContext context) throws AccessorException {
            final String idref = ((Object)WhiteSpaceProcessor.trim(lexical)).toString();
            if (!this.resolveId(bean, idref, context)) {
                context.addPatcher(new Patcher(){

                    public void run() throws SAXException {
                        try {
                            if (!IDREF.this.resolveId(bean, idref, context)) {
                                IDHandler.errorUnresolvedIDREF(bean, idref, context);
                            }
                        }
                        catch (AccessorException e) {
                            context.handleError(e);
                        }
                    }
                });
            }
        }

        @Override
        public boolean hasValue(BeanT bean) throws AccessorException {
            return this.acc.get(bean) != null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IDREFSIterator
    implements ListIterator<String> {
        private final ListIterator i;
        private final XMLSerializer context;
        private Object last;

        private IDREFSIterator(ListIterator i, XMLSerializer context) {
            this.i = i;
            this.context = context;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        public Object last() {
            return this.last;
        }

        @Override
        public String next() throws SAXException, JAXBException {
            this.last = this.i.next();
            String id = this.context.grammar.getBeanInfo(this.last, true).getId(this.last, this.context);
            if (id == null) {
                IDHandler.errorMissingId(this.context, this.last);
            }
            return id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IDREFS<BeanT, PropT>
    extends Lister<BeanT, PropT, String, Pack> {
        private final Lister<BeanT, PropT, Object, Object> core;

        public IDREFS(Lister<BeanT, PropT, Object, Object> core) {
            this.core = core;
        }

        @Override
        public ListIterator<String> iterator(PropT prop, XMLSerializer context) {
            ListIterator<Object> i = this.core.iterator(prop, context);
            return new IDREFSIterator(i, context);
        }

        @Override
        public Pack startPacking(BeanT bean, Accessor<BeanT, PropT> acc, UnmarshallingContext context) {
            return new Pack(bean, acc, context);
        }

        @Override
        public void addToPack(Pack pack, String item) {
            pack.add(item);
        }

        @Override
        public void endPacking(Pack pack, BeanT bean, Accessor<BeanT, PropT> acc) {
        }

        @Override
        public void reset(BeanT bean, Accessor<BeanT, PropT> acc) throws AccessorException {
            this.core.reset(bean, acc);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class Pack
        implements Patcher {
            private final BeanT bean;
            private final List<String> idrefs = new ArrayList<String>();
            private final UnmarshallingContext context;
            private final Accessor<BeanT, PropT> acc;

            public Pack(BeanT bean, Accessor<BeanT, PropT> acc, UnmarshallingContext context) {
                this.bean = bean;
                this.acc = acc;
                this.context = context;
                context.addPatcher(this);
            }

            public void add(String item) {
                this.idrefs.add(item);
            }

            @Override
            public void run() throws SAXException {
                try {
                    Object pack = IDREFS.this.core.startPacking(this.bean, this.acc, this.context);
                    for (String id : this.idrefs) {
                        Object t = this.context.getObjectFromId(id);
                        if (t == null) {
                            IDHandler.errorUnresolvedIDREF(this.bean, id, this.context);
                            continue;
                        }
                        TODO.prototype();
                        IDREFS.this.core.addToPack(pack, t);
                    }
                    IDREFS.this.core.endPacking(pack, this.bean, this.acc);
                }
                catch (AccessorException e) {
                    this.context.handleError(e);
                }
            }
        }
    }
}

