/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime;

import com.sun.xml.bind.DatatypeConverterImpl;
import com.sun.xml.bind.marshaller.CharacterEscapeHandler;
import com.sun.xml.bind.marshaller.DataWriter;
import com.sun.xml.bind.marshaller.DumbEscapeHandler;
import com.sun.xml.bind.marshaller.Messages;
import com.sun.xml.bind.marshaller.MinimumEscapeHandler;
import com.sun.xml.bind.marshaller.NamespacePrefixMapper;
import com.sun.xml.bind.marshaller.NioEscapeHandler;
import com.sun.xml.bind.marshaller.SAX2DOMEx;
import com.sun.xml.bind.marshaller.XMLWriter;
import com.sun.xml.bind.v2.runtime.DomPostInitAction;
import com.sun.xml.bind.v2.runtime.JAXBContextImpl;
import com.sun.xml.bind.v2.runtime.JaxBeanInfo;
import com.sun.xml.bind.v2.runtime.Name;
import com.sun.xml.bind.v2.runtime.XMLSerializer;
import com.sun.xml.bind.v2.runtime.output.Encoded;
import com.sun.xml.bind.v2.runtime.output.IndentingUTF8XmlOutput;
import com.sun.xml.bind.v2.runtime.output.SAXOutput;
import com.sun.xml.bind.v2.runtime.output.UTF8XmlOutput;
import com.sun.xml.bind.v2.runtime.output.XMLEventWriterOutput;
import com.sun.xml.bind.v2.runtime.output.XMLStreamWriterOutput;
import com.sun.xml.bind.v2.runtime.output.XmlOutput;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.DatatypeConverterInterface;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.helpers.AbstractMarshallerImpl;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MarshallerImpl
extends AbstractMarshallerImpl {
    private String indent = "    ";
    private NamespacePrefixMapper prefixMapper = null;
    private CharacterEscapeHandler escapeHandler = null;
    private boolean printXmlDeclaration = true;
    private String header = null;
    final JAXBContextImpl context;
    protected final XMLSerializer serializer;
    private DocumentBuilder domFactory;
    private static final String INDENT_STRING = "com.sun.xml.bind.indentString";
    private static final String PREFIX_MAPPER = "com.sun.xml.bind.namespacePrefixMapper";
    private static final String ENCODING_HANDLER = "com.sun.xml.bind.characterEscapeHandler";
    private static final String XMLDECLARATION = "com.sun.xml.bind.xmlDeclaration";
    private static final String XML_HEADERS = "com.sun.xml.bind.xmlHeaders";

    public MarshallerImpl(JAXBContextImpl c) {
        DatatypeConverter.setDatatypeConverter((DatatypeConverterInterface)DatatypeConverterImpl.theInstance);
        this.context = c;
        this.serializer = new XMLSerializer(this);
    }

    public void marshal(Object obj, XMLStreamWriter writer) throws JAXBException {
        this.write(obj, new XMLStreamWriterOutput(writer), this.isFragment(), null);
    }

    public void marshal(Object obj, XMLEventWriter writer) throws JAXBException {
        this.write(obj, new XMLEventWriterOutput(writer), this.isFragment(), null);
    }

    public void marshal(Object obj, XmlOutput output) throws JAXBException {
        this.write(obj, output, this.isFragment(), null);
    }

    public void marshal(Object target, Result result) throws JAXBException {
        if (result instanceof SAXResult) {
            this.write(target, new SAXOutput(((SAXResult)result).getHandler()), this.isFragment(), null);
            return;
        }
        if (result instanceof DOMResult) {
            Node node = ((DOMResult)result).getNode();
            if (node == null) {
                try {
                    Document doc = this.createDocument();
                    ((DOMResult)result).setNode(doc);
                    this.write(target, new SAXOutput(new SAX2DOMEx(doc)), false, null);
                }
                catch (ParserConfigurationException pce) {
                    throw new AssertionError((Object)pce);
                }
            } else {
                this.write(target, new SAXOutput(new SAX2DOMEx(node)), false, new DomPostInitAction(node, this.serializer));
            }
            return;
        }
        if (result instanceof StreamResult) {
            StreamResult sr = (StreamResult)result;
            XmlOutput w = null;
            if (sr.getWriter() != null) {
                w = this.createWriter(sr.getWriter());
            } else if (sr.getOutputStream() != null) {
                w = this.createWriter(sr.getOutputStream());
            } else if (sr.getSystemId() != null) {
                String fileURL = sr.getSystemId();
                if (fileURL.startsWith("file:///")) {
                    fileURL = fileURL.substring(8).indexOf(":") > 0 ? fileURL.substring(8) : fileURL.substring(7);
                }
                try {
                    w = this.createWriter(new FileOutputStream(fileURL));
                }
                catch (IOException e) {
                    throw new MarshalException((Throwable)e);
                }
            }
            if (w == null) {
                throw new IllegalArgumentException();
            }
            this.write(target, w, this.isFragment(), null);
            return;
        }
        throw new MarshalException(Messages.format("MarshallerImpl.UnsupportedResult"));
    }

    private Document createDocument() throws ParserConfigurationException {
        if (this.domFactory == null) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            this.domFactory = dbf.newDocumentBuilder();
        }
        return this.domFactory.newDocument();
    }

    protected final <T> void write(Name rootTagName, JaxBeanInfo<T> bi, T obj, XmlOutput out, Runnable postInitAction) throws JAXBException {
        try {
            this.serializer.prepare(out, this.getSchemaLocation(), this.getNoNSSchemaLocation());
            if (postInitAction != null) {
                postInitAction.run();
            }
            this.serializer.setPrefixMapper(this.prefixMapper);
            out.startDocument(false);
            this.serializer.startElement(rootTagName, null);
            if (bi.jaxbType == Void.class || bi.jaxbType == Void.TYPE) {
                this.serializer.endNamespaceDecls();
                this.serializer.endAttributes();
            } else {
                if (obj == null) {
                    throw new IllegalArgumentException(Messages.format("MarshallerImpl.NotMarshallable"));
                }
                this.serializer.childAsXsiType(obj, "root", bi);
            }
            this.serializer.endElement();
            out.endDocument(false);
            this.serializer.reconcileID();
            out.flush();
        }
        catch (SAXException e) {
            throw new MarshalException((Throwable)e);
        }
        catch (IOException e) {
            throw new MarshalException((Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new MarshalException((Throwable)e);
        }
    }

    private void write(Object obj, XmlOutput out, boolean isFragment, Runnable postInitAction) throws JAXBException {
        if (obj == null) {
            throw new IllegalArgumentException(Messages.format("MarshallerImpl.NotMarshallable"));
        }
        try {
            this.serializer.prepare(out, this.getSchemaLocation(), this.getNoNSSchemaLocation());
            if (postInitAction != null) {
                postInitAction.run();
            }
            this.serializer.setPrefixMapper(this.prefixMapper);
            out.startDocument(isFragment);
            this.context.getBeanInfo(obj, true).serializeRoot(obj, this.serializer);
            out.endDocument(isFragment);
            this.serializer.reconcileID();
            out.flush();
        }
        catch (SAXException e) {
            throw new MarshalException((Throwable)e);
        }
        catch (IOException e) {
            throw new MarshalException((Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new MarshalException((Throwable)e);
        }
    }

    protected CharacterEscapeHandler createEscapeHandler(String encoding) {
        if (this.escapeHandler != null) {
            return this.escapeHandler;
        }
        if (encoding.startsWith("UTF")) {
            return MinimumEscapeHandler.theInstance;
        }
        try {
            return new NioEscapeHandler(this.getJavaEncoding(encoding));
        }
        catch (Throwable e) {
            return DumbEscapeHandler.theInstance;
        }
    }

    public XmlOutput createWriter(Writer w, String encoding) {
        XMLWriter xw;
        w = new BufferedWriter(w);
        CharacterEscapeHandler ceh = this.createEscapeHandler(encoding);
        if (this.isFormattedOutput()) {
            DataWriter d = new DataWriter(w, encoding, ceh);
            d.setIndentStep(this.indent);
            xw = d;
        } else {
            xw = new XMLWriter(w, encoding, ceh);
        }
        if (this.isFragment()) {
            xw.setXmlDecl(false);
        } else {
            xw.setXmlDecl(this.printXmlDeclaration);
        }
        xw.setHeader(this.header);
        return new SAXOutput(xw);
    }

    public XmlOutput createWriter(Writer w) {
        return this.createWriter(w, this.getEncoding());
    }

    public XmlOutput createWriter(OutputStream os) throws JAXBException {
        return this.createWriter(os, this.getEncoding());
    }

    public XmlOutput createWriter(OutputStream os, String encoding) throws JAXBException {
        if (!(os instanceof BufferedOutputStream)) {
            os = new BufferedOutputStream(os);
        }
        if (encoding.equals("UTF-8")) {
            Encoded[] table = this.context.getUTF8NameTable();
            if (this.isFormattedOutput()) {
                return new IndentingUTF8XmlOutput(os, this.indent, table);
            }
            return new UTF8XmlOutput(os, table);
        }
        try {
            return this.createWriter(new OutputStreamWriter(os, this.getJavaEncoding(encoding)), encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new MarshalException(Messages.format("MarshallerImpl.UnsupportedEncoding", encoding), (Throwable)e);
        }
    }

    public Object getProperty(String name) throws PropertyException {
        if (INDENT_STRING.equals(name)) {
            return this.indent;
        }
        if (ENCODING_HANDLER.equals(name)) {
            return this.escapeHandler;
        }
        if (PREFIX_MAPPER.equals(name)) {
            return this.prefixMapper;
        }
        if (XMLDECLARATION.equals(name)) {
            return this.printXmlDeclaration;
        }
        if (XML_HEADERS.equals(name)) {
            return this.header;
        }
        return super.getProperty(name);
    }

    public void setProperty(String name, Object value) throws PropertyException {
        if (INDENT_STRING.equals(name) && value instanceof String) {
            this.indent = (String)value;
            return;
        }
        if (ENCODING_HANDLER.equals(name)) {
            this.escapeHandler = (CharacterEscapeHandler)value;
            return;
        }
        if (PREFIX_MAPPER.equals(name)) {
            this.prefixMapper = (NamespacePrefixMapper)value;
            return;
        }
        if (XMLDECLARATION.equals(name)) {
            this.printXmlDeclaration = (Boolean)value;
            return;
        }
        if (XML_HEADERS.equals(name)) {
            this.header = (String)value;
            return;
        }
        super.setProperty(name, value);
    }
}

