/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime;

import com.sun.xml.bind.ObjectLifecycle;
import com.sun.xml.bind.WhiteSpaceProcessor;
import com.sun.xml.bind.api.AccessorException;
import com.sun.xml.bind.unmarshaller.InfosetScanner;
import com.sun.xml.bind.unmarshaller.Messages;
import com.sun.xml.bind.unmarshaller.Patcher;
import com.sun.xml.bind.util.AttributesImpl;
import com.sun.xml.bind.v2.AssociationMap;
import com.sun.xml.bind.v2.EventArg;
import com.sun.xml.bind.v2.runtime.JAXBContextImpl;
import com.sun.xml.bind.v2.runtime.Name;
import com.sun.xml.bind.v2.runtime.SAXUnmarshallerHandler;
import com.sun.xml.bind.v2.runtime.Scope;
import com.sun.xml.bind.v2.runtime.UnmarshallerImpl;
import com.sun.xml.bind.v2.runtime.UnmarshallingContext;
import com.sun.xml.bind.v2.runtime.UnmarshallingEventHandler;
import com.sun.xml.bind.v2.runtime.property.Unmarshaller;
import com.sun.xml.bind.v2.runtime.reflect.Accessor;
import com.sun.xml.bind.validator.Locator;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.bind.helpers.ValidationEventImpl;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SAXUnmarshallerHandlerImpl
implements SAXUnmarshallerHandler,
UnmarshallingContext {
    private boolean isUnmarshalInProgress = true;
    private final AssociationMap assoc;
    private final boolean isInplaceMode;
    private Object currentElement;
    private final InfosetScanner scanner;
    private final Locator locationConverter;
    public static boolean TRACE;
    private EventArgImpl eventArg = null;
    private Object result;
    private UnmarshallingEventHandler[] handlers = new UnmarshallingEventHandler[16];
    private Object[] targets = new Object[16];
    private boolean[] lifecycleControls = new boolean[16];
    private int handlerLen = 0;
    private Scope[] scopes = new Scope[16];
    private int scopeTop = 0;
    private Object[] states;
    private int stateTop;
    private StringBuilder buffer;
    private String[] nsBind;
    private int nsLen;
    private int[] idxStack;
    private AttributesImpl[] attStack;
    private int elementDepth;
    private int stackTop;
    private boolean[] collectText;
    private Patcher[] patchers;
    private int patchersLen;
    private Hashtable<String, Object> idmap;
    private org.xml.sax.Locator locator;
    private static final org.xml.sax.Locator DUMMY_LOCATOR;
    private final UnmarshallerImpl parent;
    private boolean aborted;

    public final EventArgImpl alloc(String uri, String local, String qname, Attributes atts) {
        EventArgImpl r = this.eventArg;
        if (r == null) {
            r = new EventArgImpl();
        } else {
            this.eventArg = r.next;
        }
        r.uri = uri;
        r.local = local;
        r.qname = qname;
        r.atts = atts;
        return r;
    }

    public final void free(EventArgImpl a) {
        a.next = this.eventArg;
        this.eventArg = a;
        a.atts = null;
    }

    public SAXUnmarshallerHandlerImpl(UnmarshallerImpl _parent, InfosetScanner scanner, Locator locationConverter, AssociationMap assoc, boolean isInplaceMode) {
        for (int i = 0; i < this.scopes.length; ++i) {
            this.scopes[i] = new Scope(this);
        }
        this.states = new Object[16];
        this.stateTop = 0;
        this.buffer = new StringBuilder();
        this.nsBind = new String[16];
        this.nsLen = 0;
        this.idxStack = new int[16];
        this.attStack = new AttributesImpl[16];
        this.collectText = new boolean[16];
        this.patchers = null;
        this.patchersLen = 0;
        this.idmap = null;
        this.locator = DUMMY_LOCATOR;
        this.aborted = false;
        this.parent = _parent;
        this.scanner = scanner;
        this.locationConverter = locationConverter;
        this.assoc = assoc;
        this.isInplaceMode = isInplaceMode;
        this.startPrefixMapping("", "");
    }

    @Override
    public JAXBContextImpl getJAXBContext() {
        return this.parent.context;
    }

    private final boolean shouldCollectText() {
        return this.collectText[this.stackTop];
    }

    public void startDocument() {
        this.result = null;
        this.handlerLen = 0;
        this.patchers = null;
        this.patchersLen = 0;
        this.aborted = false;
        this.isUnmarshalInProgress = true;
        this.stackTop = 0;
        this.scopeTop = 0;
        this.stateTop = 0;
        this.elementDepth = 1;
    }

    public void endDocument() throws SAXException {
        this.runPatchers();
        this.isUnmarshalInProgress = false;
        this.currentElement = null;
        assert (this.scopeTop == 0);
        assert (this.handlerLen == 0);
        assert (this.stateTop == 0);
    }

    public void startElement(String uri, String local, String qname, Attributes atts) throws SAXException {
        if (uri == null || uri.length() == 0) {
            uri = "";
        }
        if (local == null || local.length() == 0) {
            local = qname;
        }
        if (qname == null || qname.length() == 0) {
            qname = local;
        }
        this.processText(true);
        if (this.assoc != null) {
            this.currentElement = this.scanner.getCurrentElement();
        }
        if (this.result == null) {
            UnmarshallingContext context = TRACE ? this.createTraceContext(this) : this;
            if (this.parent.expectedType == null) {
                UnmarshallingEventHandler unmarshaller = this.parent.context.pushUnmarshaller(uri, local, context);
                if (unmarshaller == null) {
                    throw new SAXParseException(Messages.format("SAXUnmarshallerHandlerImpl.UnexpectedRootElement2", uri, local, this.computeExpectedRootElements()), this.getLocator());
                }
                this.result = this.getTarget();
            } else {
                QName qn = new QName(uri, local);
                this.result = new JAXBElement(qn, this.parent.expectedType.jaxbType, null, null);
                Unmarshaller.SpawnChildSetHandler handler = new Unmarshaller.SpawnChildSetHandler(this.parent.expectedType, new Unmarshaller.LeaveElementHandler(Unmarshaller.ERROR, Unmarshaller.REVERT_TO_PARENT), false, Accessor.JAXB_ELEMENT_VALUE);
                this.pushAttributes(atts, true);
                context.pushContentHandler(handler, this.result, false);
                return;
            }
        }
        EventArgImpl ea = this.alloc(uri, local, qname, atts);
        this.getCurrentHandler().enterElement(this, ea);
        this.free(ea);
    }

    private UnmarshallingContext createTraceContext(UnmarshallingContext core) {
        try {
            Class<?> clz = this.getClass().getClassLoader().loadClass("com.sun.xml.bind.v2.runtime.TraceUnmarshallingContext");
            return (UnmarshallingContext)clz.getConstructor(UnmarshallingContext.class, PrintWriter.class).newInstance(core, new PrintWriter(System.out));
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new Error(e);
        }
        catch (InstantiationException e) {
            throw new InstantiationError(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    public final void endElement(String uri, String local, String qname) throws SAXException {
        if (uri == null || uri.length() == 0) {
            uri = "";
        }
        if (local == null || local.length() == 0) {
            local = qname;
        }
        if (qname == null || qname.length() == 0) {
            qname = local;
        }
        this.processText(false);
        EventArgImpl ea = this.alloc(uri, local, qname, null);
        this.getCurrentHandler().leaveElement(this, ea);
        this.free(ea);
    }

    public Object getResult() throws UnmarshalException {
        if (this.isUnmarshalInProgress) {
            throw new IllegalStateException();
        }
        if (!this.aborted) {
            return this.result;
        }
        throw new UnmarshalException((String)null);
    }

    @Override
    public void pushContentHandler(UnmarshallingEventHandler handler, Object target, boolean lifecycleControl) throws SAXException {
        if (lifecycleControl) {
            Object p = this.handlerLen == 0 ? null : this.targets[this.handlerLen - 1];
            ((ObjectLifecycle)target).beforeUnmarshalling((javax.xml.bind.Unmarshaller)this.parent, p);
        }
        if (this.handlerLen == this.handlers.length) {
            UnmarshallingEventHandler[] h = new UnmarshallingEventHandler[this.handlerLen * 2];
            Object[] t = new Object[this.handlerLen * 2];
            boolean[] l = new boolean[this.handlerLen * 2];
            System.arraycopy(this.handlers, 0, h, 0, this.handlerLen);
            System.arraycopy(this.targets, 0, t, 0, this.handlerLen);
            System.arraycopy(this.lifecycleControls, 0, l, 0, this.handlerLen);
            this.handlers = h;
            this.targets = t;
            this.lifecycleControls = l;
        }
        this.handlers[this.handlerLen] = handler;
        this.targets[this.handlerLen] = target;
        this.lifecycleControls[this.handlerLen] = lifecycleControl;
        ++this.handlerLen;
        handler.activate(this);
    }

    @Override
    public void popContentHandler() throws SAXException {
        --this.handlerLen;
        Object child = this.targets[this.handlerLen];
        UnmarshallingEventHandler old = this.handlers[this.handlerLen];
        this.handlers[this.handlerLen] = null;
        this.targets[this.handlerLen] = null;
        old.deactivated(this);
        if (this.lifecycleControls[this.handlerLen]) {
            Object p = this.handlerLen == 0 ? null : this.targets[this.handlerLen - 1];
            ((ObjectLifecycle)child).afterUnmarshalling((javax.xml.bind.Unmarshaller)this.parent, p);
        }
        if (this.handlerLen != 0) {
            this.getCurrentHandler().leaveChild(this, child);
        }
    }

    @Override
    public UnmarshallingEventHandler getCurrentHandler() {
        return this.handlers[this.handlerLen - 1];
    }

    @Override
    public void setCurrentHandler(UnmarshallingEventHandler handler) throws SAXException {
        UnmarshallingEventHandler old = this.handlers[this.handlerLen - 1];
        this.handlers[this.handlerLen - 1] = handler;
        if (old != handler) {
            old.deactivated(this);
            handler.activate(this);
        }
    }

    @Override
    public <T> T getTarget() {
        return (T)this.targets[this.handlerLen - 1];
    }

    @Override
    public void setTarget(Object t) {
        assert (this.targets[this.handlerLen - 1] == null);
        assert (t != null);
        this.targets[this.handlerLen - 1] = t;
    }

    @Override
    public void startScope(int frameSize) {
        this.scopeTop += frameSize;
        if (this.scopeTop >= this.scopes.length) {
            Scope[] s = new Scope[Math.max(this.scopeTop + 1, this.scopes.length * 2)];
            System.arraycopy(this.scopes, 0, s, 0, this.scopes.length);
            for (int i = this.scopes.length; i < s.length; ++i) {
                s[i] = new Scope(this);
            }
            this.scopes = s;
        }
    }

    @Override
    public void endScope(int frameSize) throws SAXException {
        try {
            while (frameSize > 0) {
                this.scopes[this.scopeTop--].finish();
                --frameSize;
            }
        }
        catch (AccessorException e) {
            this.handleError(e);
        }
    }

    @Override
    public Scope getScope(int offset) {
        return this.scopes[this.scopeTop - offset];
    }

    @Override
    public void startState() {
        ++this.stateTop;
    }

    @Override
    public void setState(Object o) {
        this.states[this.stateTop] = o;
    }

    @Override
    public <T> T getState() {
        return (T)this.states[this.stateTop];
    }

    @Override
    public void endState() {
        this.states[this.stateTop] = null;
        --this.stateTop;
    }

    protected void consumeText(CharSequence str, boolean ignorable) throws SAXException {
        if (ignorable && WhiteSpaceProcessor.isWhiteSpace(str)) {
            return;
        }
        this.getCurrentHandler().text(this, str);
    }

    private void processText(boolean ignorable) throws SAXException {
        if (this.shouldCollectText()) {
            this.consumeText(this.buffer, ignorable);
        }
        if (this.buffer.length() < 1024) {
            this.buffer.setLength(0);
        } else {
            this.buffer = new StringBuilder();
        }
    }

    public final void characters(char[] buf, int start, int len) {
        if (this.shouldCollectText()) {
            this.buffer.append(buf, start, len);
        }
    }

    public final void ignorableWhitespace(char[] buf, int start, int len) {
        this.characters(buf, start, len);
    }

    public void startPrefixMapping(String prefix, String uri) {
        if (this.nsBind.length == this.nsLen) {
            String[] n = new String[this.nsLen * 2];
            System.arraycopy(this.nsBind, 0, n, 0, this.nsLen);
            this.nsBind = n;
        }
        this.nsBind[this.nsLen++] = prefix;
        this.nsBind[this.nsLen++] = uri;
    }

    public void endPrefixMapping(String prefix) {
        this.nsLen -= 2;
    }

    @Override
    public String resolveNamespacePrefix(String prefix) {
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        for (int i = this.idxStack[this.stackTop] - 2; i >= 0; i -= 2) {
            if (!prefix.equals(this.nsBind[i])) continue;
            return this.nsBind[i + 1];
        }
        return null;
    }

    @Override
    public String[] getNewlyDeclaredPrefixes() {
        return this.getPrefixList(this.idxStack[this.stackTop - 1]);
    }

    @Override
    public String[] getAllDeclaredPrefixes() {
        return this.getPrefixList(2);
    }

    private String[] getPrefixList(int startIndex) {
        int size = (this.idxStack[this.stackTop] - startIndex) / 2;
        String[] r = new String[size];
        for (int i = 0; i < r.length; ++i) {
            r[i] = this.nsBind[startIndex + i * 2];
        }
        return r;
    }

    @Override
    public Iterator<String> getPrefixes(String uri) {
        return Collections.unmodifiableList(this.getAllPrefixesInList(uri)).iterator();
    }

    private List<String> getAllPrefixesInList(String uri) {
        ArrayList<String> a = new ArrayList<String>();
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
            a.add("xml");
            return a;
        }
        if (uri.equals("http://www.w3.org/2000/xmlns/")) {
            a.add("xmlns");
            return a;
        }
        for (int i = this.nsLen - 2; i >= 0; i -= 2) {
            if (!uri.equals(this.nsBind[i + 1]) || !this.getNamespaceURI(this.nsBind[i]).equals(this.nsBind[i + 1])) continue;
            a.add(this.nsBind[i]);
        }
        return a;
    }

    @Override
    public String getPrefix(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (uri.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        for (int i = this.idxStack[this.stackTop] - 2; i >= 0; i -= 2) {
            if (!uri.equals(this.nsBind[i + 1]) || !this.getNamespaceURI(this.nsBind[i]).equals(this.nsBind[i + 1])) continue;
            return this.nsBind[i];
        }
        return null;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        if (prefix.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        return this.resolveNamespacePrefix(prefix);
    }

    @Override
    public void pushAttributes(Attributes atts, boolean collectTextFlag) {
        if (this.attStack.length == this.elementDepth) {
            AttributesImpl[] buf1 = new AttributesImpl[this.attStack.length * 2];
            System.arraycopy(this.attStack, 0, buf1, 0, this.attStack.length);
            this.attStack = buf1;
            int[] buf2 = new int[this.idxStack.length * 2];
            System.arraycopy(this.idxStack, 0, buf2, 0, this.idxStack.length);
            this.idxStack = buf2;
            boolean[] buf3 = new boolean[this.collectText.length * 2];
            System.arraycopy(this.collectText, 0, buf3, 0, this.collectText.length);
            this.collectText = buf3;
        }
        ++this.elementDepth;
        ++this.stackTop;
        AttributesImpl a = this.attStack[this.stackTop];
        if (a == null) {
            this.attStack[this.stackTop] = a = new AttributesImpl();
        } else {
            a.clear();
        }
        for (int i = 0; i < atts.getLength(); ++i) {
            String v;
            String auri = atts.getURI(i);
            String alocal = atts.getLocalName(i);
            String avalue = atts.getValue(i);
            if (auri == "http://www.w3.org/2001/XMLSchema-instance" && alocal == "nil" && ((v = avalue.trim()).equals("false") || v.equals("0"))) continue;
            a.addAttribute(auri, alocal, atts.getQName(i), atts.getType(i), avalue);
        }
        this.idxStack[this.stackTop] = this.nsLen;
        this.collectText[this.stackTop] = collectTextFlag;
    }

    @Override
    public void disableTextCollection() {
        this.collectText[this.stackTop] = false;
    }

    @Override
    public void popAttributes() {
        --this.stackTop;
        --this.elementDepth;
    }

    @Override
    public Attributes getUnconsumedAttributes() {
        return this.attStack[this.stackTop];
    }

    @Override
    public int getAttribute(String uri, String local) {
        if (this.attStack[this.stackTop] != null) {
            return this.attStack[this.stackTop].getIndexFast(uri, local);
        }
        return -1;
    }

    @Override
    public int getAttribute(Name name) {
        return this.getAttribute(name.nsUri, name.localName);
    }

    @Override
    public String eatAttribute(int idx) {
        AttributesImpl a = this.attStack[this.stackTop];
        String value = a.getValue(idx);
        a.removeAttribute(idx);
        return value;
    }

    @Override
    public void addPatcher(Patcher job) {
        if (this.patchers == null) {
            this.patchers = new Patcher[32];
        }
        if (this.patchers.length == this.patchersLen) {
            Patcher[] buf = new Patcher[this.patchersLen * 2];
            System.arraycopy(this.patchers, 0, buf, 0, this.patchersLen);
            this.patchers = buf;
        }
        this.patchers[this.patchersLen++] = job;
    }

    private void runPatchers() throws SAXException {
        if (this.patchers != null) {
            for (int i = 0; i < this.patchersLen; ++i) {
                this.patchers[i].run();
            }
        }
    }

    @Override
    public String addToIdTable(String id) {
        if (this.idmap == null) {
            this.idmap = new Hashtable();
        }
        this.idmap.put(id, this.getTarget());
        return id;
    }

    @Override
    public Object getObjectFromId(String id) {
        if (this.idmap == null) {
            return null;
        }
        return this.idmap.get(id);
    }

    public void skippedEntity(String name) {
    }

    public void processingInstruction(String target, String data) {
    }

    public void setDocumentLocator(org.xml.sax.Locator loc) {
        this.locator = loc;
    }

    @Override
    public org.xml.sax.Locator getLocator() {
        return this.locator;
    }

    @Override
    public void handleEvent(ValidationEvent event, boolean canRecover) throws SAXException {
        ValidationEventHandler eventHandler;
        try {
            eventHandler = this.parent.getEventHandler();
        }
        catch (JAXBException e) {
            throw new AssertionError((Object)e);
        }
        boolean recover = eventHandler.handleEvent(event);
        if (!recover) {
            this.aborted = true;
        }
        if (!canRecover || !recover) {
            throw new SAXParseException(event.getMessage(), this.locator, (Exception)new UnmarshalException(event.getMessage(), event.getLinkedException()));
        }
    }

    @Override
    public ValidationEventLocator createEventLocator() {
        return this.locationConverter.getLocation(this.locator);
    }

    public boolean handleEvent(ValidationEvent event) {
        try {
            boolean recover = this.parent.getEventHandler().handleEvent(event);
            if (!recover) {
                this.aborted = true;
            }
            return recover;
        }
        catch (JAXBException e) {
            return false;
        }
        catch (RuntimeException re) {
            return false;
        }
    }

    @Override
    public void handleError(Exception e) throws SAXException {
        this.handleEvent((ValidationEvent)new ValidationEventImpl(1, e.getMessage(), this.createEventLocator(), (Throwable)e), true);
    }

    @Override
    public String getBaseUri() {
        return null;
    }

    @Override
    public boolean isUnparsedEntity(String s) {
        return true;
    }

    @Override
    public boolean isNotation(String s) {
        return true;
    }

    private String computeExpectedRootElements() {
        String r = "";
        for (QName n : this.parent.context.getValidRootNames()) {
            if (r.length() != 0) {
                r = r + ',';
            }
            r = r + "<{" + n.getNamespaceURI() + '}' + n.getLocalPart() + '>';
        }
        return r;
    }

    @Override
    public void recordInnerPeer(Object innerPeer) {
        if (this.assoc != null) {
            this.assoc.addInner(this.currentElement, innerPeer);
        }
    }

    @Override
    public Object getInnerPeer() {
        if (this.assoc != null && this.isInplaceMode) {
            return this.assoc.getInnerPeer(this.currentElement);
        }
        return null;
    }

    @Override
    public void recordOuterPeer(Object outerPeer) {
        if (this.assoc != null) {
            this.assoc.addOuter(this.currentElement, outerPeer);
        }
    }

    @Override
    public Object getOuterPeer() {
        if (this.assoc != null && this.isInplaceMode) {
            return this.assoc.getOuterPeer(this.currentElement);
        }
        return null;
    }

    static {
        try {
            TRACE = System.getProperty("com.sun.xml.bind.trace") != null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        DUMMY_LOCATOR = new LocatorImpl();
    }

    private static class EventArgImpl
    extends EventArg {
        EventArgImpl next;

        private EventArgImpl() {
        }
    }
}

