/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime;

import com.sun.xml.bind.DatatypeConverterImpl;
import com.sun.xml.bind.unmarshaller.DOMScanner;
import com.sun.xml.bind.unmarshaller.InfosetScanner;
import com.sun.xml.bind.unmarshaller.InterningXMLReader;
import com.sun.xml.bind.unmarshaller.Messages;
import com.sun.xml.bind.v2.AssociationMap;
import com.sun.xml.bind.v2.runtime.ErrorHandlerAdaptor;
import com.sun.xml.bind.v2.runtime.InterningUnmarshallerHandler;
import com.sun.xml.bind.v2.runtime.JAXBContextImpl;
import com.sun.xml.bind.v2.runtime.JaxBeanInfo;
import com.sun.xml.bind.v2.runtime.SAXUnmarshallerHandler;
import com.sun.xml.bind.v2.runtime.SAXUnmarshallerHandlerImpl;
import com.sun.xml.bind.v2.runtime.ValidatingUnmarshaller;
import com.sun.xml.bind.validator.DOMLocator;
import com.sun.xml.bind.validator.Locator;
import com.sun.xml.bind.validator.SAXLocator;
import java.io.IOException;
import javanet.staxutils.XMLEventReaderToContentHandler;
import javanet.staxutils.XMLStreamReaderToContentHandler;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.DatatypeConverterInterface;
import javax.xml.bind.JAXBException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.bind.helpers.AbstractUnmarshallerImpl;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.XMLEvent;
import javax.xml.validation.Schema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class UnmarshallerImpl
extends AbstractUnmarshallerImpl {
    protected final JAXBContextImpl context;
    private final AssociationMap assoc;
    private Schema schema;
    JaxBeanInfo expectedType;
    private static final DefaultHandler dummyHandler = new DefaultHandler();
    public static final String EXPECTED_TYPE = "com.sun.xml.bind.expectedType";

    public UnmarshallerImpl(JAXBContextImpl context, AssociationMap _assoc) {
        this.assoc = _assoc;
        this.context = context;
        DatatypeConverter.setDatatypeConverter((DatatypeConverterInterface)DatatypeConverterImpl.theInstance);
    }

    public UnmarshallerHandler getUnmarshallerHandler() {
        return new InterningUnmarshallerHandler(this.createUnmarshallerHandler(SAXLocator.theInstance, null, false));
    }

    final SAXUnmarshallerHandler createUnmarshallerHandler(Locator locator, InfosetScanner scanner, boolean inplace) {
        SAXUnmarshallerHandler unmarshaller = new SAXUnmarshallerHandlerImpl(this, scanner, locator, this.assoc, inplace);
        if (this.schema != null) {
            unmarshaller = ValidatingUnmarshaller.create(this.schema, unmarshaller, locator);
        }
        return unmarshaller;
    }

    protected Object unmarshal(XMLReader reader, InputSource source) throws JAXBException {
        SAXLocator locator = SAXLocator.theInstance;
        SAXUnmarshallerHandler handler = this.createUnmarshallerHandler(locator, null, false);
        reader = InterningXMLReader.adapt(reader);
        reader.setContentHandler((ContentHandler)((Object)handler));
        reader.setErrorHandler(new ErrorHandlerAdaptor(handler, locator));
        try {
            reader.parse(source);
        }
        catch (IOException e) {
            throw new JAXBException((Throwable)e);
        }
        catch (SAXException e) {
            throw this.createUnmarshalException(e);
        }
        Object result = handler.getResult();
        reader.setContentHandler(dummyHandler);
        reader.setErrorHandler(dummyHandler);
        return result;
    }

    public final Object unmarshal(Node node) throws JAXBException {
        try {
            DOMScanner scanner = new DOMScanner();
            InterningUnmarshallerHandler handler = new InterningUnmarshallerHandler(this.createUnmarshallerHandler(new DOMLocator(scanner), null, false));
            scanner.setContentHandler(handler);
            if (node instanceof Element) {
                scanner.scan((Element)node);
            } else if (node instanceof Document) {
                scanner.scan((Document)node);
            } else {
                throw new IllegalArgumentException();
            }
            return handler.getResult();
        }
        catch (SAXException e) {
            throw this.createUnmarshalException(e);
        }
    }

    public Object unmarshal(XMLStreamReader reader) throws JAXBException {
        if (reader == null) {
            throw new IllegalArgumentException(Messages.format("Unmarshaller.NullReader"));
        }
        int eventType = reader.getEventType();
        if (eventType != 1 && eventType != 7) {
            throw new IllegalStateException(Messages.format("Unmarshaller.IllegalReaderState", eventType));
        }
        UnmarshallerHandler h = this.getUnmarshallerHandler();
        try {
            new XMLStreamReaderToContentHandler(reader, (ContentHandler)h).bridge();
        }
        catch (XMLStreamException e) {
            throw this.handleStreamException(e);
        }
        return h.getResult();
    }

    public Object unmarshal(XMLEventReader reader) throws JAXBException {
        if (reader == null) {
            throw new IllegalArgumentException(Messages.format("Unmarshaller.NullReader"));
        }
        try {
            XMLEvent event = reader.peek();
            if (!event.isStartElement() && !event.isStartDocument()) {
                throw new IllegalStateException(Messages.format("Unmarshaller.IllegalReaderState", event.getEventType()));
            }
            UnmarshallerHandler h = this.getUnmarshallerHandler();
            new XMLEventReaderToContentHandler(reader, (ContentHandler)h).bridge();
            return h.getResult();
        }
        catch (XMLStreamException e) {
            throw this.handleStreamException(e);
        }
    }

    private JAXBException handleStreamException(XMLStreamException e) {
        Throwable ne = e.getNestedException();
        if (ne instanceof JAXBException) {
            return (JAXBException)ne;
        }
        if (ne instanceof SAXException) {
            return new JAXBException(ne);
        }
        return new JAXBException((Throwable)e);
    }

    public void setExpectedType(JaxBeanInfo bi) {
        this.expectedType = bi;
    }

    public void setProperty(String name, Object value) throws PropertyException {
        if (name.equals(EXPECTED_TYPE)) {
            if (value == null) {
                this.expectedType = null;
                return;
            }
            if (!(value instanceof Class)) {
                throw new IllegalArgumentException();
            }
            try {
                this.expectedType = this.context.getBeanInfo((Class)value, true);
            }
            catch (JAXBException e) {
                throw new PropertyException((Throwable)e);
            }
            return;
        }
        super.setProperty(name, value);
    }

    public Object getProperty(String name) throws PropertyException {
        if (name.equals(EXPECTED_TYPE)) {
            if (this.expectedType == null) {
                return null;
            }
            return this.expectedType.jaxbType;
        }
        return super.getProperty(name);
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public boolean isValidating() throws JAXBException {
        throw new UnsupportedOperationException();
    }

    public void setValidating(boolean validating) throws JAXBException {
        throw new UnsupportedOperationException();
    }
}

