/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.output;

import com.sun.xml.bind.v2.runtime.output.UTF8XmlOutput;
import java.io.IOException;
import java.io.OutputStream;

public final class Encoded {
    public byte[] buf;
    public int len;
    private static final byte[] AMP_ENTITY = UTF8XmlOutput.toBytes("&amp;");
    private static final byte[] AMP_GT = UTF8XmlOutput.toBytes("&gt;");
    private static final byte[] AMP_LT = UTF8XmlOutput.toBytes("&lt;");
    private static final byte[] AMP_QUOT = UTF8XmlOutput.toBytes("&quot;");

    public Encoded() {
    }

    public Encoded(String text) {
        this.set(text);
    }

    private void ensureSize(int size) {
        if (this.buf == null || this.buf.length < size) {
            this.buf = new byte[size];
        }
    }

    public final void set(String text) {
        int length = text.length();
        this.ensureSize(length * 3 + 1);
        int ptr = 0;
        for (int i = 0; i < length; ++i) {
            char chr = text.charAt(i);
            if (chr > '\u007f') {
                if (chr > '\u07ff') {
                    this.buf[ptr++] = (byte)(224 + (chr >> 12));
                    this.buf[ptr++] = (byte)(128 + (chr >> 6 & 0x3F));
                } else {
                    this.buf[ptr++] = (byte)(192 + (chr >> 6));
                }
                this.buf[ptr++] = (byte)(128 + (chr & 0x3F));
                continue;
            }
            this.buf[ptr++] = (byte)chr;
        }
        this.len = ptr;
    }

    public final void setEscape(char[] text, int length) {
        this.ensureSize(length * 6 + 1);
        int ptr = 0;
        block6: for (int i = 0; i < length; ++i) {
            char chr = text[i];
            if (chr > '\u007f') {
                if (chr > '\u07ff') {
                    this.buf[ptr++] = (byte)(224 + (chr >> 12));
                    this.buf[ptr++] = (byte)(128 + (chr >> 6 & 0x3F));
                } else {
                    this.buf[ptr++] = (byte)(192 + (chr >> 6));
                }
                this.buf[ptr++] = (byte)(128 + (chr & 0x3F));
                continue;
            }
            switch (chr) {
                case '&': {
                    ptr = this.writeEntity(AMP_ENTITY, ptr);
                    continue block6;
                }
                case '<': {
                    ptr = this.writeEntity(AMP_LT, ptr);
                    continue block6;
                }
                case '>': {
                    ptr = this.writeEntity(AMP_GT, ptr);
                    continue block6;
                }
                case '\"': {
                    ptr = this.writeEntity(AMP_QUOT, ptr);
                    continue block6;
                }
                default: {
                    this.buf[ptr++] = (byte)chr;
                }
            }
        }
        this.len = ptr;
    }

    public final void setEscape(String text) {
        int length = text.length();
        this.ensureSize(length * 6 + 1);
        int ptr = 0;
        block6: for (int i = 0; i < length; ++i) {
            char chr = text.charAt(i);
            if (chr > '\u007f') {
                if (chr > '\u07ff') {
                    this.buf[ptr++] = (byte)(224 + (chr >> 12));
                    this.buf[ptr++] = (byte)(128 + (chr >> 6 & 0x3F));
                } else {
                    this.buf[ptr++] = (byte)(192 + (chr >> 6));
                }
                this.buf[ptr++] = (byte)(128 + (chr & 0x3F));
                continue;
            }
            switch (chr) {
                case '&': {
                    ptr = this.writeEntity(AMP_ENTITY, ptr);
                    continue block6;
                }
                case '<': {
                    ptr = this.writeEntity(AMP_LT, ptr);
                    continue block6;
                }
                case '>': {
                    ptr = this.writeEntity(AMP_GT, ptr);
                    continue block6;
                }
                case '\"': {
                    ptr = this.writeEntity(AMP_QUOT, ptr);
                    continue block6;
                }
                default: {
                    this.buf[ptr++] = (byte)chr;
                }
            }
        }
        this.len = ptr;
    }

    private int writeEntity(byte[] entity, int ptr) {
        System.arraycopy(entity, 0, this.buf, ptr, entity.length);
        return ptr + entity.length;
    }

    public final void write(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.len);
    }

    public void append(char b) {
        this.buf[this.len++] = (byte)b;
    }

    public void compact() {
        byte[] b = new byte[this.len];
        System.arraycopy(this.buf, 0, b, 0, this.len);
        this.buf = b;
    }
}

