/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.property;

import com.sun.xml.bind.api.AccessorException;
import com.sun.xml.bind.v2.QNameMap;
import com.sun.xml.bind.v2.runtime.UnmarshallingContext;
import com.sun.xml.bind.v2.runtime.property.AttributeProperty;
import com.sun.xml.bind.v2.runtime.property.Unmarshaller;
import com.sun.xml.bind.v2.runtime.reflect.Accessor;
import com.sun.xml.bind.v2.runtime.reflect.TransducedAccessor;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeDispatcher
extends Unmarshaller.ForkHandler {
    private final QNameMap<TransducedAccessor> attUnmarshallers = new QNameMap();
    private final Unmarshaller.AttributeHandler catchAll;
    private static final Unmarshaller.AttributeHandler DUMMY_CATCH_ALL = new Unmarshaller.AttributeHandler(null, null){

        public void processValue(UnmarshallingContext context, String nsUri, String local, String qname, String value) {
        }

        protected boolean checkAttribute(UnmarshallingContext context) {
            return false;
        }
    };

    public AttributeDispatcher(List<AttributeProperty> properties, Accessor<?, Map<QName, Object>> wildcard, Unmarshaller.Handler next, Unmarshaller.Handler fallthrough) {
        super(fallthrough, next);
        this.catchAll = wildcard != null ? new Unmarshaller.AttributeWildcardHandler(wildcard, next) : DUMMY_CATCH_ALL;
        for (AttributeProperty p : properties) {
            this.attUnmarshallers.put(p.attName.toQName(), p.xacc);
        }
    }

    @Override
    public void activate(UnmarshallingContext context) throws SAXException {
        Attributes atts = context.getUnconsumedAttributes();
        for (int i = 0; i < atts.getLength(); ++i) {
            String auri = atts.getURI(i);
            String alocal = atts.getLocalName(i);
            String avalue = atts.getValue(auri, alocal);
            TransducedAccessor xacc = this.attUnmarshallers.get(auri, alocal);
            try {
                if (xacc != null) {
                    xacc.parse(context.getTarget(), avalue, context);
                    continue;
                }
                String aqname = atts.getQName(i);
                this.catchAll.processValue(context, auri, alocal, aqname, avalue);
                continue;
            }
            catch (AccessorException e) {
                AttributeDispatcher.handleGenericException(context, e, true);
            }
        }
    }
}

