/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.property;

import com.sun.xml.bind.api.AccessorException;
import com.sun.xml.bind.v2.QNameMap;
import com.sun.xml.bind.v2.model.core.PropertyKind;
import com.sun.xml.bind.v2.model.core.TypeRef;
import com.sun.xml.bind.v2.model.runtime.RuntimeElementPropertyInfo;
import com.sun.xml.bind.v2.model.runtime.RuntimeTypeInfo;
import com.sun.xml.bind.v2.runtime.JAXBContextImpl;
import com.sun.xml.bind.v2.runtime.JaxBeanInfo;
import com.sun.xml.bind.v2.runtime.Name;
import com.sun.xml.bind.v2.runtime.XMLSerializer;
import com.sun.xml.bind.v2.runtime.property.PropertyImpl;
import com.sun.xml.bind.v2.runtime.property.TagAndType;
import com.sun.xml.bind.v2.runtime.property.Unmarshaller;
import com.sun.xml.bind.v2.runtime.property.UnmarshallerChain;
import com.sun.xml.bind.v2.runtime.reflect.Accessor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SingleElementNodeProperty<BeanT, ValueT>
extends PropertyImpl<BeanT> {
    private final Accessor<BeanT, ValueT> acc;
    private final boolean nillable;
    private final QNameMap<JaxBeanInfo> expectedElements = new QNameMap();
    private final Map<Class, TagAndType> typeNames = new HashMap<Class, TagAndType>();
    private final Name nullTagName;

    public SingleElementNodeProperty(JAXBContextImpl grammar, RuntimeElementPropertyInfo prop) {
        super(grammar, prop);
        this.acc = prop.getAccessor().optimize();
        QName nt = null;
        boolean nil = false;
        for (TypeRef e : prop.getTypes()) {
            JaxBeanInfo beanInfo = grammar.getOrCreate((RuntimeTypeInfo)((Object)e.getType()));
            this.expectedElements.put(e.getTagName(), beanInfo);
            if (nt == null) {
                nt = e.getTagName();
            }
            this.typeNames.put(beanInfo.jaxbType, new TagAndType(grammar.nameBuilder.createElementName(e.getTagName()), beanInfo));
            nil |= e.isNillable();
        }
        this.nullTagName = grammar.nameBuilder.createElementName(nt);
        this.nillable = nil;
    }

    @Override
    public void reset(BeanT bean) throws AccessorException {
        this.acc.set(bean, null);
    }

    @Override
    public String getIdValue(BeanT beanT) {
        assert (!this.isId());
        return null;
    }

    @Override
    public void serializeBody(BeanT o, XMLSerializer w) throws SAXException, AccessorException, IOException, XMLStreamException {
        Object v = this.acc.get(o);
        if (v != null) {
            Class<?> vtype = v.getClass();
            TagAndType tt = this.typeNames.get(vtype);
            if (tt == null) {
                for (Map.Entry<Class, TagAndType> e : this.typeNames.entrySet()) {
                    if (!e.getKey().isAssignableFrom(vtype)) continue;
                    tt = e.getValue();
                    break;
                }
            }
            if (tt == null) {
                throw new UnsupportedOperationException();
            }
            w.startElement(tt.tagName, null);
            w.childAsXsiType(v, this.fieldName, tt.beanInfo);
            w.endElement();
        } else if (this.nillable) {
            w.startElement(this.nullTagName, null);
            w.writeXsiNilTrue();
            w.endElement();
        }
    }

    @Override
    public Unmarshaller.Handler createUnmarshallerHandler(JAXBContextImpl grammar, Unmarshaller.Handler tail) {
        Unmarshaller.Handler head = tail = new Unmarshaller.LeaveElementHandler(Unmarshaller.ERROR, tail);
        for (QNameMap.Entry<JaxBeanInfo> e : this.expectedElements.entrySet()) {
            Unmarshaller.EpsilonHandler h = new Unmarshaller.SpawnChildSetHandler(e.getValue(), tail, false, this.acc);
            if (this.nillable) {
                h = new Unmarshaller.XsiNilHandler(h, tail, this.acc);
            }
            head = new Unmarshaller.EnterElementHandler(grammar.nameBuilder.createElementName(e.nsUri, e.localName), false, head, h);
        }
        return head;
    }

    @Override
    public void buildChildElementUnmarshallers(UnmarshallerChain chain, QNameMap<Unmarshaller.Handler> handlers) {
        Unmarshaller.LeaveElementHandler tail = new Unmarshaller.LeaveElementHandler(Unmarshaller.ERROR, chain.tail);
        for (QNameMap.Entry<JaxBeanInfo> e : this.expectedElements.entrySet()) {
            Unmarshaller.EpsilonHandler h = new Unmarshaller.SpawnChildSetHandler(e.getValue(), tail, false, this.acc);
            if (this.nillable) {
                h = new Unmarshaller.XsiNilHandler(h, tail, this.acc);
            }
            handlers.put(e.nsUri, e.localName, new Unmarshaller.EnterElementHandler(chain.context.nameBuilder.createElementName(e.nsUri, e.localName), false, Unmarshaller.ERROR, h));
        }
    }

    @Override
    public PropertyKind getKind() {
        return PropertyKind.ELEMENT;
    }

    @Override
    public Accessor getElementPropertyAccessor(String nsUri, String localName) {
        if (this.expectedElements.containsKey(nsUri, localName)) {
            return this.acc;
        }
        return null;
    }
}

