/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.property;

import com.sun.xml.bind.annotation.DomHandler;
import com.sun.xml.bind.api.AccessorException;
import com.sun.xml.bind.v2.ClassFactory;
import com.sun.xml.bind.v2.EventArg;
import com.sun.xml.bind.v2.QNameMap;
import com.sun.xml.bind.v2.model.core.PropertyKind;
import com.sun.xml.bind.v2.model.core.WildcardMode;
import com.sun.xml.bind.v2.model.runtime.RuntimeElement;
import com.sun.xml.bind.v2.model.runtime.RuntimeReferencePropertyInfo;
import com.sun.xml.bind.v2.runtime.JAXBContextImpl;
import com.sun.xml.bind.v2.runtime.JaxBeanInfo;
import com.sun.xml.bind.v2.runtime.UnmarshallingContext;
import com.sun.xml.bind.v2.runtime.WildcardUnmarshaller;
import com.sun.xml.bind.v2.runtime.XMLSerializer;
import com.sun.xml.bind.v2.runtime.property.PropertyImpl;
import com.sun.xml.bind.v2.runtime.property.Unmarshaller;
import com.sun.xml.bind.v2.runtime.property.UnmarshallerChain;
import com.sun.xml.bind.v2.runtime.reflect.Accessor;
import java.io.IOException;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SingleReferenceNodeProperty<BeanT, ValueT>
extends PropertyImpl<BeanT> {
    private final Accessor<BeanT, ValueT> acc;
    private final QNameMap<JaxBeanInfo> expectedElements = new QNameMap();
    private final DomHandler domHandler;
    private final WildcardMode wcMode;

    public SingleReferenceNodeProperty(JAXBContextImpl p, RuntimeReferencePropertyInfo prop) {
        super(p, prop);
        this.acc = prop.getAccessor().optimize();
        for (RuntimeElement runtimeElement : prop.getElements()) {
            this.expectedElements.put(runtimeElement.getElementName(), p.getOrCreate(runtimeElement));
        }
        if (prop.getWildcard() != null) {
            this.domHandler = (DomHandler)ClassFactory.create((Class)prop.getDOMHandler());
            this.wcMode = prop.getWildcard();
        } else {
            this.domHandler = null;
            this.wcMode = null;
        }
    }

    @Override
    public void reset(BeanT bean) throws AccessorException {
        this.acc.set(bean, null);
    }

    @Override
    public String getIdValue(BeanT beanT) {
        assert (!this.isId());
        return null;
    }

    @Override
    public void serializeBody(BeanT o, XMLSerializer w) throws SAXException, AccessorException, IOException, XMLStreamException {
        Object v = this.acc.get(o);
        if (v != null) {
            try {
                JaxBeanInfo bi = w.grammar.getBeanInfo(v, this.domHandler == null);
                if (bi != null) {
                    bi.serializeRoot(v, w);
                } else {
                    w.writeDom(v, this.domHandler, o, this.fieldName);
                }
            }
            catch (JAXBException e) {
                w.reportError(this.fieldName, e);
            }
        }
    }

    @Override
    public Unmarshaller.Handler createUnmarshallerHandler(JAXBContextImpl grammar, Unmarshaller.Handler tail) {
        WildcardUnmarshallerImpl h = new WildcardUnmarshallerImpl(this.domHandler, this.wcMode, tail);
        return this.createUnmarshaller(h, tail);
    }

    private Unmarshaller.Handler createUnmarshaller(Unmarshaller.Handler fallthrough, Unmarshaller.Handler next) {
        return new Unmarshaller.ForkHandler(fallthrough, next){

            public void enterElement(UnmarshallingContext context, EventArg arg) throws SAXException {
                JaxBeanInfo target = (JaxBeanInfo)SingleReferenceNodeProperty.this.expectedElements.get(arg.uri, arg.local);
                if (target != null) {
                    context.setCurrentHandler(this);
                    this.spawnChild(context, target, true).enterElement(context, arg);
                    return;
                }
                super.enterElement(context, arg);
            }

            public void leaveChild(UnmarshallingContext context, Object child) throws SAXException {
                try {
                    SingleReferenceNodeProperty.this.acc.set(context.getTarget(), child);
                }
                catch (AccessorException e) {
                    1.handleGenericException(context, e);
                }
                context.setCurrentHandler(this.next);
            }

            protected Unmarshaller.Handler forwardTo(Unmarshaller.EventType event) {
                if (event == Unmarshaller.EventType.ENTER_ELEMENT) {
                    return this;
                }
                return super.forwardTo(event);
            }
        };
    }

    @Override
    public void buildChildElementUnmarshallers(UnmarshallerChain chain, QNameMap<Unmarshaller.Handler> handlers) {
        for (QNameMap.Entry<JaxBeanInfo> n : this.expectedElements.entrySet()) {
            handlers.put(n.nsUri, n.localName, new Unmarshaller.SpawnChildSetHandler(n.getValue(), chain.tail, true, this.acc));
        }
        if (this.domHandler != null) {
            handlers.put(CATCH_ALL, (Unmarshaller.Handler)new WildcardUnmarshallerImpl(this.domHandler, this.wcMode, chain.tail));
        }
    }

    @Override
    public PropertyKind getKind() {
        return PropertyKind.REFERENCE;
    }

    @Override
    public Accessor getElementPropertyAccessor(String nsUri, String localName) {
        if (this.expectedElements.containsKey(nsUri, localName)) {
            return this.acc;
        }
        return null;
    }

    private final class WildcardUnmarshallerImpl
    extends WildcardUnmarshaller {
        public WildcardUnmarshallerImpl(DomHandler domHandler, WildcardMode mode, Unmarshaller.Handler next) {
            super(domHandler, mode, next);
        }

        public void onDone(UnmarshallingContext context, Object element) throws SAXException {
            super.onDone(context, element);
            try {
                SingleReferenceNodeProperty.this.acc.set(context.getTarget(), element);
            }
            catch (AccessorException e) {
                WildcardUnmarshallerImpl.handleGenericException(context, e);
            }
        }
    }
}

