/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.reflect;

import com.sun.xml.bind.api.AccessorException;
import com.sun.xml.bind.api.RawAccessor;
import com.sun.xml.bind.v2.ClassFactory;
import com.sun.xml.bind.v2.runtime.reflect.Messages;
import com.sun.xml.bind.v2.runtime.reflect.opt.OptimizedAccessorFactory;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Accessor<BeanT, ValueT>
extends RawAccessor<BeanT, ValueT> {
    public final Class<ValueT> valueType;
    private static boolean accessWarned = false;
    public static final Accessor ERROR = new Accessor(Object.class){

        public Object get(Object o) {
            return null;
        }

        public void set(Object o, Object o1) {
        }
    };
    public static final Accessor<JAXBElement, Object> JAXB_ELEMENT_VALUE = new Accessor<JAXBElement, Object>(Object.class){

        @Override
        public Object get(JAXBElement jaxbElement) {
            return jaxbElement.getValue();
        }

        @Override
        public void set(JAXBElement jaxbElement, Object o) {
            jaxbElement.setValue(o);
        }
    };

    public Class<ValueT> getValueType() {
        return this.valueType;
    }

    protected Accessor(Class<ValueT> valueType) {
        this.valueType = valueType;
    }

    public Accessor<BeanT, ValueT> optimize() {
        return this;
    }

    public final <T> Accessor<BeanT, T> adapt(Class<T> targetType, Class<? extends XmlAdapter<T, ValueT>> ac) {
        return this.adapt(targetType, ClassFactory.create(ac));
    }

    public final <T> Accessor<BeanT, T> adapt(Class<T> targetType, final XmlAdapter<T, ValueT> a) {
        final Accessor extThis = this;
        return new Accessor<BeanT, T>(targetType){

            @Override
            public T get(BeanT bean) throws AccessorException {
                Object v = extThis.get(bean);
                if (v == null) {
                    return null;
                }
                return a.marshal(v);
            }

            @Override
            public void set(BeanT bean, T o) throws AccessorException {
                if (o == null) {
                    extThis.set(bean, null);
                } else {
                    extThis.set(bean, a.unmarshal(o));
                }
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class GetterSetterReflection<BeanT, ValueT>
    extends Accessor<BeanT, ValueT> {
        public final Method getter;
        public final Method setter;
        private static final Logger logger = Logger.getLogger(FieldReflection.class.getName());

        public GetterSetterReflection(Method getter, Method setter) {
            super(getter.getReturnType());
            this.getter = getter;
            this.setter = setter;
            this.makeAccessible(getter);
            this.makeAccessible(setter);
        }

        private void makeAccessible(Method m) {
            if (!Modifier.isPublic(m.getModifiers()) || !Modifier.isPublic(m.getDeclaringClass().getModifiers())) {
                try {
                    m.setAccessible(true);
                }
                catch (SecurityException e) {
                    if (!accessWarned) {
                        logger.log(Level.WARNING, Messages.UNABLE_TO_ACCESS_NON_PUBLIC_FIELD.format(m.getDeclaringClass().getName(), m.getName()), e);
                    }
                    accessWarned = true;
                }
            }
        }

        @Override
        public ValueT get(BeanT bean) throws AccessorException {
            try {
                return (ValueT)this.getter.invoke(bean, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new IllegalAccessError(e.getMessage());
            }
            catch (InvocationTargetException e) {
                throw this.handleInvocationTargetException(e);
            }
        }

        @Override
        public void set(BeanT bean, ValueT value) throws AccessorException {
            try {
                this.setter.invoke(bean, value);
            }
            catch (IllegalAccessException e) {
                throw new IllegalAccessError(e.getMessage());
            }
            catch (InvocationTargetException e) {
                throw this.handleInvocationTargetException(e);
            }
        }

        private AccessorException handleInvocationTargetException(InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            return new AccessorException(t);
        }

        @Override
        public Accessor<BeanT, ValueT> optimize() {
            Accessor acc = OptimizedAccessorFactory.get(this.getter, this.setter);
            if (acc != null) {
                return acc;
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FieldReflection<BeanT, ValueT>
    extends Accessor<BeanT, ValueT>
    implements PrivilegedAction<Void> {
        public final Field f;
        private static final Logger logger = Logger.getLogger(FieldReflection.class.getName());

        public FieldReflection(Field f) {
            super(f.getType());
            this.f = f;
            AccessController.doPrivileged(this);
        }

        @Override
        public Void run() {
            if (!Modifier.isPublic(this.f.getModifiers()) || !Modifier.isPublic(this.f.getDeclaringClass().getModifiers())) {
                try {
                    this.f.setAccessible(true);
                }
                catch (SecurityException e) {
                    if (!accessWarned) {
                        logger.log(Level.WARNING, Messages.UNABLE_TO_ACCESS_NON_PUBLIC_FIELD.format(this.f.getDeclaringClass().getName(), this.f.getName()), e);
                    }
                    accessWarned = true;
                }
            }
            return null;
        }

        @Override
        public ValueT get(BeanT bean) {
            try {
                return (ValueT)this.f.get(bean);
            }
            catch (IllegalAccessException e) {
                throw new IllegalAccessError(e.getMessage());
            }
        }

        @Override
        public void set(BeanT bean, ValueT value) {
            try {
                this.f.set(bean, value);
            }
            catch (IllegalAccessException e) {
                throw new IllegalAccessError(e.getMessage());
            }
        }

        @Override
        public Accessor<BeanT, ValueT> optimize() {
            Accessor acc = OptimizedAccessorFactory.get(this.f);
            if (acc != null) {
                return acc;
            }
            return this;
        }
    }
}

