/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.reflect;

import com.sun.xml.bind.WhiteSpaceProcessor;
import com.sun.xml.bind.api.AccessorException;
import com.sun.xml.bind.v2.runtime.Transducer;
import com.sun.xml.bind.v2.runtime.UnmarshallingContext;
import com.sun.xml.bind.v2.runtime.XMLSerializer;
import com.sun.xml.bind.v2.runtime.reflect.Accessor;
import com.sun.xml.bind.v2.runtime.reflect.ListIterator;
import com.sun.xml.bind.v2.runtime.reflect.Lister;
import com.sun.xml.bind.v2.runtime.reflect.TransducedAccessor;
import javax.xml.bind.JAXBException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListTransducedAccessorImpl<BeanT, ListT, ItemT, PackT>
extends TransducedAccessor<BeanT> {
    private final Transducer<ItemT> xducer;
    private final Lister<BeanT, ListT, ItemT, PackT> lister;
    private final Accessor<BeanT, ListT> acc;

    public ListTransducedAccessorImpl(Transducer<ItemT> xducer, Accessor<BeanT, ListT> acc, Lister<BeanT, ListT, ItemT, PackT> lister) {
        this.xducer = xducer;
        this.lister = lister;
        this.acc = acc;
    }

    @Override
    public boolean useNamespace() {
        return this.xducer.useNamespace();
    }

    @Override
    public void declareNamespace(BeanT bean, XMLSerializer w) throws AccessorException, SAXException {
        Object list = this.acc.get(bean);
        if (list != null) {
            ListIterator<ItemT> itr = this.lister.iterator(list, w);
            while (itr.hasNext()) {
                try {
                    ItemT item = itr.next();
                    if (item == null) continue;
                    this.xducer.declareNamespace(item, w);
                }
                catch (JAXBException e) {
                    w.reportError(null, e);
                }
            }
        }
    }

    @Override
    public String print(BeanT o, XMLSerializer w) throws AccessorException, SAXException {
        StringBuffer buf = new StringBuffer();
        Object list = this.acc.get(o);
        if (list != null) {
            ListIterator<ItemT> itr = this.lister.iterator(list, w);
            while (itr.hasNext()) {
                try {
                    ItemT item = itr.next();
                    if (item == null) continue;
                    if (buf.length() > 0) {
                        buf.append(' ');
                    }
                    buf.append(this.xducer.print(item, w));
                }
                catch (JAXBException e) {
                    w.reportError(null, e);
                }
            }
        }
        return buf.toString();
    }

    private void processValue(BeanT bean, CharSequence s, UnmarshallingContext context) throws AccessorException, SAXException {
        PackT pack = this.lister.startPacking(bean, this.acc, context);
        int idx = 0;
        int len = s.length();
        while (true) {
            int p;
            for (p = idx; p < len && !WhiteSpaceProcessor.isWhiteSpace(s.charAt(p)); ++p) {
            }
            CharSequence token = s.subSequence(idx, p);
            if (!token.equals("")) {
                this.lister.addToPack(pack, this.xducer.parse(token, context));
            }
            if (p == len) break;
            while (p < len && WhiteSpaceProcessor.isWhiteSpace(s.charAt(p))) {
                ++p;
            }
            if (p == len) break;
            idx = p;
        }
        this.lister.endPacking(pack, bean, this.acc);
    }

    @Override
    public void parse(BeanT bean, CharSequence lexical, UnmarshallingContext context) throws AccessorException, SAXException {
        this.processValue(bean, lexical, context);
    }

    @Override
    public boolean hasValue(BeanT bean) throws AccessorException {
        return this.acc.get(bean) != null;
    }
}

