/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.reflect;

import com.sun.xml.bind.api.AccessorException;
import com.sun.xml.bind.v2.ClassFactory;
import com.sun.xml.bind.v2.TODO;
import com.sun.xml.bind.v2.model.core.ID;
import com.sun.xml.bind.v2.runtime.IDHandler;
import com.sun.xml.bind.v2.runtime.UnmarshallingContext;
import com.sun.xml.bind.v2.runtime.XMLSerializer;
import com.sun.xml.bind.v2.runtime.reflect.Accessor;
import com.sun.xml.bind.v2.runtime.reflect.ListIterator;
import com.sun.xml.bind.v2.runtime.reflect.PrimitiveArrayListerBoolean;
import com.sun.xml.bind.v2.runtime.reflect.PrimitiveArrayListerByte;
import com.sun.xml.bind.v2.runtime.reflect.PrimitiveArrayListerCharacter;
import com.sun.xml.bind.v2.runtime.reflect.PrimitiveArrayListerDouble;
import com.sun.xml.bind.v2.runtime.reflect.PrimitiveArrayListerFloat;
import com.sun.xml.bind.v2.runtime.reflect.PrimitiveArrayListerInteger;
import com.sun.xml.bind.v2.runtime.reflect.PrimitiveArrayListerLong;
import com.sun.xml.bind.v2.runtime.reflect.PrimitiveArrayListerShort;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Lister<BeanT, PropT, ItemT, PackT> {
    private static final Class[] implClasses = new Class[]{ArrayList.class, HashSet.class, Stack.class};
    private static final Map<Class, Lister> arrayListerCache = Collections.synchronizedMap(new WeakHashMap());
    static final Map<Class, Lister> primitiveArrayListers = new HashMap<Class, Lister>();
    public static final Lister ERROR;
    private static final ListIterator EMPTY_ITERATOR;

    protected Lister() {
    }

    public abstract ListIterator<ItemT> iterator(PropT var1, XMLSerializer var2);

    public abstract PackT startPacking(BeanT var1, Accessor<BeanT, PropT> var2, UnmarshallingContext var3) throws AccessorException;

    public abstract void addToPack(PackT var1, ItemT var2);

    public abstract void endPacking(PackT var1, BeanT var2, Accessor<BeanT, PropT> var3) throws AccessorException;

    public abstract void reset(BeanT var1, Accessor<BeanT, PropT> var2) throws AccessorException;

    public static final <BeanT, PropT, ItemT, PackT> Lister<BeanT, PropT, ItemT, PackT> create(Class fieldType, ID idness) {
        Lister l;
        if (fieldType.isArray()) {
            l = Lister.getArrayLister(fieldType.getComponentType());
        } else if (Collection.class.isAssignableFrom(fieldType)) {
            l = new CollectionLister(Lister.getImplClass(fieldType));
        } else {
            return null;
        }
        if (idness == ID.IDREF) {
            l = new IDHandler.IDREFS(l);
        }
        return l;
    }

    private static Class getImplClass(Class fieldType) {
        TODO.checkSpec();
        if (!fieldType.isInterface()) {
            return fieldType;
        }
        for (Class impl : implClasses) {
            if (!fieldType.isAssignableFrom(impl)) continue;
            return impl;
        }
        return null;
    }

    private static Lister getArrayLister(Class componentType) {
        Lister l;
        if (componentType.isPrimitive()) {
            l = primitiveArrayListers.get(componentType);
        } else {
            l = arrayListerCache.get(componentType);
            if (l == null) {
                l = new ArrayLister(componentType);
                arrayListerCache.put(componentType, l);
            }
        }
        assert (l != null);
        return l;
    }

    static {
        PrimitiveArrayListerBoolean.register();
        PrimitiveArrayListerByte.register();
        PrimitiveArrayListerCharacter.register();
        PrimitiveArrayListerDouble.register();
        PrimitiveArrayListerFloat.register();
        PrimitiveArrayListerInteger.register();
        PrimitiveArrayListerLong.register();
        PrimitiveArrayListerShort.register();
        ERROR = new Lister(){

            public ListIterator iterator(Object o, XMLSerializer context) {
                return EMPTY_ITERATOR;
            }

            public Object startPacking(Object o, Accessor accessor, UnmarshallingContext context) {
                return null;
            }

            public void addToPack(Object o, Object o1) {
            }

            public void endPacking(Object o, Object o1, Accessor accessor) {
            }

            public void reset(Object o, Accessor accessor) {
            }
        };
        EMPTY_ITERATOR = new ListIterator(){

            public boolean hasNext() {
                return false;
            }

            public Object next() {
                throw new IllegalStateException();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CollectionLister<BeanT, T extends Collection>
    extends Lister<BeanT, T, Object, T> {
        private final Class<? extends T> implClass;

        public CollectionLister(Class<? extends T> implClass) {
            this.implClass = implClass;
        }

        @Override
        public ListIterator iterator(T collection, XMLSerializer context) {
            final Iterator itr = collection.iterator();
            return new ListIterator(){

                public boolean hasNext() {
                    return itr.hasNext();
                }

                public Object next() {
                    return itr.next();
                }
            };
        }

        @Override
        public T startPacking(BeanT bean, Accessor<BeanT, T> acc, UnmarshallingContext context) throws AccessorException {
            Collection collection = (Collection)acc.get(bean);
            if (collection == null) {
                collection = (Collection)ClassFactory.create(this.implClass);
                acc.set(bean, collection);
            }
            collection.clear();
            return (T)collection;
        }

        @Override
        public void addToPack(T collection, Object o) {
            collection.add((Object)o);
        }

        @Override
        public void endPacking(T pack, BeanT bean, Accessor<BeanT, T> acc) {
        }

        @Override
        public void reset(BeanT bean, Accessor<BeanT, T> acc) throws AccessorException {
            ((Collection)acc.get(bean)).clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Pack<ItemT>
    extends ArrayList<ItemT> {
        private final Class<ItemT> itemType;

        public Pack(Class<ItemT> itemType) {
            this.itemType = itemType;
        }

        public ItemT[] build() {
            return super.toArray((Object[])Array.newInstance(this.itemType, this.size()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ArrayLister<BeanT, ItemT>
    extends Lister<BeanT, ItemT[], ItemT, Pack<ItemT>> {
        private final Class<ItemT> itemType;

        public ArrayLister(Class<ItemT> itemType) {
            this.itemType = itemType;
        }

        @Override
        public ListIterator<ItemT> iterator(final ItemT[] objects, XMLSerializer context) {
            return new ListIterator<ItemT>(){
                int idx = 0;

                @Override
                public boolean hasNext() {
                    return this.idx < objects.length;
                }

                @Override
                public ItemT next() {
                    return objects[this.idx++];
                }
            };
        }

        @Override
        public Pack startPacking(BeanT current, Accessor<BeanT, ItemT[]> acc, UnmarshallingContext context) {
            return new Pack<ItemT>(this.itemType);
        }

        @Override
        public void addToPack(Pack<ItemT> objects, ItemT o) {
            objects.add(o);
        }

        @Override
        public void endPacking(Pack<ItemT> pack, BeanT bean, Accessor<BeanT, ItemT[]> acc) throws AccessorException {
            acc.set(bean, pack.build());
        }

        @Override
        public void reset(BeanT o, Accessor<BeanT, ItemT[]> acc) throws AccessorException {
            acc.set(o, (Object[])Array.newInstance(this.itemType, 0));
        }
    }
}

