/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantObject;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantString
extends Constant
implements ConstantObject {
    private int string_index;

    public final int getStringIndex() {
        return this.string_index;
    }

    public ConstantString(int string_index) {
        super((byte)8);
        this.string_index = string_index;
    }

    public final void setStringIndex(int string_index) {
        this.string_index = string_index;
    }

    public ConstantString(ConstantString c) {
        this(c.getStringIndex());
    }

    public void accept(Visitor v) {
        v.visitConstantString(this);
    }

    ConstantString(DataInputStream file) throws IOException {
        this(file.readUnsignedShort());
    }

    public final void dump(DataOutputStream file) throws IOException {
        file.writeByte(this.tag);
        file.writeShort(this.string_index);
    }

    public final String toString() {
        return super.toString() + "(string_index = " + this.string_index + ")";
    }

    public Object getConstantValue(ConstantPool cp) {
        Constant c = cp.getConstant(this.string_index, (byte)1);
        return ((ConstantUtf8)c).getBytes();
    }

    public String getBytes(ConstantPool cp) {
        return (String)this.getConstantValue(cp);
    }
}

