/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class LineNumber
implements Cloneable,
Node {
    private int start_pc;
    private int line_number;

    public final int getLineNumber() {
        return this.line_number;
    }

    public final int getStartPC() {
        return this.start_pc;
    }

    public final void setLineNumber(int line_number) {
        this.line_number = line_number;
    }

    public final void setStartPC(int start_pc) {
        this.start_pc = start_pc;
    }

    public LineNumber(int start_pc, int line_number) {
        this.start_pc = start_pc;
        this.line_number = line_number;
    }

    public LineNumber copy() {
        try {
            return (LineNumber)this.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public LineNumber(LineNumber c) {
        this(c.getStartPC(), c.getLineNumber());
    }

    public void accept(Visitor v) {
        v.visitLineNumber(this);
    }

    LineNumber(DataInputStream file) throws IOException {
        this(file.readUnsignedShort(), file.readUnsignedShort());
    }

    public final void dump(DataOutputStream file) throws IOException {
        file.writeShort(this.start_pc);
        file.writeShort(this.line_number);
    }

    public final String toString() {
        return "LineNumber(" + this.start_pc + ", " + this.line_number + ")";
    }
}

