/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.lib;

import com.sun.org.apache.xalan.internal.extensions.XSLProcessorContext;
import com.sun.org.apache.xalan.internal.templates.ElemExtensionCall;
import com.sun.org.apache.xalan.internal.templates.OutputProperties;
import com.sun.org.apache.xalan.internal.transformer.TransformerImpl;
import com.sun.org.apache.xml.internal.serializer.SerializationHandler;
import com.sun.org.apache.xml.internal.utils.PrefixResolver;
import com.sun.org.apache.xpath.internal.XPath;
import com.sun.org.apache.xpath.internal.XPathContext;
import com.sun.org.apache.xpath.internal.objects.XObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Hashtable;
import javax.xml.transform.Result;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Redirect {
    protected Hashtable m_formatterListeners = new Hashtable();
    protected Hashtable m_outputStreams = new Hashtable();
    public static final boolean DEFAULT_APPEND_OPEN = false;
    public static final boolean DEFAULT_APPEND_WRITE = false;

    public void close(XSLProcessorContext context, ElemExtensionCall elem) throws MalformedURLException, FileNotFoundException, IOException, TransformerException {
        String fileName = this.getFilename(context, elem);
        Object formatterObj = this.m_formatterListeners.get(fileName);
        if (null != formatterObj) {
            ContentHandler fl = (ContentHandler)formatterObj;
            try {
                fl.endDocument();
            }
            catch (SAXException se) {
                throw new TransformerException(se);
            }
            OutputStream ostream = (OutputStream)this.m_outputStreams.get(fileName);
            if (null != ostream) {
                ostream.close();
                this.m_outputStreams.remove(fileName);
            }
            this.m_formatterListeners.remove(fileName);
        }
    }

    public void open(XSLProcessorContext context, ElemExtensionCall elem) throws MalformedURLException, FileNotFoundException, IOException, TransformerException {
        String fileName = this.getFilename(context, elem);
        Object flistener = this.m_formatterListeners.get(fileName);
        if (null == flistener) {
            String mkdirsExpr = elem.getAttribute("mkdirs", context.getContextNode(), context.getTransformer());
            boolean mkdirs = mkdirsExpr != null ? mkdirsExpr.equals("true") || mkdirsExpr.equals("yes") : true;
            String appendExpr = elem.getAttribute("append", context.getContextNode(), context.getTransformer());
            boolean append = appendExpr != null ? appendExpr.equals("true") || appendExpr.equals("yes") : false;
            ContentHandler ignored = this.makeFormatterListener(context, elem, fileName, true, mkdirs, append);
        }
    }

    public void write(XSLProcessorContext context, ElemExtensionCall elem) throws MalformedURLException, FileNotFoundException, IOException, TransformerException {
        OutputStream ostream;
        ContentHandler formatter;
        String fileName = this.getFilename(context, elem);
        Object flObject = this.m_formatterListeners.get(fileName);
        boolean inTable = false;
        if (null == flObject) {
            String mkdirsExpr = elem.getAttribute("mkdirs", context.getContextNode(), context.getTransformer());
            boolean mkdirs = mkdirsExpr != null ? mkdirsExpr.equals("true") || mkdirsExpr.equals("yes") : true;
            String appendExpr = elem.getAttribute("append", context.getContextNode(), context.getTransformer());
            boolean append = appendExpr != null ? appendExpr.equals("true") || appendExpr.equals("yes") : false;
            formatter = this.makeFormatterListener(context, elem, fileName, true, mkdirs, append);
        } else {
            inTable = true;
            formatter = (ContentHandler)flObject;
        }
        TransformerImpl transf = context.getTransformer();
        transf.executeChildTemplates(elem, context.getContextNode(), context.getMode(), formatter);
        if (!inTable && null != (ostream = (OutputStream)this.m_outputStreams.get(fileName))) {
            try {
                formatter.endDocument();
            }
            catch (SAXException se) {
                throw new TransformerException(se);
            }
            ostream.close();
            this.m_outputStreams.remove(fileName);
            this.m_formatterListeners.remove(fileName);
        }
    }

    private String urlToFileName(String base) {
        if (null != base) {
            if (base.startsWith("file:////")) {
                base = base.substring(7);
            } else if (base.startsWith("file:///")) {
                base = base.substring(6);
            } else if (base.startsWith("file://")) {
                base = base.substring(5);
            } else if (base.startsWith("file:/")) {
                base = base.substring(5);
            } else if (base.startsWith("file:")) {
                base = base.substring(4);
            }
        }
        return base;
    }

    private String getFilename(XSLProcessorContext context, ElemExtensionCall elem) throws MalformedURLException, FileNotFoundException, IOException, TransformerException {
        String fileName;
        String fileNameExpr = elem.getAttribute("select", context.getContextNode(), context.getTransformer());
        if (null != fileNameExpr) {
            XPathContext xctxt = context.getTransformer().getXPathContext();
            XPath myxpath = new XPath(fileNameExpr, elem, xctxt.getNamespaceContext(), 0);
            XObject xobj = myxpath.execute(xctxt, context.getContextNode(), (PrefixResolver)elem);
            fileName = xobj.str();
            if (null == fileName || fileName.length() == 0) {
                fileName = elem.getAttribute("file", context.getContextNode(), context.getTransformer());
            }
        } else {
            fileName = elem.getAttribute("file", context.getContextNode(), context.getTransformer());
        }
        if (null == fileName) {
            context.getTransformer().getMsgMgr().error((SourceLocator)elem, elem, context.getContextNode(), "ER_REDIRECT_COULDNT_GET_FILENAME");
        }
        return fileName;
    }

    private ContentHandler makeFormatterListener(XSLProcessorContext context, ElemExtensionCall elem, String fileName, boolean shouldPutInTable, boolean mkdirs, boolean append) throws MalformedURLException, FileNotFoundException, IOException, TransformerException {
        String dirStr;
        Result outputTarget;
        String base;
        File file = new File(fileName);
        TransformerImpl transformer = context.getTransformer();
        if (!file.isAbsolute() && null != (base = null != (outputTarget = transformer.getOutputTarget()) && (base = outputTarget.getSystemId()) != null ? this.urlToFileName(base) : this.urlToFileName(transformer.getBaseURLOfSource()))) {
            File baseFile = new File(base);
            file = new File(baseFile.getParent(), fileName);
        }
        if (mkdirs && null != (dirStr = file.getParent()) && dirStr.length() > 0) {
            File dir = new File(dirStr);
            dir.mkdirs();
        }
        OutputProperties format = transformer.getOutputFormat();
        FileOutputStream ostream = new FileOutputStream(file.getPath(), append);
        try {
            SerializationHandler flistener = transformer.createSerializationHandler(new StreamResult(ostream), format);
            try {
                flistener.startDocument();
            }
            catch (SAXException se) {
                throw new TransformerException(se);
            }
            if (shouldPutInTable) {
                this.m_outputStreams.put(fileName, ostream);
                this.m_formatterListeners.put(fileName, flistener);
            }
            return flistener;
        }
        catch (TransformerException te) {
            throw new TransformerException(te);
        }
    }
}

