/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.xsltc.compiler;

import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.INVOKEVIRTUAL;
import com.sun.org.apache.bcel.internal.generic.InstructionConstants;
import com.sun.org.apache.bcel.internal.generic.InstructionList;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Instruction;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Param;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Parser;
import com.sun.org.apache.xalan.internal.xsltc.compiler.QName;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Stylesheet;
import com.sun.org.apache.xalan.internal.xsltc.compiler.SymbolTable;
import com.sun.org.apache.xalan.internal.xsltc.compiler.SyntaxTreeNode;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Template;
import com.sun.org.apache.xalan.internal.xsltc.compiler.WithParam;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.ClassGenerator;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.ErrorMsg;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.MethodGenerator;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.Type;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.TypeCheckError;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.Util;
import com.sun.org.apache.xml.internal.utils.XMLChar;
import java.util.Vector;

final class CallTemplate
extends Instruction {
    private QName _name;
    private Object[] _parameters = null;
    private Template _calleeTemplate = null;

    CallTemplate() {
    }

    private void buildParameterList() {
        Vector defaultParams = this._calleeTemplate.getParameters();
        int numParams = defaultParams.size();
        this._parameters = new Object[numParams];
        int i = 0;
        while (i < numParams) {
            this._parameters[i] = defaultParams.elementAt(i);
            ++i;
        }
        int count = this.elementCount();
        int i2 = 0;
        while (i2 < count) {
            Object node = this.elementAt(i2);
            if (node instanceof WithParam) {
                WithParam withParam = (WithParam)node;
                QName name = withParam.getName();
                int k = 0;
                while (k < numParams) {
                    Object object = this._parameters[k];
                    if (object instanceof Param && ((Param)object).getName() == name) {
                        withParam.setDoParameterOptimization(true);
                        this._parameters[k] = withParam;
                        break;
                    }
                    if (object instanceof WithParam && ((WithParam)object).getName() == name) {
                        withParam.setDoParameterOptimization(true);
                        this._parameters[k] = withParam;
                        break;
                    }
                    ++k;
                }
            }
            ++i2;
        }
    }

    public boolean hasWithParams() {
        return this.elementCount() > 0;
    }

    public void display(int indent) {
        this.indent(indent);
        System.out.print("CallTemplate");
        Util.println(" name " + this._name);
        this.displayContents(indent + 4);
    }

    public void parseContents(Parser parser) {
        String name = this.getAttribute("name");
        if (name.length() > 0) {
            if (!XMLChar.isValidQName(name)) {
                ErrorMsg err = new ErrorMsg("INVALID_QNAME_ERR", (Object)name, this);
                parser.reportError(3, err);
            }
            this._name = parser.getQNameIgnoreDefaultNs(name);
        } else {
            this.reportError(this, parser, "REQUIRED_ATTR_ERR", "name");
        }
        this.parseChildren(parser);
    }

    public Template getCalleeTemplate() {
        Stylesheet stylesheet = this.getXSLTC().getStylesheet();
        Vector templates = stylesheet.getAllValidTemplates();
        int size = templates.size();
        int i = 0;
        while (i < size) {
            Template t = (Template)templates.elementAt(i);
            if (t.getName() == this._name && t.isSimpleNamedTemplate()) {
                return t;
            }
            ++i;
        }
        return null;
    }

    public void translate(ClassGenerator classGen, MethodGenerator methodGen) {
        Stylesheet stylesheet = classGen.getStylesheet();
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = methodGen.getInstructionList();
        if (stylesheet.hasLocalParams() || this.hasContents()) {
            this._calleeTemplate = this.getCalleeTemplate();
            if (this._calleeTemplate != null) {
                this.buildParameterList();
            } else {
                int push = cpg.addMethodref("com.sun.org.apache.xalan.internal.xsltc.runtime.AbstractTranslet", "pushParamFrame", "()V");
                il.append(classGen.loadTranslet());
                il.append(new INVOKEVIRTUAL(push));
                this.translateContents(classGen, methodGen);
            }
        }
        String className = stylesheet.getClassName();
        String methodName = Util.escape(this._name.toString());
        il.append(classGen.loadTranslet());
        il.append(methodGen.loadDOM());
        il.append(methodGen.loadIterator());
        il.append(methodGen.loadHandler());
        il.append(methodGen.loadCurrentNode());
        StringBuffer methodSig = new StringBuffer("(Lcom/sun/org/apache/xalan/internal/xsltc/DOM;Lcom/sun/org/apache/xml/internal/dtm/DTMAxisIterator;Lcom/sun/org/apache/xml/internal/serializer/SerializationHandler;I");
        if (this._calleeTemplate != null) {
            Vector calleeParams = this._calleeTemplate.getParameters();
            int numParams = this._parameters.length;
            int i = 0;
            while (i < numParams) {
                SyntaxTreeNode node = (SyntaxTreeNode)this._parameters[i];
                methodSig.append("Ljava/lang/Object;");
                if (node instanceof Param) {
                    il.append(InstructionConstants.ACONST_NULL);
                } else {
                    node.translate(classGen, methodGen);
                }
                ++i;
            }
        }
        methodSig.append(")V");
        il.append(new INVOKEVIRTUAL(cpg.addMethodref(className, methodName, methodSig.toString())));
        if (this._calleeTemplate == null && (stylesheet.hasLocalParams() || this.hasContents())) {
            int pop = cpg.addMethodref("com.sun.org.apache.xalan.internal.xsltc.runtime.AbstractTranslet", "popParamFrame", "()V");
            il.append(classGen.loadTranslet());
            il.append(new INVOKEVIRTUAL(pop));
        }
    }

    public Type typeCheck(SymbolTable stable) throws TypeCheckError {
        Template template = stable.lookupTemplate(this._name);
        if (template == null) {
            ErrorMsg err = new ErrorMsg("TEMPLATE_UNDEF_ERR", (Object)this._name, this);
            throw new TypeCheckError(err);
        }
        this.typeCheckContents(stable);
        return Type.Void;
    }
}

