/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.serializer;

import com.sun.org.apache.xml.internal.dtm.ref.dom2dtm.DOM2DTM;
import com.sun.org.apache.xml.internal.res.XMLMessages;
import com.sun.org.apache.xml.internal.serializer.AttributesImplSerializer;
import com.sun.org.apache.xml.internal.serializer.DOMSerializer;
import com.sun.org.apache.xml.internal.serializer.ElemContext;
import com.sun.org.apache.xml.internal.serializer.NamespaceMappings;
import com.sun.org.apache.xml.internal.serializer.SerializationHandler;
import com.sun.org.apache.xml.internal.serializer.SerializerConstants;
import com.sun.org.apache.xml.internal.serializer.SerializerTrace;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Properties;
import java.util.Vector;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Transformer;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class SerializerBase
implements SerializationHandler,
SerializerConstants,
DOM2DTM.CharacterNodeHandler {
    protected boolean m_needToCallStartDocument = true;
    protected boolean m_cdataTagOpen = false;
    protected AttributesImplSerializer m_attributes = new AttributesImplSerializer();
    protected boolean m_inEntityRef = false;
    protected boolean m_inExternalDTD = false;
    private String m_doctypeSystem;
    private String m_doctypePublic;
    boolean m_needToOutputDocTypeDecl = true;
    private String m_encoding = null;
    private boolean m_shouldNotWriteXMLHeader = false;
    private String m_standalone;
    protected boolean m_standaloneWasSpecified = false;
    protected boolean m_doIndent = false;
    protected int m_indentAmount = 0;
    private String m_version = null;
    private String m_mediatype;
    private Transformer m_transformer;
    protected Vector m_cdataSectionElements = null;
    protected NamespaceMappings m_prefixMap;
    protected SerializerTrace m_tracer;
    protected SourceLocator m_sourceLocator;
    protected Writer m_writer = null;
    protected ElemContext m_elemContext = new ElemContext();
    protected char[] m_charsBuff = new char[60];
    protected char[] m_attrBuff = new char[30];

    public int getIndentAmount() {
        return this.m_indentAmount;
    }

    public void close() {
    }

    public abstract void endCDATA() throws SAXException;

    public abstract void endDTD() throws SAXException;

    public abstract void endDocument() throws SAXException;

    protected void fireEndDoc() throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(2);
        }
    }

    protected void fireStartDoc() throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(1);
        }
    }

    private void flushMyWriter() {
        block2: {
            if (this.m_writer == null) break block2;
            try {
                this.m_writer.flush();
            }
            catch (IOException ioe) {}
        }
    }

    public abstract void flushPending() throws SAXException;

    protected void initCDATA() {
    }

    private void resetSerializerBase() {
        this.m_attributes.clear();
        this.m_cdataSectionElements = null;
        this.m_elemContext = new ElemContext();
        this.m_doctypePublic = null;
        this.m_doctypeSystem = null;
        this.m_doIndent = false;
        this.m_encoding = null;
        this.m_indentAmount = 0;
        this.m_inEntityRef = false;
        this.m_inExternalDTD = false;
        this.m_mediatype = null;
        this.m_needToCallStartDocument = true;
        this.m_needToOutputDocTypeDecl = false;
        if (this.m_prefixMap != null) {
            this.m_prefixMap.reset();
        }
        this.m_shouldNotWriteXMLHeader = false;
        this.m_sourceLocator = null;
        this.m_standalone = null;
        this.m_standaloneWasSpecified = false;
        this.m_tracer = null;
        this.m_transformer = null;
        this.m_version = null;
    }

    public abstract void startCDATA() throws SAXException;

    public void startDocument() throws SAXException {
        this.startDocumentInternal();
        this.m_needToCallStartDocument = false;
    }

    protected void startDocumentInternal() throws SAXException {
        if (this.m_tracer != null) {
            this.fireStartDoc();
        }
    }

    public boolean getIndent() {
        return this.m_doIndent;
    }

    public boolean getOmitXMLDeclaration() {
        return this.m_shouldNotWriteXMLHeader;
    }

    protected boolean isCdataSection() {
        boolean b = false;
        if (null != this.m_cdataSectionElements) {
            String prefix;
            if (this.m_elemContext.m_elementLocalName == null) {
                this.m_elemContext.m_elementLocalName = SerializerBase.getLocalName(this.m_elemContext.m_elementName);
            }
            if (this.m_elemContext.m_elementURI == null && (prefix = SerializerBase.getPrefixPart(this.m_elemContext.m_elementName)) != null) {
                this.m_elemContext.m_elementURI = this.m_prefixMap.lookupNamespace(prefix);
            }
            if (null != this.m_elemContext.m_elementURI && this.m_elemContext.m_elementURI.length() == 0) {
                this.m_elemContext.m_elementURI = null;
            }
            int nElems = this.m_cdataSectionElements.size();
            int i = 0;
            while (i < nElems) {
                String uri = (String)this.m_cdataSectionElements.elementAt(i);
                String loc = (String)this.m_cdataSectionElements.elementAt(i + 1);
                if (loc.equals(this.m_elemContext.m_elementLocalName) && SerializerBase.subPartMatch(this.m_elemContext.m_elementURI, uri)) {
                    b = true;
                    break;
                }
                i += 2;
            }
        }
        return b;
    }

    public boolean reset() {
        this.resetSerializerBase();
        return true;
    }

    public void setIndentAmount(int m_indentAmount) {
        this.m_indentAmount = m_indentAmount;
    }

    public void setIndent(boolean doIndent) {
        this.m_doIndent = doIndent;
    }

    public void setOmitXMLDeclaration(boolean b) {
        this.m_shouldNotWriteXMLHeader = b;
    }

    public abstract boolean setEscaping(boolean var1) throws SAXException;

    public abstract void characters(char[] var1, int var2, int var3) throws SAXException;

    public abstract void comment(char[] var1, int var2, int var3) throws SAXException;

    protected void fireCDATAEvent(char[] chars, int start, int length) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(10, chars, start, length);
        }
    }

    protected void fireCharEvent(char[] chars, int start, int length) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(5, chars, start, length);
        }
    }

    protected void fireCommentEvent(char[] chars, int start, int length) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(8, new String(chars, start, length));
        }
    }

    public abstract void ignorableWhitespace(char[] var1, int var2, int var3) throws SAXException;

    public DOMSerializer asDOMSerializer() throws IOException {
        return this;
    }

    public NamespaceMappings getNamespaceMappings() {
        return this.m_prefixMap;
    }

    public void setNamespaceMappings(NamespaceMappings mappings) {
        this.m_prefixMap = mappings;
    }

    public abstract OutputStream getOutputStream();

    public abstract void setOutputStream(OutputStream var1);

    public abstract Writer getWriter();

    public abstract void setWriter(Writer var1);

    public String getDoctypePublic() {
        return this.m_doctypePublic;
    }

    public String getDoctypeSystem() {
        return this.m_doctypeSystem;
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    public String getMediaType() {
        return this.m_mediatype;
    }

    public String getStandalone() {
        return this.m_standalone;
    }

    public String getVersion() {
        return this.m_version;
    }

    public abstract void characters(String var1) throws SAXException;

    public void comment(String data) throws SAXException {
        int length = data.length();
        if (length > this.m_charsBuff.length) {
            this.m_charsBuff = new char[length * 2 + 1];
        }
        data.getChars(0, length, this.m_charsBuff, 0);
        this.comment(this.m_charsBuff, 0, length);
    }

    public abstract void endElement(String var1) throws SAXException;

    public void endEntity(String name) throws SAXException {
        if (name.equals("[dtd]")) {
            this.m_inExternalDTD = false;
        }
        this.m_inEntityRef = false;
        if (this.m_tracer != null) {
            this.fireEndEntity(name);
        }
    }

    public abstract void endPrefixMapping(String var1) throws SAXException;

    public void entityReference(String name) throws SAXException {
        this.flushPending();
        this.startEntity(name);
        this.endEntity(name);
        if (this.m_tracer != null) {
            this.fireEntityReference(name);
        }
    }

    protected void fireEndElem(String name) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(4, name, (Attributes)null);
        }
    }

    public void fireEndEntity(String name) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
        }
    }

    protected void fireEntityReference(String name) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(9, name, (Attributes)null);
        }
    }

    protected void fireStartElem(String elemName) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(3, elemName, this.m_attributes);
        }
    }

    protected void fireStartEntity(String name) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(9, name);
        }
    }

    public void setDoctypePublic(String doctypePublic) {
        this.m_doctypePublic = doctypePublic;
    }

    public void setDoctypeSystem(String doctypeSystem) {
        this.m_doctypeSystem = doctypeSystem;
    }

    public void setEncoding(String m_encoding) {
        this.m_encoding = m_encoding;
    }

    public void setMediaType(String mediaType) {
        this.m_mediatype = mediaType;
    }

    public void setStandalone(String standalone) {
        if (standalone != null) {
            this.m_standaloneWasSpecified = true;
            this.setStandaloneInternal(standalone);
        }
    }

    protected void setStandaloneInternal(String standalone) {
        this.m_standalone = "yes".equals(standalone) ? "yes" : "no";
    }

    public void setVersion(String version) {
        this.m_version = version;
    }

    public abstract void skippedEntity(String var1) throws SAXException;

    public abstract void startElement(String var1) throws SAXException;

    public abstract void startEntity(String var1) throws SAXException;

    public abstract Properties getOutputFormat();

    public abstract void setOutputFormat(Properties var1);

    public abstract void setCdataSectionElements(Vector var1);

    public void setSourceLocator(SourceLocator locator) {
        this.m_sourceLocator = locator;
    }

    public Transformer getTransformer() {
        return this.m_transformer;
    }

    public void setTransformer(Transformer t) {
        this.m_transformer = t;
        this.m_tracer = this.m_transformer instanceof SerializerTrace && ((SerializerTrace)((Object)this.m_transformer)).hasTraceListeners() ? (SerializerTrace)((Object)this.m_transformer) : null;
    }

    public void characters(Node node) throws SAXException {
        this.flushPending();
        String data = node.getNodeValue();
        if (data != null) {
            int length = data.length();
            if (length > this.m_charsBuff.length) {
                this.m_charsBuff = new char[length * 2 + 1];
            }
            data.getChars(0, length, this.m_charsBuff, 0);
            this.characters(this.m_charsBuff, 0, length);
        }
    }

    public abstract void serialize(Node var1) throws IOException;

    public void addAttributes(Attributes atts) throws SAXException {
        int nAtts = atts.getLength();
        int i = 0;
        while (i < nAtts) {
            String uri = atts.getURI(i);
            if (null == uri) {
                uri = "";
            }
            this.addAttributeAlways(uri, atts.getLocalName(i), atts.getQName(i), atts.getType(i), atts.getValue(i));
            ++i;
        }
    }

    public ContentHandler asContentHandler() throws IOException {
        return this;
    }

    public abstract void setContentHandler(ContentHandler var1);

    public void setDocumentLocator(Locator locator) {
    }

    public void error(SAXParseException exc) throws SAXException {
    }

    public void fatalError(SAXParseException exc) throws SAXException {
        this.m_elemContext.m_startTagOpen = false;
    }

    public void warning(SAXParseException exc) throws SAXException {
    }

    protected static String getLocalName(String qname) {
        int col = qname.lastIndexOf(58);
        return col > 0 ? qname.substring(col + 1) : qname;
    }

    public String getNamespaceURIFromPrefix(String prefix) {
        String uri = null;
        if (this.m_prefixMap != null) {
            uri = this.m_prefixMap.lookupNamespace(prefix);
        }
        return uri;
    }

    public String getPrefix(String namespaceURI) {
        String prefix = this.m_prefixMap.lookupPrefix(namespaceURI);
        return prefix;
    }

    protected static final String getPrefixPart(String qname) {
        int col = qname.indexOf(58);
        return col > 0 ? qname.substring(0, col) : null;
    }

    protected String patchName(String qname) {
        int lastColon = qname.lastIndexOf(58);
        if (lastColon > 0) {
            int firstColon = qname.indexOf(58);
            String prefix = qname.substring(0, firstColon);
            String localName = qname.substring(lastColon + 1);
            String uri = this.m_prefixMap.lookupNamespace(prefix);
            if (uri != null && uri.length() == 0) {
                return localName;
            }
            if (firstColon != lastColon) {
                return prefix + ':' + localName;
            }
        }
        return qname;
    }

    public void addAttribute(String name, String value) {
        if (this.m_elemContext.m_startTagOpen) {
            String patchedName = this.patchName(name);
            String localName = SerializerBase.getLocalName(patchedName);
            String uri = this.getNamespaceURI(patchedName, false);
            this.addAttributeAlways(uri, localName, patchedName, "CDATA", value);
        }
    }

    public abstract void elementDecl(String var1, String var2) throws SAXException;

    protected void fireEscapingEvent(String name, String data) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(7, name, data);
        }
    }

    public abstract void internalEntityDecl(String var1, String var2) throws SAXException;

    public void namespaceAfterStartElement(String uri, String prefix) throws SAXException {
    }

    public abstract void processingInstruction(String var1, String var2) throws SAXException;

    public void setDoctype(String doctypeSystem, String doctypePublic) {
        this.m_doctypeSystem = doctypeSystem;
        this.m_doctypePublic = doctypePublic;
    }

    public abstract void startPrefixMapping(String var1, String var2) throws SAXException;

    private static final boolean subPartMatch(String p, String t) {
        return p == t || null != p && p.equals(t);
    }

    public abstract void addUniqueAttribute(String var1, String var2, int var3) throws SAXException;

    public abstract boolean startPrefixMapping(String var1, String var2, boolean var3) throws SAXException;

    public String getNamespaceURI(String qname, boolean isElement) {
        String prefix;
        String uri = "";
        int col = qname.lastIndexOf(58);
        String string = prefix = col > 0 ? qname.substring(0, col) : "";
        if (!("".equals(prefix) && !isElement || this.m_prefixMap == null || (uri = this.m_prefixMap.lookupNamespace(prefix)) != null || prefix.equals("xmlns"))) {
            throw new RuntimeException(XMLMessages.createXMLMessage("ER_NAMESPACE_PREFIX", new Object[]{qname.substring(0, col)}));
        }
        return uri;
    }

    public abstract void endElement(String var1, String var2, String var3) throws SAXException;

    public abstract void externalEntityDecl(String var1, String var2, String var3) throws SAXException;

    public abstract void startDTD(String var1, String var2, String var3) throws SAXException;

    public abstract void startElement(String var1, String var2, String var3) throws SAXException;

    public abstract void startElement(String var1, String var2, String var3, Attributes var4) throws SAXException;

    public void addAttribute(String uri, String localName, String rawName, String type, String value) throws SAXException {
        if (this.m_elemContext.m_startTagOpen) {
            this.addAttributeAlways(uri, localName, rawName, type, value);
        }
    }

    public void addAttributeAlways(String uri, String localName, String rawName, String type, String value) {
        int index = this.m_attributes.getIndex(rawName);
        if (index >= 0) {
            this.m_attributes.setValue(index, value);
        } else {
            this.m_attributes.addAttribute(uri, localName, rawName, type, value);
        }
    }

    public abstract void attributeDecl(String var1, String var2, String var3, String var4, String var5) throws SAXException;
}

