/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal.patterns;

import com.sun.org.apache.xml.internal.dtm.Axis;
import com.sun.org.apache.xml.internal.dtm.DTM;
import com.sun.org.apache.xml.internal.dtm.DTMAxisTraverser;
import com.sun.org.apache.xpath.internal.Expression;
import com.sun.org.apache.xpath.internal.ExpressionOwner;
import com.sun.org.apache.xpath.internal.XPathContext;
import com.sun.org.apache.xpath.internal.XPathVisitor;
import com.sun.org.apache.xpath.internal.axes.SubContextList;
import com.sun.org.apache.xpath.internal.objects.XObject;
import com.sun.org.apache.xpath.internal.patterns.NodeTest;
import java.util.Vector;
import javax.xml.transform.TransformerException;

public class StepPattern
extends NodeTest
implements SubContextList,
ExpressionOwner {
    protected int m_axis;
    String m_targetString;
    StepPattern m_relativePathPattern;
    Expression[] m_predicates;
    private static final boolean DEBUG_MATCHES = false;

    public int getAxis() {
        return this.m_axis;
    }

    public final int getPredicateCount() {
        return null == this.m_predicates ? 0 : this.m_predicates.length;
    }

    public void calcScore() {
        if (this.getPredicateCount() > 0 || null != this.m_relativePathPattern) {
            this.m_score = NodeTest.SCORE_OTHER;
        } else {
            super.calcScore();
        }
        if (null == this.m_targetString) {
            this.calcTargetString();
        }
    }

    public void calcTargetString() {
        int whatToShow = this.getWhatToShow();
        switch (whatToShow) {
            case 128: {
                this.m_targetString = "#comment";
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                this.m_targetString = "#text";
                break;
            }
            case -1: {
                this.m_targetString = "*";
                break;
            }
            case 256: 
            case 1280: {
                this.m_targetString = "/";
                break;
            }
            case 1: {
                if ("*" == this.m_name) {
                    this.m_targetString = "*";
                    break;
                }
                this.m_targetString = this.m_name;
                break;
            }
            default: {
                this.m_targetString = "*";
            }
        }
    }

    public boolean canTraverseOutsideSubtree() {
        int n = this.getPredicateCount();
        int i = 0;
        while (i < n) {
            if (this.getPredicate(i).canTraverseOutsideSubtree()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setAxis(int axis) {
        this.m_axis = axis;
    }

    public StepPattern(int whatToShow, int axis, int axisForPredicate) {
        super(whatToShow);
        this.m_axis = axis;
    }

    public Expression getExpression() {
        return this.m_relativePathPattern;
    }

    public Expression[] getPredicates() {
        return this.m_predicates;
    }

    public Expression getPredicate(int i) {
        return this.m_predicates[i];
    }

    public void setExpression(Expression exp) {
        exp.exprSetParent(this);
        this.m_relativePathPattern = (StepPattern)exp;
    }

    public boolean deepEquals(Expression expr) {
        if (!super.deepEquals(expr)) {
            return false;
        }
        StepPattern sp = (StepPattern)expr;
        if (null != this.m_predicates) {
            int n = this.m_predicates.length;
            if (null == sp.m_predicates || sp.m_predicates.length != n) {
                return false;
            }
            int i = 0;
            while (i < n) {
                if (!this.m_predicates[i].deepEquals(sp.m_predicates[i])) {
                    return false;
                }
                ++i;
            }
        } else if (null != sp.m_predicates) {
            return false;
        }
        return !(null != this.m_relativePathPattern ? !this.m_relativePathPattern.deepEquals(sp.m_relativePathPattern) : sp.m_relativePathPattern != null);
    }

    public void setPredicates(Expression[] predicates) {
        this.m_predicates = predicates;
        if (null != predicates) {
            int i = 0;
            while (i < predicates.length) {
                predicates[i].exprSetParent(this);
                ++i;
            }
        }
        this.calcScore();
    }

    public int getLastPos(XPathContext xctxt) {
        return this.getProximityPosition(xctxt, xctxt.getPredicatePos(), true);
    }

    public int getProximityPosition(XPathContext xctxt) {
        return this.getProximityPosition(xctxt, xctxt.getPredicatePos(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMatchScore(XPathContext xctxt, int context) throws TransformerException {
        xctxt.pushCurrentNode(context);
        xctxt.pushCurrentExpressionNode(context);
        try {
            XObject score = this.execute(xctxt);
            double d = score.num();
            Object var7_5 = null;
            xctxt.popCurrentNode();
            xctxt.popCurrentExpressionNode();
            return d;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            xctxt.popCurrentNode();
            xctxt.popCurrentExpressionNode();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final int getProximityPosition(XPathContext xctxt, int predPos, boolean findLast) {
        int pos = 0;
        int context = xctxt.getCurrentNode();
        DTM dtm = xctxt.getDTM(context);
        int parent = dtm.getParent(context);
        try {
            DTMAxisTraverser traverser = dtm.getAxisTraverser(3);
            int child = traverser.first(parent);
            while (true) {
                Object var20_17;
                if (-1 == child) {
                    return pos;
                }
                try {
                    xctxt.pushCurrentNode(child);
                    if (NodeTest.SCORE_NONE != super.execute(xctxt, child)) {
                        Object var18_16;
                        boolean pass = true;
                        try {
                            xctxt.pushSubContextList(this);
                            int i = 0;
                            while (true) {
                                Object var16_15;
                                if (i >= predPos) {
                                    break;
                                }
                                xctxt.pushPredicatePos(i);
                                try {
                                    Object var14_14;
                                    XObject pred;
                                    block20: {
                                        block19: {
                                            pred = this.m_predicates[i].execute(xctxt);
                                            try {
                                                if (2 != pred.getType()) break block19;
                                                if (pos + 1 == (int)pred.numWithSideEffects()) break block20;
                                                pass = false;
                                                var14_14 = null;
                                                pred.detach();
                                            }
                                            catch (Throwable throwable) {
                                                var14_14 = null;
                                                pred.detach();
                                                throw throwable;
                                            }
                                            var16_15 = null;
                                            xctxt.popPredicatePos();
                                            break;
                                        }
                                        if (pred.boolWithSideEffects()) break block20;
                                        pass = false;
                                        var14_14 = null;
                                        pred.detach();
                                        var16_15 = null;
                                        xctxt.popPredicatePos();
                                        break;
                                    }
                                    var14_14 = null;
                                    pred.detach();
                                    var16_15 = null;
                                    xctxt.popPredicatePos();
                                }
                                catch (Throwable throwable) {
                                    var16_15 = null;
                                    xctxt.popPredicatePos();
                                    throw throwable;
                                }
                                ++i;
                            }
                            var18_16 = null;
                            xctxt.popSubContextList();
                        }
                        catch (Throwable throwable) {
                            var18_16 = null;
                            xctxt.popSubContextList();
                            throw throwable;
                        }
                        if (pass) {
                            ++pos;
                        }
                        if (!findLast && child == context) {
                            int n = pos;
                            var20_17 = null;
                            xctxt.popCurrentNode();
                            return n;
                        }
                    }
                    var20_17 = null;
                    xctxt.popCurrentNode();
                }
                catch (Throwable throwable) {
                    var20_17 = null;
                    xctxt.popCurrentNode();
                    throw throwable;
                }
                child = traverser.next(parent, child);
            }
        }
        catch (TransformerException se) {
            throw new RuntimeException(se.getMessage());
        }
    }

    protected void callSubtreeVisitors(XPathVisitor visitor) {
        if (null != this.m_predicates) {
            int n = this.m_predicates.length;
            int i = 0;
            while (i < n) {
                PredOwner predOwner = new PredOwner(i);
                if (visitor.visitPredicate(predOwner, this.m_predicates[i])) {
                    this.m_predicates[i].callVisitors(predOwner, visitor);
                }
                ++i;
            }
        }
        if (null != this.m_relativePathPattern) {
            this.m_relativePathPattern.callVisitors(this, visitor);
        }
    }

    public StepPattern getRelativePathPattern() {
        return this.m_relativePathPattern;
    }

    public void setRelativePathPattern(StepPattern expr) {
        this.m_relativePathPattern = expr;
        expr.exprSetParent(this);
        this.calcScore();
    }

    public String getTargetString() {
        return this.m_targetString;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        StepPattern pat = this;
        while (pat != null) {
            if (pat != this) {
                buf.append("/");
            }
            buf.append(Axis.names[pat.m_axis]);
            buf.append("::");
            if (20480 == pat.m_whatToShow) {
                buf.append("doc()");
            } else if (65536 == pat.m_whatToShow) {
                buf.append("function()");
            } else if (-1 == pat.m_whatToShow) {
                buf.append("node()");
            } else if (4 == pat.m_whatToShow) {
                buf.append("text()");
            } else if (64 == pat.m_whatToShow) {
                buf.append("processing-instruction(");
                if (null != pat.m_name) {
                    buf.append(pat.m_name);
                }
                buf.append(")");
            } else if (128 == pat.m_whatToShow) {
                buf.append("comment()");
            } else if (null != pat.m_name) {
                if (2 == pat.m_whatToShow) {
                    buf.append("@");
                }
                if (null != pat.m_namespace) {
                    buf.append("{");
                    buf.append(pat.m_namespace);
                    buf.append("}");
                }
                buf.append(pat.m_name);
            } else if (2 == pat.m_whatToShow) {
                buf.append("@");
            } else if (1280 == pat.m_whatToShow) {
                buf.append("doc-root()");
            } else {
                buf.append("?" + Integer.toHexString(pat.m_whatToShow));
            }
            if (null != pat.m_predicates) {
                int i = 0;
                while (i < pat.m_predicates.length) {
                    buf.append("[");
                    buf.append(pat.m_predicates[i]);
                    buf.append("]");
                    ++i;
                }
            }
            pat = pat.m_relativePathPattern;
        }
        return buf.toString();
    }

    public void fixupVariables(Vector vars, int globalsSize) {
        super.fixupVariables(vars, globalsSize);
        if (null != this.m_predicates) {
            int i = 0;
            while (i < this.m_predicates.length) {
                this.m_predicates[i].fixupVariables(vars, globalsSize);
                ++i;
            }
        }
        if (null != this.m_relativePathPattern) {
            this.m_relativePathPattern.fixupVariables(vars, globalsSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean checkProximityPosition(XPathContext xctxt, int predPos, DTM dtm, int context, int pos) {
        try {
            DTMAxisTraverser traverser = dtm.getAxisTraverser(12);
            int child = traverser.first(context);
            while (-1 != child) {
                Object var18_15;
                try {
                    xctxt.pushCurrentNode(child);
                    if (NodeTest.SCORE_NONE != super.execute(xctxt, child)) {
                        Object var16_14;
                        boolean pass = true;
                        try {
                            xctxt.pushSubContextList(this);
                            int i = 0;
                            while (true) {
                                Object var14_13;
                                if (i >= predPos) {
                                    break;
                                }
                                xctxt.pushPredicatePos(i);
                                try {
                                    Object var12_12;
                                    XObject pred;
                                    block18: {
                                        pred = this.m_predicates[i].execute(xctxt);
                                        try {
                                            if (2 == pred.getType()) {
                                                throw new Error("Why: Should never have been called");
                                            }
                                            if (pred.boolWithSideEffects()) break block18;
                                            pass = false;
                                            var12_12 = null;
                                            pred.detach();
                                        }
                                        catch (Throwable throwable) {
                                            var12_12 = null;
                                            pred.detach();
                                            throw throwable;
                                        }
                                        var14_13 = null;
                                        xctxt.popPredicatePos();
                                        break;
                                    }
                                    var12_12 = null;
                                    pred.detach();
                                    var14_13 = null;
                                    xctxt.popPredicatePos();
                                }
                                catch (Throwable throwable) {
                                    var14_13 = null;
                                    xctxt.popPredicatePos();
                                    throw throwable;
                                }
                                ++i;
                            }
                            var16_14 = null;
                            xctxt.popSubContextList();
                        }
                        catch (Throwable throwable) {
                            var16_14 = null;
                            xctxt.popSubContextList();
                            throw throwable;
                        }
                        if (pass) {
                            --pos;
                        }
                        if (pos < 1) {
                            boolean bl = false;
                            var18_15 = null;
                            xctxt.popCurrentNode();
                            return bl;
                        }
                    }
                    var18_15 = null;
                    xctxt.popCurrentNode();
                }
                catch (Throwable throwable) {
                    var18_15 = null;
                    xctxt.popCurrentNode();
                    throw throwable;
                }
                child = traverser.next(context, child);
            }
        }
        catch (TransformerException se) {
            throw new RuntimeException(se.getMessage());
        }
        if (pos != 1) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected final boolean executePredicates(XPathContext xctxt, DTM dtm, int currentNode) throws TransformerException {
        result = true;
        positionAlreadySeen = false;
        n = this.getPredicateCount();
        try {
            xctxt.pushSubContextList(this);
            i = 0;
            while (i < n) {
                xctxt.pushPredicatePos(i);
                try {
                    block10: {
                        pred = this.m_predicates[i].execute(xctxt);
                        if (2 != pred.getType()) ** GOTO lbl38
                        pos = (int)pred.num();
                        if (!positionAlreadySeen) break block10;
                        result = pos == 1;
                        var11_10 = null;
                        pred.detach();
                        var13_11 = null;
                        xctxt.popPredicatePos();
                        break;
                    }
                    positionAlreadySeen = true;
                    if (this.checkProximityPosition(xctxt, i, dtm, currentNode, pos)) break block11;
                    result = false;
                    var11_10 = null;
                    pred.detach();
                }
                catch (Throwable var12_13) {
                    var13_11 = null;
                    xctxt.popPredicatePos();
                    throw var12_13;
                }
                var13_11 = null;
                xctxt.popPredicatePos();
                {
                    block11: {
                        break;
                    }
                    break block12;
lbl38:
                    // 1 sources

                    if (pred.boolWithSideEffects()) break block12;
                    result = false;
                    var11_10 = null;
                    pred.detach();
                }
                var13_11 = null;
                xctxt.popPredicatePos();
                {
                    block12: {
                        break;
                    }
                    try {
                        var11_10 = null;
                        pred.detach();
                    }
                    catch (Throwable var10_12) {
                        var11_10 = null;
                        pred.detach();
                        throw var10_12;
                    }
                }
                var13_11 = null;
                xctxt.popPredicatePos();
                ++i;
            }
            var15_14 = null;
            xctxt.popSubContextList();
        }
        catch (Throwable var14_16) {
            var15_15 = null;
            xctxt.popSubContextList();
            throw var14_16;
        }
        return result;
    }

    public void callVisitors(ExpressionOwner owner, XPathVisitor visitor) {
        if (visitor.visitMatchPattern(owner, this)) {
            this.callSubtreeVisitors(visitor);
        }
    }

    public XObject execute(XPathContext xctxt) throws TransformerException {
        return this.execute(xctxt, xctxt.getCurrentNode());
    }

    public XObject execute(XPathContext xctxt, int currentNode) throws TransformerException {
        DTM dtm = xctxt.getDTM(currentNode);
        if (dtm != null) {
            int expType = dtm.getExpandedTypeID(currentNode);
            return this.execute(xctxt, currentNode, dtm, expType);
        }
        return NodeTest.SCORE_NONE;
    }

    public StepPattern(int whatToShow, String namespace, String name, int axis, int axisForPredicate) {
        super(whatToShow, namespace, name);
        this.m_axis = axis;
    }

    public XObject execute(XPathContext xctxt, int currentNode, DTM dtm, int expType) throws TransformerException {
        if (this.m_whatToShow == 65536) {
            if (null != this.m_relativePathPattern) {
                return this.m_relativePathPattern.execute(xctxt);
            }
            return NodeTest.SCORE_NONE;
        }
        XObject score = super.execute(xctxt, currentNode, dtm, expType);
        if (score == NodeTest.SCORE_NONE) {
            return NodeTest.SCORE_NONE;
        }
        if (this.getPredicateCount() != 0 && !this.executePredicates(xctxt, dtm, currentNode)) {
            return NodeTest.SCORE_NONE;
        }
        if (null != this.m_relativePathPattern) {
            return this.m_relativePathPattern.executeRelativePathPattern(xctxt, dtm, currentNode);
        }
        return score;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final XObject executeRelativePathPattern(XPathContext xctxt, DTM dtm, int currentNode) throws TransformerException {
        XObject score = NodeTest.SCORE_NONE;
        int context = currentNode;
        DTMAxisTraverser traverser = dtm.getAxisTraverser(this.m_axis);
        int relative = traverser.first(context);
        while (-1 != relative) {
            Object var9_8;
            try {
                xctxt.pushCurrentNode(relative);
                score = this.execute(xctxt);
                if (score != NodeTest.SCORE_NONE) {
                    var9_8 = null;
                    xctxt.popCurrentNode();
                    break;
                }
                var9_8 = null;
                xctxt.popCurrentNode();
            }
            catch (Throwable throwable) {
                var9_8 = null;
                xctxt.popCurrentNode();
                throw throwable;
            }
            relative = traverser.next(context, relative);
        }
        return score;
    }

    class PredOwner
    implements ExpressionOwner {
        int m_index;

        public Expression getExpression() {
            return StepPattern.this.m_predicates[this.m_index];
        }

        public void setExpression(Expression exp) {
            exp.exprSetParent(StepPattern.this);
            StepPattern.this.m_predicates[this.m_index] = exp;
        }

        PredOwner(int index) {
            this.m_index = index;
        }
    }
}

