/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.xs.traversers;

import com.sun.org.apache.xerces.internal.impl.dv.InvalidDatatypeValueException;
import com.sun.org.apache.xerces.internal.impl.dv.ValidationContext;
import com.sun.org.apache.xerces.internal.impl.dv.XSFacets;
import com.sun.org.apache.xerces.internal.impl.dv.XSSimpleType;
import com.sun.org.apache.xerces.internal.impl.validation.ValidationState;
import com.sun.org.apache.xerces.internal.impl.xs.SchemaGrammar;
import com.sun.org.apache.xerces.internal.impl.xs.SchemaSymbols;
import com.sun.org.apache.xerces.internal.impl.xs.XSAnnotationImpl;
import com.sun.org.apache.xerces.internal.impl.xs.XSAttributeGroupDecl;
import com.sun.org.apache.xerces.internal.impl.xs.XSAttributeUseImpl;
import com.sun.org.apache.xerces.internal.impl.xs.XSComplexTypeDecl;
import com.sun.org.apache.xerces.internal.impl.xs.XSElementDecl;
import com.sun.org.apache.xerces.internal.impl.xs.XSParticleDecl;
import com.sun.org.apache.xerces.internal.impl.xs.XSWildcardDecl;
import com.sun.org.apache.xerces.internal.impl.xs.traversers.XSAttributeChecker;
import com.sun.org.apache.xerces.internal.impl.xs.traversers.XSDHandler;
import com.sun.org.apache.xerces.internal.impl.xs.traversers.XSDocumentInfo;
import com.sun.org.apache.xerces.internal.impl.xs.util.XInt;
import com.sun.org.apache.xerces.internal.impl.xs.util.XSObjectListImpl;
import com.sun.org.apache.xerces.internal.util.DOMUtil;
import com.sun.org.apache.xerces.internal.util.NamespaceSupport;
import com.sun.org.apache.xerces.internal.util.SymbolTable;
import com.sun.org.apache.xerces.internal.xni.QName;
import com.sun.org.apache.xerces.internal.xs.XSObjectList;
import com.sun.org.apache.xerces.internal.xs.XSTypeDefinition;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

abstract class XSDAbstractTraverser {
    protected static final String NO_NAME = "(no name)";
    protected static final int NOT_ALL_CONTEXT = 0;
    protected static final int PROCESSING_ALL_EL = 1;
    protected static final int GROUP_REF_WITH_ALL = 2;
    protected static final int CHILD_OF_GROUP = 4;
    protected static final int PROCESSING_ALL_GP = 8;
    protected XSDHandler fSchemaHandler = null;
    protected SymbolTable fSymbolTable = null;
    protected XSAttributeChecker fAttrChecker = null;
    ValidationState fValidationState = new ValidationState();
    private static final XSSimpleType fQNameDV = (XSSimpleType)SchemaGrammar.SG_SchemaNS.getGlobalTypeDecl("QName");
    private StringBuffer fPattern = new StringBuffer();
    private final XSFacets xsFacets = new XSFacets();

    private boolean containsQName(XSSimpleType type) {
        if (type.getVariety() == 1) {
            short primitive = type.getPrimitiveKind();
            return primitive == 18 || primitive == 19;
        }
        if (type.getVariety() == 2) {
            return this.containsQName((XSSimpleType)type.getItemType());
        }
        if (type.getVariety() == 3) {
            XSObjectList members = type.getMemberTypes();
            int i = 0;
            while (i < members.getLength()) {
                if (this.containsQName((XSSimpleType)members.item(i))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    void reset(SymbolTable symbolTable) {
        this.fSymbolTable = symbolTable;
        this.fValidationState.setExtraChecking(false);
        this.fValidationState.setSymbolTable(symbolTable);
    }

    XSDAbstractTraverser(XSDHandler handler, XSAttributeChecker attrChecker) {
        this.fSchemaHandler = handler;
        this.fAttrChecker = attrChecker;
    }

    private static String processAttValue(String original) {
        StringBuffer newVal = new StringBuffer(original.length());
        int i = 0;
        while (i < original.length()) {
            char currChar = original.charAt(i);
            if (currChar == '\"') {
                newVal.append("&quot;");
            } else if (currChar == '>') {
                newVal.append("&gt;");
            } else if (currChar == '&') {
                newVal.append("&amp;");
            } else {
                newVal.append(currChar);
            }
            ++i;
        }
        return newVal.toString();
    }

    void checkNotationType(String refName, XSTypeDefinition typeDecl, Element elem) {
        if (typeDecl.getTypeCategory() == 16 && ((XSSimpleType)typeDecl).getVariety() == 1 && ((XSSimpleType)typeDecl).getPrimitiveKind() == 19 && (((XSSimpleType)typeDecl).getDefinedFacets() & 0x800) == 0) {
            this.reportSchemaError("enumeration-required-notation", new Object[]{typeDecl.getName(), refName, DOMUtil.getLocalName(elem)}, elem);
        }
    }

    void reportSchemaError(String key, Object[] args, Element ele) {
        this.fSchemaHandler.reportSchemaError(key, args, ele);
    }

    XSAnnotationImpl traverseAnnotationDecl(Element annotationDecl, Object[] parentAttrs, boolean isGlobal, XSDocumentInfo schemaDoc) {
        Object[] attrValues = this.fAttrChecker.checkAttributes(annotationDecl, isGlobal, schemaDoc);
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        String contents = null;
        Element child = DOMUtil.getFirstChildElement(annotationDecl);
        while (child != null) {
            String name = DOMUtil.getLocalName(child);
            if (!name.equals(SchemaSymbols.ELT_APPINFO) && !name.equals(SchemaSymbols.ELT_DOCUMENTATION)) {
                this.reportSchemaError("src-annotation", new Object[]{name}, child);
            } else {
                Node textContent = child.getFirstChild();
                if (textContent != null && textContent.getNodeType() == 3) {
                    contents = ((Text)textContent).getData();
                }
            }
            attrValues = this.fAttrChecker.checkAttributes(child, true, schemaDoc);
            this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
            child = DOMUtil.getNextSiblingElement(child);
        }
        if (contents == null) {
            return null;
        }
        SchemaGrammar grammar = this.fSchemaHandler.getGrammar(schemaDoc.fTargetNamespace);
        Vector annotationLocalAttrs = (Vector)parentAttrs[XSAttributeChecker.ATTIDX_NONSCHEMA];
        if (annotationLocalAttrs != null && !annotationLocalAttrs.isEmpty()) {
            StringBuffer localStrBuffer = new StringBuffer(64);
            localStrBuffer.append(" ");
            int i = 0;
            while (i < annotationLocalAttrs.size()) {
                String localpart;
                String prefix;
                String rawname;
                int colonIndex;
                if ((colonIndex = (rawname = (String)annotationLocalAttrs.elementAt(i++)).indexOf(58)) == -1) {
                    prefix = "";
                    localpart = rawname;
                } else {
                    prefix = rawname.substring(0, colonIndex);
                    localpart = rawname.substring(colonIndex + 1);
                }
                String uri = schemaDoc.fNamespaceSupport.getURI(prefix.intern());
                if (!annotationDecl.getAttributeNS(uri, localpart).equals("")) {
                    ++i;
                    continue;
                }
                localStrBuffer.append(rawname).append("=\"");
                String value = (String)annotationLocalAttrs.elementAt(i++);
                value = XSDAbstractTraverser.processAttValue(value);
                localStrBuffer.append(value).append("\" ");
            }
            StringBuffer contentBuffer = new StringBuffer(contents.length() + localStrBuffer.length());
            int annotationTokenEnd = contents.indexOf(SchemaSymbols.ELT_ANNOTATION);
            if (annotationTokenEnd == -1) {
                return null;
            }
            contentBuffer.append(contents.substring(0, annotationTokenEnd += SchemaSymbols.ELT_ANNOTATION.length()));
            contentBuffer.append(localStrBuffer.toString());
            contentBuffer.append(contents.substring(annotationTokenEnd, contents.length()));
            return new XSAnnotationImpl(contentBuffer.toString(), grammar);
        }
        return new XSAnnotationImpl(contents, grammar);
    }

    protected XSParticleDecl checkOccurrences(XSParticleDecl particle, String particleName, Element parent, int allContextFlags, long defaultVals) {
        boolean isGroupChild;
        int min = particle.fMinOccurs;
        int max = particle.fMaxOccurs;
        boolean defaultMin = (defaultVals & (long)(1 << XSAttributeChecker.ATTIDX_MINOCCURS)) != 0L;
        boolean defaultMax = (defaultVals & (long)(1 << XSAttributeChecker.ATTIDX_MAXOCCURS)) != 0L;
        boolean processingAllEl = (allContextFlags & 1) != 0;
        boolean processingAllGP = (allContextFlags & 8) != 0;
        boolean groupRefWithAll = (allContextFlags & 2) != 0;
        boolean bl = isGroupChild = (allContextFlags & 4) != 0;
        if (isGroupChild) {
            Object[] args;
            if (!defaultMin) {
                args = new Object[]{particleName, "minOccurs"};
                this.reportSchemaError("s4s-att-not-allowed", args, parent);
                min = 1;
            }
            if (!defaultMax) {
                args = new Object[]{particleName, "maxOccurs"};
                this.reportSchemaError("s4s-att-not-allowed", args, parent);
                max = 1;
            }
        }
        if (min == 0 && max == 0) {
            particle.fType = 0;
            return null;
        }
        if (processingAllEl) {
            if (max != 1) {
                this.reportSchemaError("cos-all-limited.2", new Object[]{new Integer(max), ((XSElementDecl)particle.fValue).getName()}, parent);
                max = 1;
                if (min > 1) {
                    min = 1;
                }
            }
        } else if ((processingAllGP || groupRefWithAll) && max != 1) {
            this.reportSchemaError("cos-all-limited.1.2", null, parent);
            if (min > 1) {
                min = 1;
            }
            max = 1;
        }
        particle.fMaxOccurs = min;
        particle.fMaxOccurs = max;
        return particle;
    }

    FacetInfo traverseFacets(Element content, XSSimpleType baseValidator, XSDocumentInfo schemaDoc) {
        int facetsPresent = 0;
        short facetsFixed = 0;
        boolean hasQName = this.containsQName(baseValidator);
        Vector<String> enumData = null;
        XSObjectListImpl enumAnnotations = null;
        XSObjectListImpl patternAnnotations = null;
        Vector<NamespaceSupport> enumNSDecls = hasQName ? new Vector<NamespaceSupport>() : null;
        int currentFacet = 0;
        this.xsFacets.reset();
        while (content != null) {
            Element child;
            Object[] attrs = null;
            String facet = DOMUtil.getLocalName(content);
            if (facet.equals(SchemaSymbols.ELT_ENUMERATION)) {
                Element child2;
                attrs = this.fAttrChecker.checkAttributes(content, false, schemaDoc, hasQName);
                String enumVal = (String)attrs[XSAttributeChecker.ATTIDX_VALUE];
                NamespaceSupport nsDecls = (NamespaceSupport)attrs[XSAttributeChecker.ATTIDX_ENUMNSDECLS];
                if (baseValidator.getVariety() == 1 && baseValidator.getPrimitiveKind() == 19) {
                    schemaDoc.fValidationContext.setNamespaceSupport(nsDecls);
                    try {
                        QName temp = (QName)fQNameDV.validate(enumVal, (ValidationContext)schemaDoc.fValidationContext, null);
                        this.fSchemaHandler.getGlobalDecl(schemaDoc, 6, temp, content);
                    }
                    catch (InvalidDatatypeValueException ex) {
                        this.reportSchemaError(ex.getKey(), ex.getArgs(), content);
                    }
                    schemaDoc.fValidationContext.setNamespaceSupport(schemaDoc.fNamespaceSupport);
                }
                if (enumData == null) {
                    enumData = new Vector<String>();
                    enumAnnotations = new XSObjectListImpl();
                }
                enumData.addElement(enumVal);
                enumAnnotations.add(null);
                if (hasQName) {
                    enumNSDecls.addElement(nsDecls);
                }
                if ((child2 = DOMUtil.getFirstChildElement(content)) != null) {
                    if (DOMUtil.getLocalName(child2).equals(SchemaSymbols.ELT_ANNOTATION)) {
                        enumAnnotations.add(enumAnnotations.getLength() - 1, this.traverseAnnotationDecl(child2, attrs, false, schemaDoc));
                        child2 = DOMUtil.getNextSiblingElement(child2);
                    }
                    if (child2 != null && DOMUtil.getLocalName(child2).equals(SchemaSymbols.ELT_ANNOTATION)) {
                        this.reportSchemaError("s4s-elt-must-match.1", new Object[]{"enumeration", "(annotation?)", DOMUtil.getLocalName(child2)}, child2);
                    }
                }
            } else if (facet.equals(SchemaSymbols.ELT_PATTERN)) {
                attrs = this.fAttrChecker.checkAttributes(content, false, schemaDoc);
                if (this.fPattern.length() == 0) {
                    this.fPattern.append((String)attrs[XSAttributeChecker.ATTIDX_VALUE]);
                } else {
                    this.fPattern.append("|");
                    this.fPattern.append((String)attrs[XSAttributeChecker.ATTIDX_VALUE]);
                }
                child = DOMUtil.getFirstChildElement(content);
                if (child != null) {
                    if (DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_ANNOTATION)) {
                        if (patternAnnotations == null) {
                            patternAnnotations = new XSObjectListImpl();
                        }
                        patternAnnotations.add(this.traverseAnnotationDecl(child, attrs, false, schemaDoc));
                        child = DOMUtil.getNextSiblingElement(child);
                    }
                    if (child != null && DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_ANNOTATION)) {
                        this.reportSchemaError("s4s-elt-must-match.1", new Object[]{"pattern", "(annotation?)", DOMUtil.getLocalName(child)}, child);
                    }
                }
            } else {
                if (facet.equals(SchemaSymbols.ELT_MINLENGTH)) {
                    currentFacet = 2;
                } else if (facet.equals(SchemaSymbols.ELT_MAXLENGTH)) {
                    currentFacet = 4;
                } else if (facet.equals(SchemaSymbols.ELT_MAXEXCLUSIVE)) {
                    currentFacet = 64;
                } else if (facet.equals(SchemaSymbols.ELT_MAXINCLUSIVE)) {
                    currentFacet = 32;
                } else if (facet.equals(SchemaSymbols.ELT_MINEXCLUSIVE)) {
                    currentFacet = 128;
                } else if (facet.equals(SchemaSymbols.ELT_MININCLUSIVE)) {
                    currentFacet = 256;
                } else if (facet.equals(SchemaSymbols.ELT_TOTALDIGITS)) {
                    currentFacet = 512;
                } else if (facet.equals(SchemaSymbols.ELT_FRACTIONDIGITS)) {
                    currentFacet = 1024;
                } else if (facet.equals(SchemaSymbols.ELT_WHITESPACE)) {
                    currentFacet = 16;
                } else {
                    if (!facet.equals(SchemaSymbols.ELT_LENGTH)) break;
                    currentFacet = 1;
                }
                attrs = this.fAttrChecker.checkAttributes(content, false, schemaDoc);
                if ((facetsPresent & currentFacet) != 0) {
                    this.reportSchemaError("src-single-facet-value", new Object[]{facet}, content);
                } else if (attrs[XSAttributeChecker.ATTIDX_VALUE] != null) {
                    facetsPresent = (short)(facetsPresent | currentFacet);
                    if (((Boolean)attrs[XSAttributeChecker.ATTIDX_FIXED]).booleanValue()) {
                        facetsFixed = (short)(facetsFixed | currentFacet);
                    }
                    switch (currentFacet) {
                        case 2: {
                            this.xsFacets.minLength = ((XInt)attrs[XSAttributeChecker.ATTIDX_VALUE]).intValue();
                            break;
                        }
                        case 4: {
                            this.xsFacets.maxLength = ((XInt)attrs[XSAttributeChecker.ATTIDX_VALUE]).intValue();
                            break;
                        }
                        case 64: {
                            this.xsFacets.maxExclusive = (String)attrs[XSAttributeChecker.ATTIDX_VALUE];
                            break;
                        }
                        case 32: {
                            this.xsFacets.maxInclusive = (String)attrs[XSAttributeChecker.ATTIDX_VALUE];
                            break;
                        }
                        case 128: {
                            this.xsFacets.minExclusive = (String)attrs[XSAttributeChecker.ATTIDX_VALUE];
                            break;
                        }
                        case 256: {
                            this.xsFacets.minInclusive = (String)attrs[XSAttributeChecker.ATTIDX_VALUE];
                            break;
                        }
                        case 512: {
                            this.xsFacets.totalDigits = ((XInt)attrs[XSAttributeChecker.ATTIDX_VALUE]).intValue();
                            break;
                        }
                        case 1024: {
                            this.xsFacets.fractionDigits = ((XInt)attrs[XSAttributeChecker.ATTIDX_VALUE]).intValue();
                            break;
                        }
                        case 16: {
                            this.xsFacets.whiteSpace = ((XInt)attrs[XSAttributeChecker.ATTIDX_VALUE]).shortValue();
                            break;
                        }
                        case 1: {
                            this.xsFacets.length = ((XInt)attrs[XSAttributeChecker.ATTIDX_VALUE]).intValue();
                        }
                    }
                }
                child = DOMUtil.getFirstChildElement(content);
                if (child != null) {
                    if (DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_ANNOTATION)) {
                        XSAnnotationImpl annotation = this.traverseAnnotationDecl(child, attrs, false, schemaDoc);
                        switch (currentFacet) {
                            case 2: {
                                this.xsFacets.minLengthAnnotation = annotation;
                                break;
                            }
                            case 4: {
                                this.xsFacets.maxLengthAnnotation = annotation;
                                break;
                            }
                            case 64: {
                                this.xsFacets.maxExclusiveAnnotation = annotation;
                                break;
                            }
                            case 32: {
                                this.xsFacets.maxInclusiveAnnotation = annotation;
                                break;
                            }
                            case 128: {
                                this.xsFacets.minExclusiveAnnotation = annotation;
                                break;
                            }
                            case 256: {
                                this.xsFacets.minInclusiveAnnotation = annotation;
                                break;
                            }
                            case 512: {
                                this.xsFacets.totalDigitsAnnotation = annotation;
                                break;
                            }
                            case 1024: {
                                this.xsFacets.fractionDigitsAnnotation = annotation;
                                break;
                            }
                            case 16: {
                                this.xsFacets.whiteSpaceAnnotation = annotation;
                                break;
                            }
                            case 1: {
                                this.xsFacets.lengthAnnotation = annotation;
                            }
                        }
                        child = DOMUtil.getNextSiblingElement(child);
                    }
                    if (child != null && DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_ANNOTATION)) {
                        this.reportSchemaError("s4s-elt-must-match.1", new Object[]{facet, "(annotation?)", DOMUtil.getLocalName(child)}, child);
                    }
                }
            }
            this.fAttrChecker.returnAttrArray(attrs, schemaDoc);
            content = DOMUtil.getNextSiblingElement(content);
        }
        if (enumData != null) {
            facetsPresent = (short)(facetsPresent | 0x800);
            this.xsFacets.enumeration = enumData;
            this.xsFacets.enumNSDecls = enumNSDecls;
            this.xsFacets.enumAnnotations = enumAnnotations;
        }
        if (this.fPattern.length() != 0) {
            facetsPresent = (short)(facetsPresent | 8);
            this.xsFacets.pattern = this.fPattern.toString();
            this.xsFacets.patternAnnotations = patternAnnotations;
        }
        this.fPattern.setLength(0);
        FacetInfo fi = new FacetInfo();
        fi.facetdata = this.xsFacets;
        fi.nodeAfterFacets = content;
        fi.fPresentFacets = (short)facetsPresent;
        fi.fFixedFacets = facetsFixed;
        return fi;
    }

    Element traverseAttrsAndAttrGrps(Element firstAttr, XSAttributeGroupDecl attrGrp, XSDocumentInfo schemaDoc, SchemaGrammar grammar, XSComplexTypeDecl enclosingCT) {
        String name;
        String code;
        String childName;
        Element child = null;
        XSAttributeGroupDecl tempAttrGrp = null;
        XSAttributeUseImpl tempAttrUse = null;
        child = firstAttr;
        while (child != null) {
            childName = DOMUtil.getLocalName(child);
            if (childName.equals(SchemaSymbols.ELT_ATTRIBUTE)) {
                tempAttrUse = this.fSchemaHandler.fAttributeTraverser.traverseLocal(child, schemaDoc, grammar, enclosingCT);
                if (tempAttrUse == null) break;
                if (attrGrp.getAttributeUse(tempAttrUse.fAttrDecl.getNamespace(), tempAttrUse.fAttrDecl.getName()) == null) {
                    String idName = attrGrp.addAttributeUse(tempAttrUse);
                    if (idName != null) {
                        code = enclosingCT == null ? "ag-props-correct.3" : "ct-props-correct.5";
                        name = enclosingCT == null ? attrGrp.fName : enclosingCT.getName();
                        this.reportSchemaError(code, new Object[]{name, tempAttrUse.fAttrDecl.getName(), idName}, child);
                    }
                } else {
                    String code2 = enclosingCT == null ? "ag-props-correct.2" : "ct-props-correct.4";
                    String name2 = enclosingCT == null ? attrGrp.fName : enclosingCT.getName();
                    this.reportSchemaError(code2, new Object[]{name2, tempAttrUse.fAttrDecl.getName()}, child);
                }
            } else {
                String name3;
                String code3;
                if (!childName.equals(SchemaSymbols.ELT_ATTRIBUTEGROUP) || (tempAttrGrp = this.fSchemaHandler.fAttributeGroupTraverser.traverseLocal(child, schemaDoc, grammar)) == null) break;
                XSObjectList attrUseS = tempAttrGrp.getAttributeUses();
                Object existingAttrUse = null;
                int attrCount = attrUseS.getLength();
                int i = 0;
                while (i < attrCount) {
                    XSAttributeUseImpl oneAttrUse = (XSAttributeUseImpl)attrUseS.item(i);
                    if (existingAttrUse == attrGrp.getAttributeUse(oneAttrUse.fAttrDecl.getNamespace(), oneAttrUse.fAttrDecl.getName())) {
                        String idName = attrGrp.addAttributeUse(oneAttrUse);
                        if (idName != null) {
                            String code4 = enclosingCT == null ? "ag-props-correct.3" : "ct-props-correct.5";
                            String name4 = enclosingCT == null ? attrGrp.fName : enclosingCT.getName();
                            this.reportSchemaError(code4, new Object[]{name4, oneAttrUse.fAttrDecl.getName(), idName}, child);
                        }
                    } else {
                        code3 = enclosingCT == null ? "ag-props-correct.2" : "ct-props-correct.4";
                        name3 = enclosingCT == null ? attrGrp.fName : enclosingCT.getName();
                        this.reportSchemaError(code3, new Object[]{name3, oneAttrUse.fAttrDecl.getName()}, child);
                    }
                    ++i;
                }
                if (tempAttrGrp.fAttributeWC != null) {
                    if (attrGrp.fAttributeWC == null) {
                        attrGrp.fAttributeWC = tempAttrGrp.fAttributeWC;
                    } else {
                        attrGrp.fAttributeWC = attrGrp.fAttributeWC.performIntersectionWith(tempAttrGrp.fAttributeWC, attrGrp.fAttributeWC.fProcessContents);
                        if (attrGrp.fAttributeWC == null) {
                            code3 = enclosingCT == null ? "src-attribute_group.2" : "src-ct.4";
                            name3 = enclosingCT == null ? attrGrp.fName : enclosingCT.getName();
                            this.reportSchemaError(code3, new Object[]{name3}, child);
                        }
                    }
                }
            }
            child = DOMUtil.getNextSiblingElement(child);
        }
        if (child != null && (childName = DOMUtil.getLocalName(child)).equals(SchemaSymbols.ELT_ANYATTRIBUTE)) {
            XSWildcardDecl tempAttrWC = this.fSchemaHandler.fWildCardTraverser.traverseAnyAttribute(child, schemaDoc, grammar);
            if (attrGrp.fAttributeWC == null) {
                attrGrp.fAttributeWC = tempAttrWC;
            } else {
                attrGrp.fAttributeWC = tempAttrWC.performIntersectionWith(attrGrp.fAttributeWC, tempAttrWC.fProcessContents);
                if (attrGrp.fAttributeWC == null) {
                    code = enclosingCT == null ? "src-attribute_group.2" : "src-ct.4";
                    name = enclosingCT == null ? attrGrp.fName : enclosingCT.getName();
                    this.reportSchemaError(code, new Object[]{name}, child);
                }
            }
            child = DOMUtil.getNextSiblingElement(child);
        }
        return child;
    }

    class FacetInfo {
        XSFacets facetdata;
        Element nodeAfterFacets;
        short fPresentFacets;
        short fFixedFacets;

        FacetInfo() {
        }
    }
}

