/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.parsers;

import com.sun.org.apache.xerces.internal.util.ParserConfigurationSettings;
import com.sun.org.apache.xerces.internal.util.SymbolTable;
import com.sun.org.apache.xerces.internal.xni.XMLDTDContentModelHandler;
import com.sun.org.apache.xerces.internal.xni.XMLDTDHandler;
import com.sun.org.apache.xerces.internal.xni.XMLDocumentHandler;
import com.sun.org.apache.xerces.internal.xni.XNIException;
import com.sun.org.apache.xerces.internal.xni.parser.XMLComponent;
import com.sun.org.apache.xerces.internal.xni.parser.XMLComponentManager;
import com.sun.org.apache.xerces.internal.xni.parser.XMLConfigurationException;
import com.sun.org.apache.xerces.internal.xni.parser.XMLDocumentSource;
import com.sun.org.apache.xerces.internal.xni.parser.XMLEntityResolver;
import com.sun.org.apache.xerces.internal.xni.parser.XMLErrorHandler;
import com.sun.org.apache.xerces.internal.xni.parser.XMLInputSource;
import com.sun.org.apache.xerces.internal.xni.parser.XMLParserConfiguration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;

public abstract class BasicParserConfiguration
extends ParserConfigurationSettings
implements XMLParserConfiguration {
    protected static final String VALIDATION = "http://xml.org/sax/features/validation";
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    protected static final String EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    protected static final String EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    protected static final String XML_STRING = "http://xml.org/sax/properties/xml-string";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String ERROR_HANDLER = "http://apache.org/xml/properties/internal/error-handler";
    protected static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    protected SymbolTable fSymbolTable;
    protected Locale fLocale;
    protected ArrayList fComponents = new ArrayList();
    protected XMLDocumentHandler fDocumentHandler;
    protected XMLDTDHandler fDTDHandler;
    protected XMLDTDContentModelHandler fDTDContentModelHandler;
    protected XMLDocumentSource fLastComponent;

    protected BasicParserConfiguration() {
        this(null, null);
    }

    protected void reset() throws XNIException {
        int count = this.fComponents.size();
        int i = 0;
        while (i < count) {
            XMLComponent c = (XMLComponent)this.fComponents.get(i);
            c.reset(this);
            ++i;
        }
    }

    protected BasicParserConfiguration(SymbolTable symbolTable) {
        this(symbolTable, null);
    }

    public XMLDTDContentModelHandler getDTDContentModelHandler() {
        return this.fDTDContentModelHandler;
    }

    public void setDTDContentModelHandler(XMLDTDContentModelHandler handler) {
        this.fDTDContentModelHandler = handler;
    }

    public XMLDTDHandler getDTDHandler() {
        return this.fDTDHandler;
    }

    public void setDTDHandler(XMLDTDHandler dtdHandler) {
        this.fDTDHandler = dtdHandler;
    }

    public XMLDocumentHandler getDocumentHandler() {
        return this.fDocumentHandler;
    }

    public void setDocumentHandler(XMLDocumentHandler documentHandler) {
        this.fDocumentHandler = documentHandler;
        if (this.fLastComponent != null) {
            this.fLastComponent.setDocumentHandler(this.fDocumentHandler);
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.setDocumentSource(this.fLastComponent);
            }
        }
    }

    protected void addComponent(XMLComponent component) {
        int i;
        if (this.fComponents.contains(component)) {
            return;
        }
        this.fComponents.add(component);
        String[] recognizedFeatures = component.getRecognizedFeatures();
        this.addRecognizedFeatures(recognizedFeatures);
        String[] recognizedProperties = component.getRecognizedProperties();
        this.addRecognizedProperties(recognizedProperties);
        if (recognizedFeatures != null) {
            i = 0;
            while (i < recognizedFeatures.length) {
                String featureId = recognizedFeatures[i];
                Boolean state = component.getFeatureDefault(featureId);
                if (state != null) {
                    super.setFeature(featureId, state);
                }
                ++i;
            }
        }
        if (recognizedProperties != null) {
            i = 0;
            while (i < recognizedProperties.length) {
                String propertyId = recognizedProperties[i];
                Object value = component.getPropertyDefault(propertyId);
                if (value != null) {
                    super.setProperty(propertyId, value);
                }
                ++i;
            }
        }
    }

    public XMLEntityResolver getEntityResolver() {
        return (XMLEntityResolver)this.fProperties.get(ENTITY_RESOLVER);
    }

    public void setEntityResolver(XMLEntityResolver resolver) {
        this.fProperties.put(ENTITY_RESOLVER, resolver);
    }

    public XMLErrorHandler getErrorHandler() {
        return (XMLErrorHandler)this.fProperties.get(ERROR_HANDLER);
    }

    public void setErrorHandler(XMLErrorHandler errorHandler) {
        this.fProperties.put(ERROR_HANDLER, errorHandler);
    }

    public abstract void parse(XMLInputSource var1) throws XNIException, IOException;

    protected void checkFeature(String featureId) throws XMLConfigurationException {
        int suffixLength;
        if (featureId.startsWith("http://apache.org/xml/features/") && (suffixLength = featureId.length() - "http://apache.org/xml/features/".length()) == "internal/parser-settings".length() && featureId.endsWith("internal/parser-settings")) {
            short type = 1;
            throw new XMLConfigurationException(type, featureId);
        }
        super.checkFeature(featureId);
    }

    protected void checkProperty(String propertyId) throws XMLConfigurationException {
        int suffixLength;
        if (propertyId.startsWith("http://xml.org/sax/properties/") && (suffixLength = propertyId.length() - "http://xml.org/sax/properties/".length()) == "xml-string".length() && propertyId.endsWith("xml-string")) {
            short type = 1;
            throw new XMLConfigurationException(type, propertyId);
        }
        super.checkProperty(propertyId);
    }

    public void setFeature(String featureId, boolean state) throws XMLConfigurationException {
        int count = this.fComponents.size();
        int i = 0;
        while (i < count) {
            XMLComponent c = (XMLComponent)this.fComponents.get(i);
            c.setFeature(featureId, state);
            ++i;
        }
        super.setFeature(featureId, state);
    }

    public Locale getLocale() {
        return this.fLocale;
    }

    public void setLocale(Locale locale) throws XNIException {
        this.fLocale = locale;
    }

    protected BasicParserConfiguration(SymbolTable symbolTable, XMLComponentManager parentSettings) {
        super(parentSettings);
        this.fRecognizedFeatures = new ArrayList();
        this.fRecognizedProperties = new ArrayList();
        this.fFeatures = new Hashtable();
        this.fProperties = new Hashtable();
        String[] recognizedFeatures = new String[]{"http://apache.org/xml/features/internal/parser-settings", VALIDATION, NAMESPACES, EXTERNAL_GENERAL_ENTITIES, EXTERNAL_PARAMETER_ENTITIES};
        this.addRecognizedFeatures(recognizedFeatures);
        this.fFeatures.put("http://apache.org/xml/features/internal/parser-settings", Boolean.TRUE);
        this.fFeatures.put(VALIDATION, Boolean.FALSE);
        this.fFeatures.put(NAMESPACES, Boolean.TRUE);
        this.fFeatures.put(EXTERNAL_GENERAL_ENTITIES, Boolean.TRUE);
        this.fFeatures.put(EXTERNAL_PARAMETER_ENTITIES, Boolean.TRUE);
        String[] recognizedProperties = new String[]{XML_STRING, SYMBOL_TABLE, ERROR_HANDLER, ENTITY_RESOLVER};
        this.addRecognizedProperties(recognizedProperties);
        if (symbolTable == null) {
            symbolTable = new SymbolTable();
        }
        this.fSymbolTable = symbolTable;
        this.fProperties.put(SYMBOL_TABLE, this.fSymbolTable);
    }

    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
        int count = this.fComponents.size();
        int i = 0;
        while (i < count) {
            XMLComponent c = (XMLComponent)this.fComponents.get(i);
            c.setProperty(propertyId, value);
            ++i;
        }
        super.setProperty(propertyId, value);
    }
}

