/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind;

import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionPool;
import com.sun.msv.grammar.Grammar;
import com.sun.xml.bind.DefaultJAXBContextImpl;
import com.sun.xml.bind.GrammarImpl;
import com.sun.xml.bind.GrammarInfo;
import com.sun.xml.bind.Messages;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBException;

class GrammarInfoFacade
extends GrammarInfo {
    private GrammarInfo[] grammarInfos = null;
    private Grammar bgm = null;

    public GrammarInfoFacade(GrammarInfo[] items) throws JAXBException {
        this.grammarInfos = items;
        this.detectRootElementCollisions(this.getProbePoints());
    }

    public Class getRootElement(String namespaceUri, String localName) {
        for (int i = 0; i < this.grammarInfos.length; ++i) {
            Class c = this.grammarInfos[i].getRootElement(namespaceUri, localName);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    public String[] getProbePoints() {
        ArrayList<String> probePointList = new ArrayList<String>();
        for (int i = 0; i < this.grammarInfos.length; ++i) {
            String[] points = this.grammarInfos[i].getProbePoints();
            for (int j = 0; j < points.length; ++j) {
                probePointList.add(points[j]);
            }
        }
        return probePointList.toArray(new String[probePointList.size()]);
    }

    static GrammarInfo createGrammarInfoFacade(String contextPath, ClassLoader classLoader) throws JAXBException {
        ArrayList<GrammarInfo> gis = new ArrayList<GrammarInfo>();
        StringTokenizer st = new StringTokenizer(contextPath, ":;");
        while (st.hasMoreTokens()) {
            String objectFactoryName = st.nextToken() + ".ObjectFactory";
            try {
                DefaultJAXBContextImpl c = (DefaultJAXBContextImpl)((Object)Class.forName(objectFactoryName, true, classLoader).newInstance());
                gis.add(c.getGrammarInfo());
            }
            catch (ClassNotFoundException cnfe) {
                throw new NoClassDefFoundError(cnfe.getMessage());
            }
            catch (Exception e) {
            }
        }
        if (gis.size() == 1) {
            return (GrammarInfo)gis.get(0);
        }
        return new GrammarInfoFacade(gis.toArray(new GrammarInfo[gis.size()]));
    }

    public Class getDefaultImplementation(Class javaContentInterface) {
        for (int i = 0; i < this.grammarInfos.length; ++i) {
            Class c = this.grammarInfos[i].getDefaultImplementation(javaContentInterface);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    public Grammar getGrammar() throws JAXBException {
        if (this.bgm == null) {
            int i;
            Grammar[] grammars = new Grammar[this.grammarInfos.length];
            for (i = 0; i < this.grammarInfos.length; ++i) {
                grammars[i] = this.grammarInfos[i].getGrammar();
            }
            for (i = 0; i < this.grammarInfos.length; ++i) {
                if (!(grammars[i] instanceof GrammarImpl)) continue;
                ((GrammarImpl)grammars[i]).connect(grammars);
            }
            for (i = 0; i < this.grammarInfos.length; ++i) {
                Grammar n = grammars[i];
                this.bgm = this.bgm == null ? n : this.union(this.bgm, n);
            }
        }
        return this.bgm;
    }

    private Grammar union(Grammar g1, Grammar g2) {
        final ExpressionPool pool = g1.getPool();
        final Expression top = pool.createChoice(g1.getTopLevel(), g2.getTopLevel());
        return new Grammar(){

            public ExpressionPool getPool() {
                return pool;
            }

            public Expression getTopLevel() {
                return top;
            }
        };
    }

    private void detectRootElementCollisions(String[] points) throws JAXBException {
        for (int i = 0; i < points.length; i += 2) {
            boolean elementFound = false;
            for (int j = this.grammarInfos.length - 1; j >= 0; --j) {
                if (this.grammarInfos[j].getRootElement(points[i], points[i + 1]) == null) continue;
                if (!elementFound) {
                    elementFound = true;
                    continue;
                }
                throw new JAXBException(Messages.format((String)"GrammarInfoFacade.CollisionDetected", (Object)points[i], (Object)points[i + 1]));
            }
        }
    }
}

